/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unitcontrol;

import com.solegendary.reignofnether.orthoview.OrthoviewClientEvents;
import com.solegendary.reignofnether.unitcontrol.UnitControlManager;
import com.solegendary.reignofnether.unitcontrol.UnitControlReleaseControlPacket;
import com.solegendary.reignofnether.unitcontrol.UnitControlTakeControlPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class UnitControlClientEvents {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static boolean hasControlNotification = false;
    private static int notificationUnitId = -1;
    private static int notificationTicks = 0;
    private static final int NOTIFICATION_DURATION = 100;
    private static final int ATTACK_COOLDOWN_TICKS = 10;
    private static int attackCooldown = 0;
    private static boolean wasAttackPressed = false;
    private static float currentForward = 0.0f;
    private static float currentStrafe = 0.0f;
    private static boolean currentJump = false;
    private static boolean currentSprint = false;
    private static boolean currentSneak = false;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END) {
            return;
        }
        if (attackCooldown > 0) {
            --attackCooldown;
        }
        UnitControlManager.tick();
        if (UnitControlManager.isControllingUnit()) {
            if ((double)Math.abs(currentForward) > 0.01 || (double)Math.abs(currentStrafe) > 0.01 || currentJump) {
                UnitControlManager.handleMovementInput(currentForward, currentStrafe, 0.0f, currentJump, currentSprint, currentSneak);
            }
            if (UnitControlClientEvents.MC.f_91074_ != null && UnitControlManager.getControlledUnit() != null) {
                LivingEntity unit = UnitControlManager.getControlledUnit();
                unit.m_146922_(UnitControlClientEvents.MC.f_91074_.m_146908_());
                unit.m_146926_(UnitControlClientEvents.MC.f_91074_.m_146909_());
                unit.f_19859_ = unit.m_146908_();
                unit.f_19860_ = unit.m_146909_();
            }
        }
        if (hasControlNotification) {
            if (++notificationTicks % 20 == 0 && UnitControlClientEvents.MC.f_91074_ != null) {
                UnitControlClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a76Press TAB to take control of your unit under attack!"));
            }
            if (notificationTicks >= 100) {
                UnitControlClientEvents.clearControlNotification();
            }
        }
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key evt) {
        if (evt.getAction() != 1 || UnitControlClientEvents.MC.f_91074_ == null) {
            return;
        }
        if (evt.getKey() == 258 && hasControlNotification) {
            System.out.println("[UnitControlClient] TAB pressed - taking control");
            UnitControlClientEvents.takeControlOfNotifiedUnit();
        }
        if (evt.getKey() == 256 && UnitControlManager.isControllingUnit()) {
            System.out.println("[UnitControlClient] ESC pressed - releasing control");
            UnitControlReleaseControlPacket.sendToServer();
            UnitControlManager.releaseControl();
        }
    }

    @SubscribeEvent
    public static void onMovementInput(MovementInputUpdateEvent evt) {
        if (!UnitControlManager.isControllingUnit()) {
            return;
        }
        currentForward = evt.getInput().f_108567_;
        currentStrafe = evt.getInput().f_108566_;
        currentJump = evt.getInput().f_108572_;
        currentSprint = UnitControlClientEvents.MC.f_91074_ != null && UnitControlClientEvents.MC.f_91074_.m_20142_();
        boolean bl = currentSneak = UnitControlClientEvents.MC.f_91074_ != null && UnitControlClientEvents.MC.f_91074_.m_6047_();
        if ((double)Math.abs(currentForward) > 0.01 || (double)Math.abs(currentStrafe) > 0.01 || currentJump) {
            System.out.println("[UnitControlClient] Movement input stored - forward: " + currentForward + ", strafe: " + currentStrafe + ", jumping: " + currentJump);
        }
    }

    @SubscribeEvent
    public static void onMouseInput(InputEvent.MouseButton evt) {
        if (!UnitControlManager.isControllingUnit()) {
            return;
        }
        if (evt.getButton() == 0) {
            boolean isPressed;
            boolean bl = isPressed = evt.getAction() == 1;
            if (isPressed && !wasAttackPressed && attackCooldown <= 0) {
                UnitControlManager.handleAttackInput(true);
                attackCooldown = 10;
                LivingEntity unit = UnitControlManager.getControlledUnit();
                if (unit != null) {
                    unit.m_6674_(unit.m_7655_());
                    unit.m_5496_(SoundEvents.f_12317_, 0.8f, 1.0f);
                }
            }
            wasAttackPressed = isPressed;
        }
    }

    public static void handleControlNotification(int unitId, double unitX, double unitY, double unitZ) {
        if (!OrthoviewClientEvents.isEnabled()) {
            return;
        }
        if (UnitControlManager.isControllingUnit()) {
            return;
        }
        hasControlNotification = true;
        notificationUnitId = unitId;
        notificationTicks = 0;
        if (UnitControlClientEvents.MC.f_91074_ != null) {
            UnitControlClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u00a7lUnit Under Attack! \u00a76Press TAB to take control!"));
        }
    }

    private static void takeControlOfNotifiedUnit() {
        System.out.println("[UnitControlClient] takeControlOfNotifiedUnit called - hasNotification: " + hasControlNotification);
        if (!hasControlNotification) {
            return;
        }
        if (UnitControlClientEvents.MC.f_91073_ == null) {
            System.out.println("[UnitControlClient] MC.level is null");
            return;
        }
        System.out.println("[UnitControlClient] Looking for entity with ID: " + notificationUnitId);
        Entity entity = UnitControlClientEvents.MC.f_91073_.m_6815_(notificationUnitId);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            System.out.println("[UnitControlClient] Found entity: " + entity.getClass().getSimpleName() + " at " + String.valueOf(entity.m_20182_()));
            UnitControlTakeControlPacket.sendToServer(entity.m_19879_());
            boolean success = UnitControlManager.takeControlOfUnit(livingEntity);
            if (success) {
                UnitControlClientEvents.clearControlNotification();
                if (UnitControlClientEvents.MC.f_91074_ != null) {
                    UnitControlClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7aYou are now controlling the unit! Press ESC to exit."));
                }
            } else {
                System.out.println("[UnitControlClient] Failed to take control");
                if (UnitControlClientEvents.MC.f_91074_ != null) {
                    UnitControlClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)"\u00a7cCannot take control of this unit."));
                }
            }
        } else {
            System.out.println("[UnitControlClient] Entity not found or not LivingEntity: " + String.valueOf(entity));
        }
    }

    private static void clearControlNotification() {
        hasControlNotification = false;
        notificationUnitId = -1;
        notificationTicks = 0;
    }

    public static boolean hasActiveNotification() {
        return hasControlNotification;
    }

    public static void reset() {
        UnitControlClientEvents.clearControlNotification();
        UnitControlManager.forceReleaseControl();
        wasAttackPressed = false;
    }
}

