/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unitcontrol;

import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.unitcontrol.UnitControlClientEvents;
import com.solegendary.reignofnether.unitcontrol.UnitControlManager;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class UnitControlClientboundPacket {
    private final PacketType type;
    private final int unitId;
    private final double unitX;
    private final double unitY;
    private final double unitZ;

    public UnitControlClientboundPacket(PacketType type, int unitId, double unitX, double unitY, double unitZ) {
        this.type = type;
        this.unitId = unitId;
        this.unitX = unitX;
        this.unitY = unitY;
        this.unitZ = unitZ;
    }

    public UnitControlClientboundPacket(FriendlyByteBuf buf) {
        this.type = (PacketType)buf.m_130066_(PacketType.class);
        this.unitId = buf.readInt();
        this.unitX = buf.readDouble();
        this.unitY = buf.readDouble();
        this.unitZ = buf.readDouble();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.type);
        buf.writeInt(this.unitId);
        buf.writeDouble(this.unitX);
        buf.writeDouble(this.unitY);
        buf.writeDouble(this.unitZ);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        AtomicBoolean success = new AtomicBoolean(false);
        context.enqueueWork(() -> {
            switch (this.type) {
                case CONTROL_NOTIFICATION: {
                    UnitControlClientEvents.handleControlNotification(this.unitId, this.unitX, this.unitY, this.unitZ);
                    success.set(true);
                    break;
                }
                case CONTROL_UPDATE: {
                    success.set(true);
                    break;
                }
                case CONTROL_RELEASE: {
                    UnitControlManager.forceReleaseControl();
                    success.set(true);
                }
            }
        });
        context.setPacketHandled(success.get());
        return success.get();
    }

    public static void sendControlNotification(ServerPlayer player, LivingEntity unit) {
        UnitControlClientboundPacket packet = new UnitControlClientboundPacket(PacketType.CONTROL_NOTIFICATION, unit.m_19879_(), unit.m_20185_(), unit.m_20186_(), unit.m_20189_());
        PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
    }

    public static void sendForceRelease(ServerPlayer player) {
        UnitControlClientboundPacket packet = new UnitControlClientboundPacket(PacketType.CONTROL_RELEASE, -1, 0.0, 0.0, 0.0);
        PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
    }

    public static enum PacketType {
        CONTROL_NOTIFICATION,
        CONTROL_UPDATE,
        CONTROL_RELEASE;

    }
}

