/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unitcontrol;

import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unitcontrol.UnitControlMovementPacket;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class UnitControlInputHandler {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static final double BASE_MOVE_SPEED = 0.4;
    private static final double MAX_MOVE_SPEED = 0.4;
    private static final double SPRINT_MULTIPLIER = 1.8;
    private static final double SNEAK_MULTIPLIER = 0.3;
    private static final double POSITION_UPDATE_FACTOR = 0.9;
    private static int inputDebugCounter = 0;

    public static void applyMovementInput(LivingEntity unit, float forward, float strafe, float up, boolean jump, boolean sprint, boolean sneak) {
        Mob mob;
        block12: {
            block11: {
                if (!(unit instanceof Mob)) break block11;
                mob = (Mob)unit;
                if (UnitControlInputHandler.MC.f_91074_ != null) break block12;
            }
            return;
        }
        Vec3 inputVector = new Vec3((double)strafe, 0.0, (double)forward);
        if (inputVector.m_165925_() > 0.01 && ++inputDebugCounter % 10 == 0) {
            System.out.println("[UnitInputHandler] Received input - forward: " + forward + ", strafe: " + strafe + ", jump: " + jump);
        }
        if (inputVector.m_165925_() < 0.01) {
            mob.m_20256_(mob.m_20184_().m_82542_(0.8, 1.0, 0.8));
            return;
        }
        inputVector = inputVector.m_82541_();
        float unitYRot = mob.m_146908_();
        float cameraYRot = UnitControlInputHandler.MC.f_91063_.m_109153_().m_90590_();
        Vec3 movement = inputVector.m_82524_(-cameraYRot * ((float)Math.PI / 180));
        System.out.println("[UnitInputHandler] Movement calc - unitYRot: " + String.format("%.1f", Float.valueOf(unitYRot)) + ", cameraYRot: " + String.format("%.1f", Float.valueOf(cameraYRot)) + ", movement: " + String.valueOf(movement));
        double moveSpeed = Math.min(0.4, 0.4);
        AttributeInstance speedAttribute = mob.m_21051_(Attributes.f_22279_);
        if (speedAttribute != null) {
            moveSpeed = Math.min(speedAttribute.m_22135_(), 0.4);
        }
        if (sprint) {
            moveSpeed *= 1.8;
        } else if (sneak) {
            moveSpeed *= 0.3;
        }
        Vec3 movementInput = inputVector.m_82541_().m_82524_(-cameraYRot * ((float)Math.PI / 180)).m_82490_(moveSpeed);
        UnitControlMovementPacket.sendToServer(forward, strafe, up, jump, sprint, sneak);
        if (movementInput.m_165925_() > 0.01) {
            float newYRot = (float)Math.atan2(-movementInput.f_82479_, movementInput.f_82481_) * 57.295776f;
            mob.m_146922_(newYRot);
            mob.f_19859_ = newYRot;
        }
        if (jump && mob.m_20096_()) {
            mob.m_20256_(mob.m_20184_().m_82520_(0.0, 0.4, 0.0));
        }
    }

    public static void handleAttackInput(LivingEntity unit) {
        if (UnitControlInputHandler.MC.f_91074_ == null || !(unit instanceof AttackerUnit)) {
            return;
        }
        AttackerUnit attackerUnit = (AttackerUnit)unit;
        double range = attackerUnit.getAttackRange();
        float damage = attackerUnit.getUnitAttackDamage();
        Vec3 startPos = unit.m_146892_();
        Vec3 lookVec = UnitControlInputHandler.MC.f_91074_.m_20154_();
        Vec3 endPos = startPos.m_82549_(lookVec.m_82490_(range));
        if (UnitControlInputHandler.MC.f_91073_ != null) {
            UnitControlInputHandler.MC.f_91061_.m_107332_((Entity)unit, (ParticleOptions)ParticleTypes.f_123766_, 5);
            UnitControlInputHandler.MC.f_91073_.m_7106_((ParticleOptions)ParticleTypes.f_123809_, startPos.f_82479_, startPos.f_82480_, startPos.f_82481_, endPos.f_82479_ - startPos.f_82479_, endPos.f_82480_ - startPos.f_82480_, endPos.f_82481_ - startPos.f_82481_);
        }
        List targets = unit.m_9236_().m_6443_(LivingEntity.class, new AABB(unit.m_20183_()).m_82400_(range), entity -> entity != unit && entity.m_6084_());
        LivingEntity target = null;
        double bestDot = 0.7;
        for (LivingEntity potentialTarget : targets) {
            Vec3 toTarget = potentialTarget.m_20182_().m_82546_(unit.m_20182_()).m_82541_();
            double dot = lookVec.m_82526_(toTarget);
            if (!(dot > bestDot) || !((double)unit.m_20270_((Entity)potentialTarget) <= range)) continue;
            bestDot = dot;
            target = potentialTarget;
        }
        if (target != null) {
            attackerUnit.setUnitAttackTarget(target);
            target.f_19802_ = 0;
            target.m_6469_(unit.m_269291_().m_269333_(unit), damage);
            Vec3 knockback = target.m_20182_().m_82546_(unit.m_20182_()).m_82541_().m_82490_(0.2);
            target.m_20256_(target.m_20184_().m_82549_(knockback));
            if (UnitControlInputHandler.MC.f_91073_ != null) {
                UnitControlInputHandler.MC.f_91073_.m_7106_((ParticleOptions)ParticleTypes.f_123798_, target.m_20185_(), target.m_20186_() + (double)(target.m_20206_() / 2.0f), target.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    public static void syncPlayerWithUnit(LivingEntity unit) {
    }
}

