/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unitcontrol;

import com.solegendary.reignofnether.orthoview.CameraManager;
import com.solegendary.reignofnether.orthoview.OrthoviewClientEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unitcontrol.UnitControlInputHandler;
import com.solegendary.reignofnether.unitcontrol.UnitControlTransitions;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;

public class UnitControlManager {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static LivingEntity controlledUnit = null;
    private static boolean wasOrthoviewEnabled = false;
    private static Vec3 previousCameraPos = Vec3.f_82478_;
    private static boolean isControllingUnit = false;
    private static UnitControlMode controlMode = UnitControlMode.DISABLED;
    private static int ticksInControl = 0;
    private static final int MAX_CONTROL_TICKS = 300;
    private static final Map<UUID, Integer> serverControlledUnits = new ConcurrentHashMap<UUID, Integer>();

    public static boolean isControllingUnit() {
        return isControllingUnit && controlledUnit != null && controlledUnit.m_6084_();
    }

    public static LivingEntity getControlledUnit() {
        return controlledUnit;
    }

    public static UnitControlMode getControlMode() {
        return controlMode;
    }

    public static boolean takeControlOfUnit(LivingEntity unit) {
        System.out.println("[UnitControl] takeControlOfUnit called for unit: " + unit.getClass().getSimpleName());
        if (!(unit instanceof Unit) || !(unit instanceof Mob)) {
            System.out.println("[UnitControl] Unit is not valid type: " + unit.getClass().getSimpleName());
            return false;
        }
        if (isControllingUnit || !OrthoviewClientEvents.isEnabled()) {
            System.out.println("[UnitControl] Cannot take control - already controlling: " + isControllingUnit + ", orthoview enabled: " + OrthoviewClientEvents.isEnabled());
            return false;
        }
        System.out.println("[UnitControl] Taking control of unit at position: " + String.valueOf(unit.m_20182_()));
        UnitControlManager.storePreviousCameraState();
        System.out.println("[UnitControl] Temporarily disabling orthoview for unit control");
        if (OrthoviewClientEvents.isEnabled()) {
            OrthoviewClientEvents.toggleEnable();
            System.out.println("[UnitControl] Orthoview disabled: " + !OrthoviewClientEvents.isEnabled());
        }
        controlledUnit = unit;
        isControllingUnit = true;
        controlMode = UnitControlMode.FIRST_PERSON;
        ticksInControl = 0;
        System.out.println("[UnitControl] Control state set - isControllingUnit: " + isControllingUnit);
        UnitControlManager.disableUnitAI((Unit)unit);
        MC.m_91118_((Entity)unit);
        UnitControlManager.MC.f_91066_.m_92157_(CameraType.FIRST_PERSON);
        System.out.println("[UnitControl] Set camera entity to unit: " + unit.getClass().getSimpleName());
        System.out.println("[UnitControl] Successfully took control of unit");
        return true;
    }

    public static void releaseControl() {
        System.out.println("[UnitControl] releaseControl called - isControllingUnit: " + isControllingUnit + ", controlledUnit: " + (controlledUnit != null ? controlledUnit.getClass().getSimpleName() : "null"));
        if (!isControllingUnit || controlledUnit == null) {
            System.out.println("[UnitControl] Nothing to release");
            return;
        }
        System.out.println("[UnitControl] Releasing control of unit");
        LivingEntity livingEntity = controlledUnit;
        if (livingEntity instanceof Unit) {
            Unit unit = (Unit)livingEntity;
            UnitControlManager.enableUnitAI(unit);
        }
        if (UnitControlManager.MC.f_91074_ != null) {
            MC.m_91118_((Entity)UnitControlManager.MC.f_91074_);
            System.out.println("[UnitControl] Restored camera entity to player");
        }
        System.out.println("[UnitControl] Re-enabling orthoview");
        if (wasOrthoviewEnabled && !OrthoviewClientEvents.isEnabled()) {
            OrthoviewClientEvents.toggleEnable();
            System.out.println("[UnitControl] Orthoview re-enabled: " + OrthoviewClientEvents.isEnabled());
        }
        controlledUnit = null;
        isControllingUnit = false;
        controlMode = UnitControlMode.DISABLED;
        ticksInControl = 0;
        System.out.println("[UnitControl] Control released - isControllingUnit: " + isControllingUnit);
    }

    public static void tick() {
        if (!isControllingUnit) {
            return;
        }
        if (ticksInControl % 20 == 0) {
            System.out.println("[UnitControl] Tick " + ticksInControl + " - controlling: " + isControllingUnit + ", unit alive: " + (controlledUnit != null && controlledUnit.m_6084_()) + ", camera locked: " + OrthoviewClientEvents.isCameraLocked() + ", transitioning: " + UnitControlTransitions.isTransitioning() + ", camera type: " + String.valueOf(UnitControlManager.MC.f_91066_.m_92176_()));
        }
        if (controlledUnit == null || !controlledUnit.m_6084_()) {
            System.out.println("[UnitControl] Unit died or became null, releasing control");
            UnitControlManager.releaseControl();
            return;
        }
        if (UnitControlManager.MC.f_91066_.m_92176_() != CameraType.FIRST_PERSON) {
            System.out.println("[UnitControl] Camera switched to " + String.valueOf(UnitControlManager.MC.f_91066_.m_92176_()) + ", forcing back to FIRST_PERSON");
            UnitControlManager.MC.f_91066_.m_92157_(CameraType.FIRST_PERSON);
        }
        UnitControlManager.MC.f_91066_.m_92157_(CameraType.FIRST_PERSON);
        if (++ticksInControl >= 300) {
            System.out.println("[UnitControl] Timeout reached, releasing control");
            UnitControlManager.releaseControl();
        }
    }

    public static void forceReleaseControl() {
        if (isControllingUnit) {
            OrthoviewClientEvents.unlockCam();
            UnitControlManager.releaseControl();
        }
    }

    private static void storePreviousCameraState() {
        wasOrthoviewEnabled = OrthoviewClientEvents.isEnabled();
        System.out.println("[UnitControl] Stored camera state - orthoview was: " + wasOrthoviewEnabled);
        if (UnitControlManager.MC.f_91074_ != null) {
            previousCameraPos = UnitControlManager.MC.f_91074_.m_20182_();
        }
    }

    private static void restorePreviousCameraState() {
        if (wasOrthoviewEnabled) {
            UnitControlManager.MC.f_91066_.m_92157_(CameraType.FIRST_PERSON);
            UnitControlTransitions.startTransitionToOrthoview(previousCameraPos, CameraManager.getCamRotX(), CameraManager.getCamRotY());
        }
    }

    private static void disableUnitAI(Unit unit) {
        Unit.fullResetBehaviours(unit);
        if (unit instanceof Mob) {
            Mob mob = (Mob)unit;
            mob.f_21345_.m_262460_(goal -> true);
            mob.f_21346_.m_262460_(goal -> true);
            System.out.println("[UnitControl] Cleared all AI goals from unit");
        }
    }

    private static void enableUnitAI(Unit unit) {
        unit.initialiseGoals();
        System.out.println("[UnitControl] Re-initialized AI goals for unit");
    }

    public static void handleMovementInput(float forward, float strafe, float up, boolean jump) {
        UnitControlManager.handleMovementInput(forward, strafe, up, jump, false, false);
    }

    public static void handleMovementInput(float forward, float strafe, float up, boolean jump, boolean sprint, boolean sneak) {
        if (!isControllingUnit || controlledUnit == null) {
            return;
        }
        if ((double)Math.abs(forward) > 0.01 || (double)Math.abs(strafe) > 0.01 || jump) {
            System.out.println("[UnitControl] handleMovementInput called - forward: " + forward + ", strafe: " + strafe + ", jump: " + jump);
        }
        UnitControlInputHandler.applyMovementInput(controlledUnit, forward, strafe, up, jump, sprint, sneak);
    }

    public static void handleAttackInput(boolean isAttacking) {
        if (!isControllingUnit || controlledUnit == null) {
            return;
        }
        if (isAttacking) {
            UnitControlInputHandler.handleAttackInput(controlledUnit);
        }
    }

    public static void handleServerMovementInput(float forward, float strafe, float up, boolean jump, boolean sprint, boolean sneak, ServerPlayer sender) {
        LivingEntity unit = UnitControlManager.findControlledUnitForPlayer(sender);
        if (unit == null) {
            return;
        }
        UnitControlInputHandler.applyMovementInput(unit, forward, strafe, up, jump, sprint, sneak);
    }

    public static boolean serverTakeControlOfUnit(ServerPlayer player, LivingEntity unit) {
        if (player == null || unit == null) {
            return false;
        }
        serverControlledUnits.put(player.m_20148_(), unit.m_19879_());
        return true;
    }

    public static void serverReleaseControlOfUnit(ServerPlayer player) {
        if (player == null) {
            return;
        }
        serverControlledUnits.remove(player.m_20148_());
    }

    public static boolean onPlayerTakesControl(ServerPlayer player, LivingEntity unit) {
        return UnitControlManager.serverTakeControlOfUnit(player, unit);
    }

    public static void onPlayerReleasesControl(ServerPlayer player) {
        UnitControlManager.serverReleaseControlOfUnit(player);
    }

    private static LivingEntity findControlledUnitForPlayer(ServerPlayer sender) {
        if (sender == null || sender.m_9236_() == null) {
            return null;
        }
        Integer entityId = serverControlledUnits.get(sender.m_20148_());
        if (entityId == null) {
            return null;
        }
        Entity entity = sender.m_9236_().m_6815_(entityId.intValue());
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return living;
        }
        return null;
    }

    public static boolean canControlUnit(LivingEntity entity) {
        return entity instanceof Unit && entity instanceof Mob && entity.m_6084_() && OrthoviewClientEvents.isEnabled();
    }

    public static boolean shouldSkipOrthoviewUpdates() {
        return false;
    }

    public static enum UnitControlMode {
        DISABLED,
        FIRST_PERSON,
        THIRD_PERSON_CLOSE;

    }
}

