/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unitcontrol;

import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.unitcontrol.UnitControlManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class UnitControlMovementPacket {
    private final float forward;
    private final float strafe;
    private final float up;
    private final boolean jump;
    private final boolean sprint;
    private final boolean sneak;

    public UnitControlMovementPacket(float forward, float strafe, float up, boolean jump, boolean sprint, boolean sneak) {
        this.forward = forward;
        this.strafe = strafe;
        this.up = up;
        this.jump = jump;
        this.sprint = sprint;
        this.sneak = sneak;
    }

    public UnitControlMovementPacket(FriendlyByteBuf buf) {
        this.forward = buf.readFloat();
        this.strafe = buf.readFloat();
        this.up = buf.readFloat();
        this.jump = buf.readBoolean();
        this.sprint = buf.readBoolean();
        this.sneak = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeFloat(this.forward);
        buf.writeFloat(this.strafe);
        buf.writeFloat(this.up);
        buf.writeBoolean(this.jump);
        buf.writeBoolean(this.sprint);
        buf.writeBoolean(this.sneak);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> UnitControlManager.handleServerMovementInput(this.forward, this.strafe, this.up, this.jump, this.sprint, this.sneak, context.getSender()));
        context.setPacketHandled(true);
        return true;
    }

    public static void sendToServer(float forward, float strafe, float up, boolean jump, boolean sprint, boolean sneak) {
        UnitControlMovementPacket packet = new UnitControlMovementPacket(forward, strafe, up, jump, sprint, sneak);
        PacketHandler.INSTANCE.sendToServer((Object)packet);
    }
}

