/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unitcontrol;

import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.unitcontrol.UnitControlManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class UnitControlTakeControlPacket {
    private final int unitId;

    public UnitControlTakeControlPacket(int unitId) {
        this.unitId = unitId;
    }

    public UnitControlTakeControlPacket(FriendlyByteBuf buf) {
        this.unitId = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.unitId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            Entity entity;
            ServerPlayer sender = context.getSender();
            if (sender != null && sender.m_9236_() != null && (entity = sender.m_9236_().m_6815_(this.unitId)) instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                UnitControlManager.onPlayerTakesControl(sender, living);
            }
        });
        context.setPacketHandled(true);
        return true;
    }

    public static void sendToServer(int unitId) {
        UnitControlTakeControlPacket packet = new UnitControlTakeControlPacket(unitId);
        PacketHandler.INSTANCE.sendToServer((Object)packet);
    }
}

