/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unitcontrol;

import com.solegendary.reignofnether.orthoview.CameraTransitions;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class UnitControlTransitions {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static boolean isTransitioning = false;
    private static int transitionTicks = 0;
    private static final int TRANSITION_DURATION = 30;
    private static Vec3 startPos = Vec3.f_82478_;
    private static Vec3 targetPos = Vec3.f_82478_;
    private static float startYaw = 0.0f;
    private static float targetYaw = 0.0f;
    private static float startPitch = 0.0f;
    private static float targetPitch = 0.0f;

    public static void startTransitionToUnit(LivingEntity unit) {
        if (UnitControlTransitions.MC.f_91074_ == null) {
            return;
        }
        startPos = UnitControlTransitions.MC.f_91074_.m_20182_();
        startYaw = UnitControlTransitions.MC.f_91074_.m_146908_();
        startPitch = UnitControlTransitions.MC.f_91074_.m_146909_();
        targetPos = unit.m_20182_().m_82520_(0.0, (double)unit.m_20192_(), 0.0);
        targetYaw = unit.m_146908_();
        targetPitch = 0.0f;
        System.out.println("[UnitTransitions] Starting transition from " + String.valueOf(startPos) + " to " + String.valueOf(targetPos));
        System.out.println("[UnitTransitions] Rotation from " + startYaw + "," + startPitch + " to " + targetYaw + "," + targetPitch);
        isTransitioning = true;
        transitionTicks = 0;
    }

    public static void startTransitionToOrthoview(Vec3 orthoPos, float orthoYaw, float orthoPitch) {
        if (UnitControlTransitions.MC.f_91074_ == null) {
            return;
        }
        startPos = UnitControlTransitions.MC.f_91074_.m_20182_();
        startYaw = UnitControlTransitions.MC.f_91074_.m_146908_();
        startPitch = UnitControlTransitions.MC.f_91074_.m_146909_();
        targetPos = orthoPos;
        targetYaw = orthoYaw;
        targetPitch = orthoPitch;
        isTransitioning = true;
        transitionTicks = 0;
    }

    public static void tick() {
        if (!isTransitioning || UnitControlTransitions.MC.f_91074_ == null) {
            return;
        }
        float progress = (float)(++transitionTicks) / 30.0f;
        if (transitionTicks % 10 == 0) {
            System.out.println("[UnitTransitions] Transition progress: " + String.format("%.2f", Float.valueOf(progress)) + " (" + transitionTicks + "/30)");
        }
        if (progress >= 1.0f) {
            progress = 1.0f;
            isTransitioning = false;
            System.out.println("[UnitTransitions] Transition complete - final pos: " + String.valueOf(targetPos));
            UnitControlTransitions.MC.f_91074_.m_146884_(targetPos);
            UnitControlTransitions.MC.f_91074_.m_146922_(targetYaw);
            UnitControlTransitions.MC.f_91074_.m_146926_(targetPitch);
        } else {
            float smoothProgress = CameraTransitions.smootherStep(progress);
            Vec3 currentPos = startPos.m_165921_(targetPos, (double)smoothProgress);
            UnitControlTransitions.MC.f_91074_.m_146884_(currentPos);
            float currentYaw = UnitControlTransitions.lerpAngle(startYaw, targetYaw, smoothProgress);
            float currentPitch = startPitch + (targetPitch - startPitch) * smoothProgress;
            UnitControlTransitions.MC.f_91074_.m_146922_(currentYaw);
            UnitControlTransitions.MC.f_91074_.m_146926_(currentPitch);
        }
    }

    public static boolean isTransitioning() {
        return isTransitioning;
    }

    public static void forceEndTransition() {
        if (isTransitioning && UnitControlTransitions.MC.f_91074_ != null) {
            UnitControlTransitions.MC.f_91074_.m_146884_(targetPos);
            UnitControlTransitions.MC.f_91074_.m_146922_(targetYaw);
            UnitControlTransitions.MC.f_91074_.m_146926_(targetPitch);
        }
        isTransitioning = false;
        transitionTicks = 0;
    }

    private static float lerpAngle(float start, float target, float progress) {
        float diff;
        for (diff = target - start; diff > 180.0f; diff -= 360.0f) {
        }
        while (diff < -180.0f) {
            diff += 360.0f;
        }
        return start + diff * progress;
    }

    public static void reset() {
        isTransitioning = false;
        transitionTicks = 0;
        startPos = Vec3.f_82478_;
        targetPos = Vec3.f_82478_;
        startYaw = 0.0f;
        targetYaw = 0.0f;
        startPitch = 0.0f;
        targetPitch = 0.0f;
    }
}

