/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.util;

import com.mojang.datafixers.util.Pair;
import com.solegendary.reignofnether.alliance.AlliancesClient;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.GarrisonableBuilding;
import com.solegendary.reignofnether.building.buildings.placements.BridgePlacement;
import com.solegendary.reignofnether.cursor.CursorClientEvents;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.orthoview.OrthoviewClientEvents;
import com.solegendary.reignofnether.registrars.GameRuleRegistrar;
import com.solegendary.reignofnether.resources.BlockUtils;
import com.solegendary.reignofnether.time.NightCircleMode;
import com.solegendary.reignofnether.time.TimeClientEvents;
import com.solegendary.reignofnether.unit.Checkpoint;
import com.solegendary.reignofnether.unit.Relationship;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.goals.AbstractMeleeAttackUnitGoal;
import com.solegendary.reignofnether.unit.goals.FlyingMoveToTargetGoal;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.monsters.PhantomSummon;
import com.solegendary.reignofnether.unit.units.piglins.GhastUnit;
import com.solegendary.reignofnether.util.MyMath;
import com.solegendary.reignofnether.util.MyRenderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.text.WordUtils;
import org.joml.Vector3d;
import org.lwjgl.glfw.GLFW;

public class MiscUtil {
    public static void shootFirework(Level level, Vec3 vec3) {
        CompoundTag explosion = new CompoundTag();
        explosion.m_128365_("Colors", (Tag)new IntArrayTag(new int[]{0xF0F0F0}));
        explosion.m_128344_("Type", (byte)0);
        ListTag explosions = new ListTag();
        explosions.add((Object)explosion);
        CompoundTag explosionsAndFlight = new CompoundTag();
        explosionsAndFlight.m_128365_("Explosions", (Tag)explosions);
        explosionsAndFlight.m_128344_("Flight", (byte)1);
        CompoundTag fireworks = new CompoundTag();
        fireworks.m_128365_("Fireworks", (Tag)explosionsAndFlight);
        ItemStack itemStack = new ItemStack((ItemLike)Items.f_42688_);
        itemStack.m_41751_(fireworks);
        FireworkRocketEntity entity = new FireworkRocketEntity(level, null, vec3.f_82479_, vec3.m_7098_(), vec3.f_82481_, itemStack);
        level.m_7967_((Entity)entity);
        entity.m_20219_(vec3);
    }

    public static boolean isGroundBlock(Level level, BlockPos bp) {
        BlockState bs = level.m_8055_(bp);
        Block block = bs.m_60734_();
        return !BlockUtils.isLogBlock(bs) && !BlockUtils.isLeafBlock(bs) && !bs.m_60795_() && !BuildingUtils.isPosInsideAnyBuilding(level.m_5776_(), bp);
    }

    public static void addUnitCheckpoint(Unit unit, BlockPos blockPos, boolean green) {
        if (((Entity)unit).m_9236_().m_5776_()) {
            boolean clearExisting;
            boolean bl = clearExisting = !Keybindings.shiftMod.isDown();
            if (clearExisting) {
                unit.getCheckpoints().clear();
            }
            unit.getCheckpoints().add(new Checkpoint(blockPos, green));
        }
    }

    public static void addUnitCheckpoint(Unit unit, int id, boolean green) {
        Level level = ((Entity)unit).m_9236_();
        if (level.m_5776_() && !Keybindings.shiftMod.isDown()) {
            unit.getCheckpoints().clear();
            unit.getCheckpoints().add(new Checkpoint(level.m_6815_(id), green));
        }
    }

    public static BlockPos getHighestGroundBlock(Level level, BlockPos blockPos) {
        BlockPos bp;
        BlockState bs;
        int y = level.m_141928_();
        while (((bs = level.m_8055_(bp = new BlockPos(blockPos.m_123341_(), y, blockPos.m_123343_()))).m_60795_() || BuildingUtils.isPosInsideAnyBuilding(level.f_46443_, bp) || bs.m_60734_() == Blocks.f_152480_ || bs.m_60734_() == Blocks.f_50454_ || !MiscUtil.isSolidBlocking(level, bp) && bs.m_60819_().m_76178_() || bs.m_204336_(BlockTags.f_13035_) || bs.m_204336_(BlockTags.f_13106_) || bs.m_204336_(BlockTags.f_13090_)) && --y > -63) {
        }
        return new BlockPos(blockPos.m_123341_(), y, blockPos.m_123343_());
    }

    public static BlockPos getHighestNonAirBlock(Level level, BlockPos blockPos, boolean ignoreLeaves) {
        BlockPos bp;
        BlockState bs;
        int y = level.m_141928_();
        while (((bs = level.m_8055_(bp = new BlockPos(blockPos.m_123341_(), y, blockPos.m_123343_()))).m_60795_() || bs.m_60734_() == Blocks.f_152480_ || bs.m_60734_() == Blocks.f_50454_ || !MiscUtil.isSolidBlocking(level, bp) && bs.m_60819_().m_76178_() || ignoreLeaves && bs.m_204336_(BlockTags.f_13035_)) && --y > -63) {
        }
        return new BlockPos(blockPos.m_123341_(), y, blockPos.m_123343_());
    }

    public static BlockPos getHighestNonAirBlock(Level level, BlockPos blockPos) {
        return MiscUtil.getHighestNonAirBlock(level, blockPos, false);
    }

    public static boolean listContainsObjectValue(List<Object> objs, String obj) {
        return objs.stream().anyMatch(o -> o.equals(obj));
    }

    public static boolean isLeftClickDown(Minecraft MC) {
        return GLFW.glfwGetMouseButton((long)MC.m_91268_().m_85439_(), (int)0) == 1;
    }

    public static boolean isRightClickDown(Minecraft MC) {
        return GLFW.glfwGetMouseButton((long)MC.m_91268_().m_85439_(), (int)1) == 1;
    }

    public static Vector3d screenPosToWorldPos(Minecraft MC, int mouseX, int mouseY) {
        if (MC.f_91074_ == null) {
            return new Vector3d(0.0, 0.0, 0.0);
        }
        int winWidth = MC.m_91268_().m_85445_();
        int winHeight = MC.m_91268_().m_85446_();
        float pixelsToBlocks = (float)winHeight / OrthoviewClientEvents.getZoom();
        float x = ((float)mouseX - (float)winWidth / 2.0f) / pixelsToBlocks;
        float y = 0.0f;
        float z = ((float)mouseY - (float)winHeight / 2.0f) / pixelsToBlocks;
        double camRotYRads = Math.toRadians(OrthoviewClientEvents.getCamRotY());
        Vec2 XZRotated = MyMath.rotateCoords(x, z /= (float)Math.sin(camRotYRads), OrthoviewClientEvents.getCamRotX());
        return new Vector3d(MC.f_91074_.f_19854_ - (double)XZRotated.f_82470_, MC.f_91074_.f_19855_ + (double)y + 1.5, MC.f_91074_.f_19856_ - (double)XZRotated.f_82471_);
    }

    public static boolean isMobInRangeOfPos(BlockPos pos, LivingEntity mob, float range) {
        Vec2 pos2d = new Vec2((float)pos.m_123341_() + 0.5f, (float)pos.m_123343_() + 0.5f);
        Vec2 mob2d = new Vec2((float)mob.m_20185_(), (float)mob.m_20189_());
        return pos.m_203198_(mob.m_20185_(), mob.m_20186_(), mob.m_20189_()) < (double)(range * range) || pos2d.m_165914_(mob2d) < range * range && (double)pos.m_123342_() - mob.m_20186_() < 16.0;
    }

    public static ArrayList<BlockPos> findAdjacentBlocks(BlockPos originPos, Predicate<BlockPos> condition) {
        ArrayList<BlockPos> adjBps = new ArrayList<BlockPos>();
        ArrayList<BlockPos> retBps = new ArrayList<BlockPos>();
        adjBps.add(originPos.m_7494_());
        adjBps.add(originPos.m_7495_());
        adjBps.add(originPos.m_122012_());
        adjBps.add(originPos.m_122019_());
        adjBps.add(originPos.m_122029_());
        adjBps.add(originPos.m_122024_());
        Collections.shuffle(adjBps);
        for (BlockPos bp : adjBps) {
            if (!condition.test(bp)) continue;
            retBps.add(bp);
        }
        return retBps;
    }

    public static LivingEntity findClosestAttackableEntity(Mob unitMob, float range, ServerLevel level) {
        Vector3d unitPosition = new Vector3d(unitMob.m_20182_().f_82479_, unitMob.m_20182_().f_82480_, unitMob.m_20182_().f_82481_);
        List<LivingEntity> nearbyEntities = MiscUtil.getEntitiesWithinRange(unitPosition, range, LivingEntity.class, (Level)level);
        double closestDist = range;
        LivingEntity closestTarget = null;
        boolean neutralAggro = ((GameRules.BooleanValue)unitMob.m_9236_().m_46469_().m_46170_(GameRuleRegistrar.NEUTRAL_AGGRO)).m_46223_();
        for (LivingEntity tle : nearbyEntities) {
            double dist;
            if (!MiscUtil.isIdleOrMoveAttackable(unitMob, tle, neutralAggro) || !MiscUtil.hasLineOfSightForAttacks(unitMob, tle) || !((dist = unitMob.m_20182_().m_82554_(tle.m_20182_())) < closestDist)) continue;
            closestDist = dist;
            closestTarget = tle;
        }
        return closestTarget;
    }

    private static boolean isIdleOrMoveAttackable(Mob unitMob, LivingEntity targetEntity, boolean neutralAggro) {
        AttackerUnit attackerUnit;
        Player player;
        Unit unit;
        Relationship rs = Relationship.NEUTRAL;
        if (unitMob instanceof Unit) {
            Unit targetUnit;
            unit = (Unit)unitMob;
            rs = UnitServerEvents.getUnitToEntityRelationship((Unit)unitMob, (Entity)targetEntity);
            if (targetEntity instanceof Unit && (targetUnit = (Unit)targetEntity).getOwnerName().equals("Blood Moon") && unitMob instanceof GhastUnit) {
                return false;
            }
        }
        if (targetEntity instanceof Player && ((player = (Player)targetEntity).m_7500_() || player.m_5833_())) {
            return false;
        }
        if (rs == Relationship.FRIENDLY) {
            return false;
        }
        if (targetEntity instanceof Unit && (unit = (Unit)targetEntity).getMoveGoal() instanceof FlyingMoveToTargetGoal && unitMob instanceof AttackerUnit && (attackerUnit = (AttackerUnit)unitMob).getAttackGoal() instanceof AbstractMeleeAttackUnitGoal) {
            return false;
        }
        boolean isPassiveNonUnit = !(targetEntity instanceof Unit) && (targetEntity instanceof Animal || targetEntity instanceof AbstractFish || targetEntity instanceof Villager);
        boolean canAttackNeutral = rs == Relationship.NEUTRAL && neutralAggro && !(targetEntity instanceof Vex) && !(targetEntity instanceof ArmorStand) && !(targetEntity instanceof PhantomSummon) && !isPassiveNonUnit;
        return (rs == Relationship.HOSTILE || canAttackNeutral) && targetEntity.m_19879_() != unitMob.m_19879_();
    }

    public static BuildingPlacement findClosestAttackableBuilding(Mob unitMob, float range, ServerLevel level) {
        List<BuildingPlacement> buildings = unitMob.m_9236_().m_5776_() ? BuildingClientEvents.getBuildings() : BuildingServerEvents.getBuildings();
        double closestDist = range;
        BuildingPlacement closestBuilding = null;
        for (BuildingPlacement building : buildings) {
            if (!MiscUtil.isBuildingAttackable(unitMob, building) || building instanceof BridgePlacement) continue;
            BlockPos attackPos = building.getClosestGroundPos(unitMob.m_20183_(), 1);
            double dist = Math.sqrt(unitMob.m_20183_().m_123331_((Vec3i)attackPos));
            if (!(dist < closestDist)) continue;
            closestDist = dist;
            closestBuilding = building;
        }
        return closestBuilding;
    }

    private static boolean isBuildingAttackable(Mob unitMob, BuildingPlacement building) {
        Relationship relationship = UnitServerEvents.getUnitToBuildingRelationship((Unit)unitMob, building);
        if (relationship == Relationship.FRIENDLY) {
            return false;
        }
        boolean neutralAggro = ((GameRules.BooleanValue)unitMob.m_9236_().m_46469_().m_46170_(GameRuleRegistrar.NEUTRAL_AGGRO)).m_46223_();
        boolean neutralUnit = ((Unit)unitMob).getOwnerName().isBlank();
        if (relationship == Relationship.NEUTRAL && neutralAggro) {
            return true;
        }
        return relationship == Relationship.HOSTILE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean hasLineOfSightForAttacks(Mob mob, LivingEntity targetEntity) {
        if (mob.m_142582_((Entity)targetEntity)) return true;
        if (mob instanceof GhastUnit) return true;
        if (!(mob instanceof Unit)) return false;
        Unit unit = (Unit)mob;
        if (GarrisonableBuilding.getGarrison((Unit)mob) == null) return false;
        return true;
    }

    public static <T extends Entity> List<T> getEntitiesWithinRange(Vec3 pos, float range, Class<T> entityType, Level level) {
        return MiscUtil.getEntitiesWithinRange(new Vector3d(pos.f_82479_, pos.f_82480_, pos.f_82481_), range, entityType, level);
    }

    public static <T extends Entity> List<T> getEntitiesWithinRange(Vector3d pos, float range, Class<T> entityType, Level level) {
        AABB aabb = new AABB(pos.x - (double)range, pos.y - (double)range, pos.z - (double)range, pos.x + (double)range, pos.y + (double)range, pos.z + (double)range);
        if (level != null) {
            List entities = level.m_45976_(entityType, aabb);
            ArrayList<Entity> entitiesInRange = new ArrayList<Entity>();
            for (Entity entity : entities) {
                Vec3 vec3 = new Vec3(pos.x, pos.y, pos.z);
                if (!(entity.m_20182_().m_82554_(vec3) <= (double)range) || !entity.m_9236_().m_6857_().m_61937_(entity.m_20183_())) continue;
                entitiesInRange.add(entity);
            }
            return entitiesInRange;
        }
        return new ArrayList();
    }

    public static void drawDebugStrings(GuiGraphics guiGraphics, Font font, String[] strings) {
        int y = 200 - strings.length * 10;
        for (String str : strings) {
            guiGraphics.m_280488_(font, str, 0, y, 0xFFFFFF);
            y += 10;
        }
    }

    public static Relationship getClientsideRelationship(String playerName1, String playerName2) {
        if (playerName1.isEmpty() || playerName2.isEmpty()) {
            return Relationship.NEUTRAL;
        }
        if (playerName1.equals(playerName2)) {
            return Relationship.OWNED;
        }
        if (AlliancesClient.isAllied(playerName1, playerName2)) {
            return Relationship.FRIENDLY;
        }
        return Relationship.HOSTILE;
    }

    public static int shadeHexRGB(int col, float mult) {
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        if (mult > 1.0f) {
            red = Math.min(Math.round((float)red * mult), 255);
            green = Math.min(Math.round((float)green * mult), 255);
            blue = Math.min(Math.round((float)blue * mult), 255);
        } else {
            red = Math.max(Math.round((float)red * mult), 0);
            green = Math.max(Math.round((float)green * mult), 0);
            blue = Math.max(Math.round((float)blue * mult), 0);
        }
        return red << 16 | green << 8 | blue;
    }

    public static int reverseHexRGB(int col) {
        int red = col >> 16 & 0xFF;
        int green = col >> 8 & 0xFF;
        int blue = col & 0xFF;
        return blue << 16 | green << 8 | red;
    }

    public static float getOscillatingFloat(double min, double max) {
        return MiscUtil.getOscillatingFloat(min, max, 0L);
    }

    public static float getOscillatingFloat(double min, double max, long timeOffset) {
        long ms = System.currentTimeMillis() + timeOffset;
        String msStr = String.valueOf(ms);
        String last3Digits = msStr.substring(msStr.length() - 3);
        double msOsc = Math.abs(Double.parseDouble(last3Digits) - 500.0) / 250.0 - 1.0;
        msOsc = Math.asin(msOsc) / Math.PI + 0.5;
        msOsc *= max - min;
        return (float)(msOsc += min);
    }

    public static double round(double value, int precision) {
        int scale = (int)Math.pow(10.0, precision);
        return (double)Math.round(value * (double)scale) / (double)scale;
    }

    public static Vector3d getPlayerLookVector(Minecraft MC) {
        if (MC.f_91074_ == null) {
            return new Vector3d(0.0, 0.0, 0.0);
        }
        float a = (float)Math.toRadians(MC.f_91074_.m_146908_());
        float b = (float)Math.toRadians(MC.f_91074_.m_146909_());
        return new Vector3d((double)(-Mth.m_14089_((float)b) * Mth.m_14031_((float)a)), (double)(-Mth.m_14031_((float)b)), (double)(Mth.m_14089_((float)b) * Mth.m_14089_((float)a)));
    }

    public static Vec3 getOrthoviewCentreWorldPos(Minecraft MC) {
        Vector3d centrePosd = MiscUtil.screenPosToWorldPos(MC, MC.m_91268_().m_85445_() / 2, MC.m_91268_().m_85446_() / 2);
        Vector3d lookVector = MiscUtil.getPlayerLookVector(MC);
        Vector3d cursorWorldPosNear = MyMath.addVector3d(centrePosd, lookVector, -200.0f);
        Vector3d cursorWorldPosFar = MyMath.addVector3d(centrePosd, lookVector, 200.0f);
        return CursorClientEvents.getRefinedCursorWorldPos(cursorWorldPosNear, cursorWorldPosFar);
    }

    public static Set<BlockPos> getRangeIndicatorCircleBlocks(BlockPos centrePos, int radius, Level level) {
        if (radius <= 0) {
            return Set.of();
        }
        ArrayList<BlockPos> bps = new ArrayList<BlockPos>();
        Set<BlockPos> nightCircleBps = TimeClientEvents.nightCircleMode == NightCircleMode.NO_OVERLAPS ? CircleUtil.getCircleWithCulledOverlaps(centrePos, radius, TimeClientEvents.nightSourceOrigins) : CircleUtil.getCircle(centrePos, radius);
        for (BlockPos bp : nightCircleBps) {
            for (int i = 0; i < 3; ++i) {
                BlockPos bottomBp;
                BlockState bs;
                int x = bp.m_123341_();
                int z = bp.m_123343_();
                if (i == 1) {
                    ++x;
                } else if (i == 2) {
                    ++z;
                }
                int groundY = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z) - 1;
                BlockPos topBp = new BlockPos(x, groundY, z);
                bps.add(topBp);
                int y = 1;
                if (!(level.m_8055_(topBp).m_60734_() instanceof LeavesBlock)) continue;
                do {
                    bottomBp = topBp.m_7918_(0, -y, 0);
                    bs = level.m_8055_(bottomBp);
                } while (++y < 30 && (bs.m_60734_() instanceof LeavesBlock || !bs.m_280296_()));
                if (level.m_8055_(bottomBp.m_7494_()).m_280296_()) continue;
                bps.add(bottomBp);
            }
        }
        return new HashSet<BlockPos>(bps);
    }

    public static FormattedCharSequence fcs(String string) {
        return FormattedCharSequence.m_13714_((String)string, (Style)Style.f_131099_);
    }

    public static FormattedCharSequence fcsIcons(String string) {
        return FormattedCharSequence.m_13714_((String)string, (Style)MyRenderer.iconStyle);
    }

    public static FormattedCharSequence fcs(String string, boolean bold) {
        return FormattedCharSequence.m_13714_((String)string, (Style)(bold ? Style.f_131099_.m_131136_(Boolean.valueOf(true)) : Style.f_131099_));
    }

    public static FormattedCharSequence fcs(String string, Style style) {
        return FormattedCharSequence.m_13714_((String)string, (Style)style);
    }

    public static boolean isSolidBlocking(Level level, BlockPos bp) {
        BlockState bs = level.m_8055_(bp);
        return !bs.m_60812_((BlockGetter)level, bp).m_83281_() && bs.m_280296_();
    }

    public static String capitaliseAndSpace(String str) {
        String spacedStr = str.replace('_', ' ');
        spacedStr = spacedStr.replace('-', ' ');
        spacedStr = spacedStr.replace('.', ' ');
        return WordUtils.capitalize((String)spacedStr);
    }

    public static float getMaxAbsorptionAmount(LivingEntity entity) {
        MobEffectInstance mei = entity.m_21124_(MobEffects.f_19617_);
        if (mei != null) {
            return (float)(mei.m_19564_() + 1) * 4.0f;
        }
        return entity.m_6103_();
    }

    public static String getSimpleEntityName(Entity entity) {
        if (entity instanceof PhantomSummon) {
            return "Phantom";
        }
        if (entity instanceof Unit) {
            if (entity.m_8077_()) {
                return entity.m_6095_().m_20676_().getString().replace(" ", "").replace("entity.reignofnether.", "").replace("_unit", "").replace(".none", "");
            }
            return entity.m_7755_().getString().replace(" ", "").replace("entity.reignofnether.", "").replace("_unit", "").replace(".none", "");
        }
        if (entity != null) {
            return entity.m_7755_().getString().toLowerCase();
        }
        return "";
    }

    public static class CircleUtil {
        private static final Map<Integer, Set<BlockPos>> circleCache = new HashMap<Integer, Set<BlockPos>>();
        private static final int HASH_GRID_SIZE = 5;
        private static final Map<String, Set<BlockPos>> spatialHashMap = new HashMap<String, Set<BlockPos>>();

        private static String getHashKey(BlockPos point) {
            int x = point.m_123341_() / 5;
            int z = point.m_123343_() / 5;
            return x + ":" + z;
        }

        private static void addPointToSpatialHashMap(BlockPos point, String hashKey) {
            spatialHashMap.putIfAbsent(hashKey, new HashSet());
            spatialHashMap.get(hashKey).add(point);
        }

        public static Set<BlockPos> getCircleWithCulledOverlaps(BlockPos center, int radius, List<Pair<BlockPos, Integer>> overlapSources) {
            if (radius <= 0) {
                return new HashSet<BlockPos>();
            }
            if (TimeClientEvents.nightCircleMode == NightCircleMode.NO_OVERLAPS) {
                for (Pair<BlockPos, Integer> os : overlapSources) {
                    Vec2 centre1 = new Vec2((float)center.m_123341_(), (float)center.m_123343_());
                    Vec2 centre2 = new Vec2((float)((BlockPos)os.getFirst()).m_123341_(), (float)((BlockPos)os.getFirst()).m_123343_());
                    int overlapRange = (Integer)os.getSecond();
                    if (center.equals(os.getFirst()) || radius >= overlapRange || !(centre1.m_165914_(centre2) < (float)(radius * radius))) continue;
                    return Set.of();
                }
            }
            Set<BlockPos> circleBps = CircleUtil.getCircle(center, radius);
            for (Pair<BlockPos, Integer> os : overlapSources) {
                circleBps.removeIf(bp -> {
                    Vec2 centre1 = new Vec2((float)bp.m_123341_(), (float)bp.m_123343_());
                    Vec2 centre2 = new Vec2((float)((BlockPos)os.getFirst()).m_123341_(), (float)((BlockPos)os.getFirst()).m_123343_());
                    int range = (Integer)os.getSecond();
                    return !center.equals(os.getFirst()) && centre1.m_165914_(centre2) < (float)(range * range);
                });
            }
            return circleBps;
        }

        public static Set<BlockPos> getCircle(BlockPos center, int radius) {
            if (radius <= 0) {
                return new HashSet<BlockPos>();
            }
            if (!circleCache.containsKey(radius)) {
                circleCache.put(radius, CircleUtil.computeCircleEdge(radius));
            }
            Set<BlockPos> cachedCircle = circleCache.get(radius);
            HashSet<BlockPos> translatedCircle = new HashSet<BlockPos>(cachedCircle.size());
            int cx = center.m_123341_();
            int cy = center.m_123342_();
            int cz = center.m_123343_();
            for (BlockPos pos : cachedCircle) {
                translatedCircle.add(new BlockPos(cx + pos.m_123341_(), cy, cz + pos.m_123343_()));
            }
            return translatedCircle;
        }

        private static Set<BlockPos> computeCircleEdge(int radius) {
            HashSet<BlockPos> circleBlocks = new HashSet<BlockPos>(8 * radius);
            int x = radius;
            int decisionOver2 = 1 - x;
            for (int z = 0; x >= z; ++z) {
                CircleUtil.addSymmetricPoints(circleBlocks, x, z);
                if (decisionOver2 <= 0) {
                    decisionOver2 += 2 * z + 1;
                    continue;
                }
                decisionOver2 += 2 * (z - --x) + 1;
            }
            return circleBlocks;
        }

        private static void addSymmetricPoints(Set<BlockPos> circleBlocks, int x, int z) {
            circleBlocks.add(new BlockPos(x, 0, z));
            circleBlocks.add(new BlockPos(-x, 0, z));
            circleBlocks.add(new BlockPos(x, 0, -z));
            circleBlocks.add(new BlockPos(-x, 0, -z));
            if (x != z) {
                circleBlocks.add(new BlockPos(z, 0, x));
                circleBlocks.add(new BlockPos(-z, 0, x));
                circleBlocks.add(new BlockPos(z, 0, -x));
                circleBlocks.add(new BlockPos(-z, 0, -x));
            }
        }
    }
}

