/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.util;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.hud.RectZone;
import com.solegendary.reignofnether.orthoview.OrthoviewClientEvents;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class MyRenderer {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static final Set<ResourceLocation> DYNAMIC_TEXTURES = new HashSet<ResourceLocation>();
    private static final RenderType LINES_NO_DEPTH_TEST = RenderType.m_173215_((String)"lines", (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173095_).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.empty())).m_110669_(RenderStateShard.f_110119_).m_110685_(RenderStateShard.f_110139_).m_110675_(RenderStateShard.f_110129_).m_110687_(RenderStateShard.f_110114_).m_110661_(RenderStateShard.f_110110_).m_110663_(RenderStateShard.f_110111_).m_110691_(false));
    public static final Style iconStyle = Style.f_131099_.m_131150_(new ResourceLocation("reignofnether", "resource_icons"));

    private static void ensureTextureAvailable(ResourceLocation rl) {
        block91: {
            if (rl == null) {
                return;
            }
            try {
                Path[] devCandidates;
                Path[] pathArray;
                Path paxiDir;
                DynamicTexture dyn;
                NativeImage img;
                BufferedInputStream in;
                ZipEntry entry;
                Object entryName;
                Object[] zipCandidates;
                String entry2;
                String entry1;
                ZipFile zip;
                DynamicTexture dyn2;
                NativeImage img2;
                BufferedInputStream in2;
                int n;
                Path[] fileCandidates;
                Path candidate2;
                Path candidate1;
                Stream<Path> ds;
                Path dpDir;
                ResourceLocation[] candidates;
                ResourceLocation[] resourceLocationArray;
                ResourceLocation rlPng;
                if (DYNAMIC_TEXTURES.contains(rl)) {
                    return;
                }
                ResourceLocation resourceLocation = rlPng = rl.m_135815_().endsWith(".png") ? rl : new ResourceLocation(rl.m_135827_(), rl.m_135815_() + ".png");
                if (rl == rlPng) {
                    ResourceLocation[] resourceLocationArray2 = new ResourceLocation[1];
                    resourceLocationArray = resourceLocationArray2;
                    resourceLocationArray2[0] = rl;
                } else {
                    ResourceLocation[] resourceLocationArray3 = new ResourceLocation[2];
                    resourceLocationArray3[0] = rl;
                    resourceLocationArray = resourceLocationArray3;
                    resourceLocationArray3[1] = rlPng;
                }
                for (ResourceLocation cand : candidates = resourceLocationArray) {
                    Optional resOpt = MC.m_91098_().m_213713_(cand);
                    if (!resOpt.isPresent()) continue;
                    try (InputStream in3 = ((Resource)resOpt.get()).m_215507_();){
                        NativeImage img3 = NativeImage.m_85058_((InputStream)in3);
                        DynamicTexture dyn3 = new DynamicTexture(img3);
                        MC.m_91097_().m_118495_(rl, (AbstractTexture)dyn3);
                        DYNAMIC_TEXTURES.add(rl);
                        ReignOfNether.LOGGER.debug("Loaded texture via resource manager: {} -> {}", (Object)rl, (Object)cand);
                        return;
                    }
                }
                String subpathNoExt = "assets/" + rl.m_135827_() + "/" + rl.m_135815_();
                String subpathPng = rl.m_135815_().endsWith(".png") ? subpathNoExt : subpathNoExt + ".png";
                boolean loaded = false;
                if (MC.m_91092_() != null && Files.isDirectory(dpDir = MC.m_91092_().m_129843_(LevelResource.f_78180_), new LinkOption[0])) {
                    ds = Files.list(dpDir);
                    try {
                        for (Path packPath : ds.toList()) {
                            if (Files.isDirectory(packPath, new LinkOption[0])) {
                                Path[] pathArray2;
                                candidate1 = packPath.resolve(subpathNoExt);
                                candidate2 = packPath.resolve(subpathPng);
                                if (Files.exists(candidate1, new LinkOption[0]) && !rl.m_135815_().endsWith(".png")) {
                                    Path[] pathArray3 = new Path[2];
                                    pathArray3[0] = candidate1;
                                    pathArray2 = pathArray3;
                                    pathArray3[1] = candidate2;
                                } else {
                                    Path[] pathArray4 = new Path[1];
                                    pathArray2 = pathArray4;
                                    pathArray4[0] = candidate2;
                                }
                                Path[] pathArray5 = fileCandidates = pathArray2;
                                int n2 = pathArray5.length;
                                for (n = 0; n < n2; ++n) {
                                    Path candidate = pathArray5[n];
                                    if (!Files.exists(candidate, new LinkOption[0])) continue;
                                    in2 = new BufferedInputStream(Files.newInputStream(candidate, new OpenOption[0]));
                                    try {
                                        img2 = NativeImage.m_85058_((InputStream)in2);
                                        dyn2 = new DynamicTexture(img2);
                                        MC.m_91097_().m_118495_(rl, (AbstractTexture)dyn2);
                                        DYNAMIC_TEXTURES.add(rl);
                                        ReignOfNether.LOGGER.debug("Loaded texture from world datapack: {} -> {}", (Object)rl, (Object)candidate);
                                        loaded = true;
                                        break;
                                    }
                                    finally {
                                        ((InputStream)in2).close();
                                    }
                                }
                            } else if (packPath.toString().endsWith(".zip")) {
                                zip = new ZipFile(packPath.toFile());
                                try {
                                    String[] stringArray;
                                    entry1 = subpathNoExt.replace('\\', '/');
                                    entry2 = subpathPng.replace('\\', '/');
                                    if (rl.m_135815_().endsWith(".png")) {
                                        String[] stringArray2 = new String[1];
                                        stringArray = stringArray2;
                                        stringArray2[0] = entry2;
                                    } else {
                                        String[] stringArray3 = new String[2];
                                        stringArray3[0] = entry1;
                                        stringArray = stringArray3;
                                        stringArray3[1] = entry2;
                                    }
                                    Object[] objectArray = zipCandidates = stringArray;
                                    n = objectArray.length;
                                    for (int candidate = 0; candidate < n; ++candidate) {
                                        entryName = objectArray[candidate];
                                        entry = zip.getEntry((String)entryName);
                                        if (entry == null) continue;
                                        in = new BufferedInputStream(zip.getInputStream(entry));
                                        try {
                                            img = NativeImage.m_85058_((InputStream)in);
                                            dyn = new DynamicTexture(img);
                                            MC.m_91097_().m_118495_(rl, (AbstractTexture)dyn);
                                            DYNAMIC_TEXTURES.add(rl);
                                            ReignOfNether.LOGGER.debug("Loaded texture from zip datapack: {} -> {}", (Object)rl, entryName);
                                            loaded = true;
                                        }
                                        finally {
                                            ((InputStream)in).close();
                                        }
                                    }
                                }
                                finally {
                                    zip.close();
                                }
                            }
                            if (!loaded) continue;
                            break;
                        }
                    }
                    finally {
                        if (ds != null) {
                            ds.close();
                        }
                    }
                }
                if (!loaded && Files.isDirectory(paxiDir = MyRenderer.MC.f_91069_.toPath().resolve("config/paxi/datapacks"), new LinkOption[0])) {
                    try {
                        ds = Files.list(paxiDir);
                        try {
                            for (Path packPath : ds.toList()) {
                                if (Files.isDirectory(packPath, new LinkOption[0])) {
                                    Path[] pathArray6;
                                    candidate1 = packPath.resolve(subpathNoExt);
                                    candidate2 = packPath.resolve(subpathPng);
                                    if (Files.exists(candidate1, new LinkOption[0]) && !rl.m_135815_().endsWith(".png")) {
                                        Path[] pathArray7 = new Path[2];
                                        pathArray7[0] = candidate1;
                                        pathArray6 = pathArray7;
                                        pathArray7[1] = candidate2;
                                    } else {
                                        Path[] pathArray8 = new Path[1];
                                        pathArray6 = pathArray8;
                                        pathArray8[0] = candidate2;
                                    }
                                    fileCandidates = pathArray6;
                                    zipCandidates = fileCandidates;
                                    int n3 = zipCandidates.length;
                                    for (n = 0; n < n3; ++n) {
                                        Object candidate = zipCandidates[n];
                                        if (!Files.exists((Path)candidate, new LinkOption[0])) continue;
                                        in2 = new BufferedInputStream(Files.newInputStream((Path)candidate, new OpenOption[0]));
                                        try {
                                            img2 = NativeImage.m_85058_((InputStream)in2);
                                            dyn2 = new DynamicTexture(img2);
                                            MC.m_91097_().m_118495_(rl, (AbstractTexture)dyn2);
                                            DYNAMIC_TEXTURES.add(rl);
                                            ReignOfNether.LOGGER.debug("Loaded texture from Paxi datapack: {} -> {}", (Object)rl, candidate);
                                            loaded = true;
                                            break;
                                        }
                                        finally {
                                            ((InputStream)in2).close();
                                        }
                                    }
                                } else if (packPath.toString().endsWith(".zip")) {
                                    zip = new ZipFile(packPath.toFile());
                                    try {
                                        String[] stringArray;
                                        entry1 = subpathNoExt.replace('\\', '/');
                                        entry2 = subpathPng.replace('\\', '/');
                                        if (rl.m_135815_().endsWith(".png")) {
                                            String[] stringArray4 = new String[1];
                                            stringArray = stringArray4;
                                            stringArray4[0] = entry2;
                                        } else {
                                            String[] stringArray5 = new String[2];
                                            stringArray5[0] = entry1;
                                            stringArray = stringArray5;
                                            stringArray5[1] = entry2;
                                        }
                                        Object[] objectArray = zipCandidates = stringArray;
                                        n = objectArray.length;
                                        for (int candidate = 0; candidate < n; ++candidate) {
                                            entryName = objectArray[candidate];
                                            entry = zip.getEntry((String)entryName);
                                            if (entry == null) continue;
                                            in = new BufferedInputStream(zip.getInputStream(entry));
                                            try {
                                                img = NativeImage.m_85058_((InputStream)in);
                                                dyn = new DynamicTexture(img);
                                                MC.m_91097_().m_118495_(rl, (AbstractTexture)dyn);
                                                DYNAMIC_TEXTURES.add(rl);
                                                ReignOfNether.LOGGER.debug("Loaded texture from Paxi zip datapack: {} -> {}", (Object)rl, entryName);
                                                loaded = true;
                                            }
                                            finally {
                                                ((InputStream)in).close();
                                            }
                                        }
                                    }
                                    finally {
                                        zip.close();
                                    }
                                }
                                if (!loaded) continue;
                                break;
                            }
                        }
                        finally {
                            if (ds != null) {
                                ds.close();
                            }
                        }
                    }
                    catch (Exception ex) {
                        ReignOfNether.LOGGER.debug("Failed to search Paxi datapacks: {}", (Object)ex.toString());
                    }
                }
                if (loaded) break block91;
                Path devBase = Path.of("customdatapack", new String[0]);
                Path dev1 = devBase.resolve(subpathNoExt);
                Path dev2 = devBase.resolve(subpathPng);
                if (Files.exists(dev1, new LinkOption[0]) && !rl.m_135815_().endsWith(".png")) {
                    Path[] pathArray9 = new Path[2];
                    pathArray9[0] = dev1;
                    pathArray = pathArray9;
                    pathArray9[1] = dev2;
                } else {
                    Path[] pathArray10 = new Path[1];
                    pathArray = pathArray10;
                    pathArray10[0] = dev2;
                }
                for (Path dev : devCandidates = pathArray) {
                    if (!Files.exists(dev, new LinkOption[0])) continue;
                    try (BufferedInputStream in4 = new BufferedInputStream(Files.newInputStream(dev, new OpenOption[0]));){
                        NativeImage img4 = NativeImage.m_85058_((InputStream)in4);
                        DynamicTexture dyn4 = new DynamicTexture(img4);
                        MC.m_91097_().m_118495_(rl, (AbstractTexture)dyn4);
                        DYNAMIC_TEXTURES.add(rl);
                        ReignOfNether.LOGGER.debug("Loaded texture from customdatapack: {} -> {}", (Object)rl, (Object)dev);
                        break;
                    }
                }
            }
            catch (Exception ex) {
                ReignOfNether.LOGGER.debug("Failed to load dynamic texture {}: {}", (Object)rl, (Object)ex.toString());
            }
        }
    }

    public static void drawBlockOutline(PoseStack matrixStack, BlockPos blockpos, float a) {
        AABB aabb = new AABB(blockpos).m_82386_(0.0, 0.01, 0.0);
        MyRenderer.drawLineBox(matrixStack, aabb, 1.0f, 1.0f, 1.0f, a);
    }

    public static void drawEntityBox(PoseStack matrixStack, Entity entity, float a) {
        MyRenderer.drawLineBox(matrixStack, entity.m_20191_(), 1.0f, 1.0f, 1.0f, a);
    }

    public static void drawEntityBox(PoseStack matrixStack, Entity entity, float r, float g, float b, float a) {
        MyRenderer.drawLineBox(matrixStack, entity.m_20191_(), r, g, b, a);
    }

    public static void drawBoxBottom(PoseStack matrixStack, AABB aabb, float r, float g, float b, float a) {
        aabb = aabb.m_165893_(aabb.f_82289_);
        MyRenderer.drawLineBox(matrixStack, aabb, r, g, b, a);
    }

    public static void drawLineBox(PoseStack matrixStack, AABB aabb, float r, float g, float b, float a) {
        Entity camEntity = MC.m_91288_();
        double d0 = camEntity.m_20185_();
        double d1 = camEntity.m_20186_() + (double)camEntity.m_20192_();
        double d2 = camEntity.m_20189_();
        VertexConsumer vertexConsumer = MC.m_91269_().m_110104_().m_6299_(RenderType.m_110504_());
        matrixStack.m_85836_();
        matrixStack.m_85837_(-d0, -d1, -d2);
        LevelRenderer.m_109646_((PoseStack)matrixStack, (VertexConsumer)vertexConsumer, (AABB)aabb, (float)r, (float)g, (float)b, (float)a);
        matrixStack.m_85849_();
    }

    public static void drawLineBoxOutlineOnly(PoseStack matrixStack, AABB aabb, float r, float g, float b, float a, boolean excludeMaxY) {
        Entity camEntity = MC.m_91288_();
        double d0 = camEntity.m_20185_();
        double d1 = camEntity.m_20186_() + (double)camEntity.m_20192_();
        double d2 = camEntity.m_20189_();
        VertexConsumer vertexConsumer = MC.m_91269_().m_110104_().m_6299_(LINES_NO_DEPTH_TEST);
        matrixStack.m_85836_();
        matrixStack.m_85837_(-d0, -d1, -d2);
        Matrix4f matrix4f = matrixStack.m_85850_().m_252922_();
        Matrix3f matrix3f = matrixStack.m_85850_().m_252943_();
        float minX = (float)aabb.f_82288_;
        float minY = (float)aabb.f_82289_;
        float minZ = (float)aabb.f_82290_;
        float maxX = (float)aabb.f_82291_;
        float maxY = (float)aabb.f_82292_;
        float maxZ = (float)aabb.f_82293_;
        float rotX = OrthoviewClientEvents.getCamRotX();
        if (rotX <= 180.0f) {
            rotX += 360.0f;
        }
        if (rotX > 180.0f) {
            rotX -= 360.0f;
        }
        if (rotX > -180.0f && rotX <= -90.0f) {
            vertexConsumer.m_252986_(matrix4f, minX, minY, minZ).m_85950_(r, g, g, a).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, minX, maxY, minZ).m_85950_(r, g, g, a).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, minX, minY, minZ).m_85950_(r, g, b, a).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, minX, minY, maxZ).m_85950_(r, g, b, a).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
            if (!excludeMaxY) {
                vertexConsumer.m_252986_(matrix4f, maxX, maxY, minZ).m_85950_(r, g, b, a).m_252939_(matrix3f, -1.0f, 0.0f, 0.0f).m_5752_();
                vertexConsumer.m_252986_(matrix4f, minX, maxY, minZ).m_85950_(r, g, b, a).m_252939_(matrix3f, -1.0f, 0.0f, 0.0f).m_5752_();
            }
            vertexConsumer.m_252986_(matrix4f, minX, minY, maxZ).m_85950_(r, g, b, a).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, maxX, minY, maxZ).m_85950_(r, g, b, a).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, maxX, minY, maxZ).m_85950_(r, g, b, a).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            if (!excludeMaxY) {
                vertexConsumer.m_252986_(matrix4f, maxX, maxY, minZ).m_85950_(r, g, b, a).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
                vertexConsumer.m_252986_(matrix4f, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
            }
        } else if (rotX > 90.0f && rotX <= 180.0f) {
            vertexConsumer.m_252986_(matrix4f, maxX, minY, minZ).m_85950_(r, g, b, a).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, maxX, maxY, minZ).m_85950_(r, g, b, a).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            if (!excludeMaxY) {
                vertexConsumer.m_252986_(matrix4f, maxX, maxY, minZ).m_85950_(r, g, b, a).m_252939_(matrix3f, -1.0f, 0.0f, 0.0f).m_5752_();
                vertexConsumer.m_252986_(matrix4f, minX, maxY, minZ).m_85950_(r, g, b, a).m_252939_(matrix3f, -1.0f, 0.0f, 0.0f).m_5752_();
                vertexConsumer.m_252986_(matrix4f, minX, maxY, minZ).m_85950_(r, g, b, a).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
                vertexConsumer.m_252986_(matrix4f, minX, maxY, maxZ).m_85950_(r, g, b, a).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
            }
            vertexConsumer.m_252986_(matrix4f, minX, maxY, maxZ).m_85950_(r, g, b, a).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, minX, minY, maxZ).m_85950_(r, g, b, a).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, minX, minY, maxZ).m_85950_(r, g, b, a).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, maxX, minY, maxZ).m_85950_(r, g, b, a).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, maxX, minY, maxZ).m_85950_(r, g, b, a).m_252939_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, maxX, minY, minZ).m_85950_(r, g, b, a).m_252939_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
        } else if (rotX > 0.0f && rotX <= 90.0f) {
            vertexConsumer.m_252986_(matrix4f, minX, minY, minZ).m_85950_(r, g, g, a).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, maxX, minY, minZ).m_85950_(r, g, g, a).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, minX, minY, minZ).m_85950_(r, g, g, a).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, minX, maxY, minZ).m_85950_(r, g, g, a).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            if (!excludeMaxY) {
                vertexConsumer.m_252986_(matrix4f, minX, maxY, minZ).m_85950_(r, g, b, a).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
                vertexConsumer.m_252986_(matrix4f, minX, maxY, maxZ).m_85950_(r, g, b, a).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
            }
            vertexConsumer.m_252986_(matrix4f, maxX, minY, maxZ).m_85950_(r, g, b, a).m_252939_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, maxX, minY, minZ).m_85950_(r, g, b, a).m_252939_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
            if (!excludeMaxY) {
                vertexConsumer.m_252986_(matrix4f, minX, maxY, maxZ).m_85950_(r, g, b, a).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
                vertexConsumer.m_252986_(matrix4f, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
            }
            vertexConsumer.m_252986_(matrix4f, maxX, minY, maxZ).m_85950_(r, g, b, a).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        } else if (rotX > -90.0f && rotX <= 0.0f) {
            vertexConsumer.m_252986_(matrix4f, minX, minY, minZ).m_85950_(r, g, g, a).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, maxX, minY, minZ).m_85950_(r, g, g, a).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, minX, minY, minZ).m_85950_(r, g, b, a).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, minX, minY, maxZ).m_85950_(r, g, b, a).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, maxX, minY, minZ).m_85950_(r, g, b, a).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, maxX, maxY, minZ).m_85950_(r, g, b, a).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, minX, maxY, maxZ).m_85950_(r, g, b, a).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, minX, minY, maxZ).m_85950_(r, g, b, a).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            if (!excludeMaxY) {
                vertexConsumer.m_252986_(matrix4f, minX, maxY, maxZ).m_85950_(r, g, b, a).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
                vertexConsumer.m_252986_(matrix4f, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
                vertexConsumer.m_252986_(matrix4f, maxX, maxY, minZ).m_85950_(r, g, b, a).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
                vertexConsumer.m_252986_(matrix4f, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
            }
        }
        matrixStack.m_85849_();
    }

    public static void drawBox(PoseStack matrixStack, BlockPos bp, float r, float g, float b, float a) {
        AABB aabb = new AABB(bp);
        aabb = aabb.m_165893_(aabb.f_82292_ + (double)0.01f);
        MyRenderer.drawSolidBox(matrixStack, aabb, null, r, g, b, a, new ResourceLocation("forge:textures/white.png"));
    }

    public static void drawBlockFace(PoseStack matrixStack, Direction dir, BlockPos bp, float r, float g, float b, float a) {
        AABB aabb = new AABB(bp);
        aabb = aabb.m_165893_(aabb.f_82292_ + (double)0.01f);
        MyRenderer.drawSolidBox(matrixStack, aabb, dir, r, g, b, a, new ResourceLocation("forge:textures/white.png"));
    }

    public static void drawSolidBox(PoseStack matrixStack, AABB aabb, Direction dir, float r, float g, float b, float a, ResourceLocation rl) {
        Entity camEntity = MC.m_91288_();
        double d0 = camEntity.m_20185_();
        double d1 = camEntity.m_20186_() + (double)camEntity.m_20192_();
        double d2 = camEntity.m_20189_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(-d0, -d1, -d2);
        Matrix4f matrix4f = matrixStack.m_85850_().m_252922_();
        Matrix3f matrix3f = matrixStack.m_85850_().m_252943_();
        float minX = (float)aabb.f_82288_;
        float minY = (float)aabb.f_82289_;
        float minZ = (float)aabb.f_82290_;
        float maxX = (float)aabb.f_82291_;
        float maxY = (float)aabb.f_82292_;
        float maxZ = (float)aabb.f_82293_;
        VertexConsumer vertexConsumer = MC.m_91269_().m_110104_().m_6299_(RenderType.m_110473_((ResourceLocation)rl));
        int light = 255;
        if (dir == null || dir == Direction.UP) {
            vertexConsumer.m_252986_(matrix4f, minX, maxY, minZ).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7122_(0, 10).m_85969_(light).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, minX, maxY, maxZ).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7122_(0, 10).m_85969_(light).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7122_(0, 10).m_85969_(light).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, maxX, maxY, minZ).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7122_(0, 10).m_85969_(light).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        }
        if (dir == null || dir == Direction.EAST) {
            vertexConsumer.m_252986_(matrix4f, maxX, minY, minZ).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7122_(0, 10).m_85969_(light).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, maxX, maxY, minZ).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7122_(0, 10).m_85969_(light).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7122_(0, 10).m_85969_(light).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, maxX, minY, maxZ).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7122_(0, 10).m_85969_(light).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
        }
        if (dir == null || dir == Direction.SOUTH) {
            vertexConsumer.m_252986_(matrix4f, maxX, minY, maxZ).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7122_(0, 10).m_85969_(light).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, maxX, maxY, maxZ).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7122_(0, 10).m_85969_(light).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, minX, maxY, maxZ).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7122_(0, 10).m_85969_(light).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, minX, minY, maxZ).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7122_(0, 10).m_85969_(light).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        }
        if (dir == null || dir == Direction.WEST) {
            vertexConsumer.m_252986_(matrix4f, minX, minY, maxZ).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7122_(0, 10).m_85969_(light).m_252939_(matrix3f, -1.0f, 0.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, minX, maxY, maxZ).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7122_(0, 10).m_85969_(light).m_252939_(matrix3f, -1.0f, 0.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, minX, maxY, minZ).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7122_(0, 10).m_85969_(light).m_252939_(matrix3f, -1.0f, 0.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, minX, minY, minZ).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7122_(0, 10).m_85969_(light).m_252939_(matrix3f, -1.0f, 0.0f, 0.0f).m_5752_();
        }
        if (dir == null || dir == Direction.NORTH) {
            vertexConsumer.m_252986_(matrix4f, minX, minY, minZ).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7122_(0, 10).m_85969_(light).m_252939_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, minX, maxY, minZ).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7122_(0, 10).m_85969_(light).m_252939_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, maxX, maxY, minZ).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7122_(0, 10).m_85969_(light).m_252939_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, maxX, minY, minZ).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7122_(0, 10).m_85969_(light).m_252939_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
        }
        if (dir == null || dir == Direction.DOWN) {
            vertexConsumer.m_252986_(matrix4f, minX, minY, maxZ).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7122_(0, 10).m_85969_(light).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, minX, minY, minZ).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7122_(0, 10).m_85969_(light).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, maxX, minY, minZ).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7122_(0, 10).m_85969_(light).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(matrix4f, maxX, minY, maxZ).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7122_(0, 10).m_85969_(light).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        }
        matrixStack.m_85849_();
    }

    public static void drawLine(PoseStack matrixStack, BlockPos startPos, BlockPos endPos, float r, float g, float b, float a) {
        MyRenderer.drawLine(matrixStack, new Vec3((double)((float)startPos.m_123341_() + 0.5f), (double)((float)startPos.m_123342_() + 0.5f), (double)((float)startPos.m_123343_() + 0.5f)), new Vec3((double)((float)endPos.m_123341_() + 0.5f), (double)((float)endPos.m_123342_() + 1.0f), (double)((float)endPos.m_123343_() + 0.5f)), r, g, b, a);
    }

    public static void drawLine(PoseStack matrixStack, Vec3 startPos, Vec3 endPos, float r, float g, float b, float a) {
        Entity camEntity = MC.m_91288_();
        if (camEntity == null) {
            return;
        }
        double d0 = camEntity.m_20185_();
        double d1 = camEntity.m_20186_() + (double)camEntity.m_20192_();
        double d2 = camEntity.m_20189_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(-d0, -d1, -d2);
        Matrix4f matrix4f = matrixStack.m_85850_().m_252922_();
        Matrix3f matrix3f = matrixStack.m_85850_().m_252943_();
        VertexConsumer vertexConsumer = MC.m_91269_().m_110104_().m_6299_((RenderType)RenderType.f_110371_);
        vertexConsumer.m_252986_(matrix4f, (float)startPos.m_7096_(), (float)startPos.m_7098_(), (float)startPos.m_7094_()).m_85950_(r, g, b, a).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, (float)endPos.m_7096_(), (float)endPos.m_7098_(), (float)endPos.m_7094_()).m_85950_(r, g, b, a).m_252939_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, (float)startPos.m_7096_(), (float)startPos.m_7098_(), (float)startPos.m_7094_()).m_85950_(r, g, b, a).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, (float)endPos.m_7096_(), (float)endPos.m_7098_(), (float)endPos.m_7094_()).m_85950_(r, g, b, a).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        matrixStack.m_85849_();
    }

    public static RectZone renderFrameWithBg(GuiGraphics guiGraphics, int x, int y, int width, int height, int bgCol) {
        guiGraphics.m_280509_(x + 2, y + 2, x + width - 2, y + height - 2, bgCol);
        int thickness = 4;
        ResourceLocation iconFrameResource = new ResourceLocation("reignofnether", "textures/hud/unit_frame_left" + (height < 50 ? "_small" : "") + ".png");
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)iconFrameResource);
        guiGraphics.m_280398_(iconFrameResource, x, y, 0, 0.0f, 0.0f, thickness, height, thickness, height);
        iconFrameResource = new ResourceLocation("reignofnether", "textures/hud/unit_frame_right" + (height < 50 ? "_small" : "") + ".png");
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)iconFrameResource);
        guiGraphics.m_280398_(iconFrameResource, x + width - thickness, y, 0, 0.0f, 0.0f, thickness, height, thickness, height);
        iconFrameResource = new ResourceLocation("reignofnether", "textures/hud/unit_frame_top.png");
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)iconFrameResource);
        guiGraphics.m_280398_(iconFrameResource, x + thickness, y, 0, 0.0f, 0.0f, width - thickness * 2, thickness, width, thickness);
        iconFrameResource = new ResourceLocation("reignofnether", "textures/hud/unit_frame_bottom.png");
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)iconFrameResource);
        guiGraphics.m_280398_(iconFrameResource, x + thickness, y + height - thickness, 0, 0.0f, 0.0f, width - thickness * 2, thickness, width, thickness);
        return RectZone.getZoneByLW(x, y, width, height);
    }

    public static RectZone renderIconFrameWithBg(GuiGraphics guiGraphics, ResourceLocation frameRl, int x, int y, int size, int bg) {
        guiGraphics.m_280509_(x, y, x + size, y + size, bg);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)frameRl);
        guiGraphics.m_280398_(frameRl, x, y, 0, 0.0f, 0.0f, size, size, size, size);
        return RectZone.getZoneByLW(x, y, size, size);
    }

    public static void renderIcon(GuiGraphics guiGraphics, ResourceLocation resourceLocation, int x, int y, int size) {
        MyRenderer.ensureTextureAvailable(resourceLocation);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)resourceLocation);
        guiGraphics.m_280398_(resourceLocation, x, y, 0, 0.0f, 0.0f, size, size, size, size);
    }

    public static void renderTooltip(GuiGraphics guiGraphics, List<FormattedCharSequence> tooltipLines, int mouseX, int mouseY) {
        if (!OrthoviewClientEvents.isEnabled()) {
            return;
        }
        if (MyRenderer.MC.f_91080_ != null && tooltipLines != null && tooltipLines.size() > 0) {
            if (mouseY < MyRenderer.MC.f_91080_.f_96544_ / 2) {
                mouseY += tooltipLines.size() * 10;
            }
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 3000.0f);
            guiGraphics.m_280245_(MyRenderer.MC.f_91062_, tooltipLines, mouseX, mouseY - 9 * (tooltipLines.size() - 1));
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, -3000.0f);
        }
    }

    public static void renderItemInFrontOfEntityFace(PoseStack poseStack, LivingEntity entity, float partialTicks, ItemStack itemStack) {
        ItemRenderer itemRenderer = MC.m_91291_();
        poseStack.m_85836_();
        Camera camera = MyRenderer.MC.f_91063_.m_109153_();
        Vec3 camPos = camera.m_90583_();
        Vec3 eyePos = entity.m_146892_();
        float f = entity.m_146909_() * ((float)Math.PI / 180);
        float f1 = -entity.m_6080_() * ((float)Math.PI / 180);
        float f2 = Mth.m_14089_((float)f1);
        float f3 = Mth.m_14031_((float)f1);
        float f4 = Mth.m_14089_((float)f);
        float f5 = Mth.m_14031_((float)f);
        Vec3 look = new Vec3((double)(f3 * f4), (double)(-f5), (double)(f2 * f4)).m_82541_();
        Vec3 itemPos = eyePos.m_82549_(look.m_82490_(0.5));
        poseStack.m_85837_(itemPos.f_82479_ - camPos.f_82479_, itemPos.f_82480_ - camPos.f_82480_ - 0.25, itemPos.f_82481_ - camPos.f_82481_);
        float yaw = Mth.m_14179_((float)partialTicks, (float)entity.f_20886_, (float)entity.m_6080_());
        float pitch = Mth.m_14179_((float)partialTicks, (float)entity.f_19860_, (float)entity.m_146909_());
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        itemRenderer.m_269128_(itemStack, ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.f_118083_, poseStack, (MultiBufferSource)MC.m_91269_().m_110104_(), (Level)MyRenderer.MC.f_91073_, 0);
        poseStack.m_85849_();
        RandomSource random = MyRenderer.MC.f_91073_.m_213780_();
        double dx = (random.m_188500_() - 0.5) * 0.1;
        double dy = random.m_188500_() * 0.1 + 0.05;
        double dz = (random.m_188500_() - 0.5) * 0.1;
        MyRenderer.MC.f_91061_.m_107370_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemStack), itemPos.f_82479_, itemPos.f_82480_ - (double)0.1f, itemPos.f_82481_, dx, dy, dz);
    }
}

