/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability.abilities;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.buildings.neutral.NeutralTransportPortal;
import com.solegendary.reignofnether.building.buildings.placements.PortalPlacement;
import com.solegendary.reignofnether.cursor.CursorClientEvents;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.unit.UnitAction;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;

public class ConnectPortal
extends Ability {
    private static final int CD_MAX = 0;
    private static final int RANGE = 0;
    PortalPlacement portalPlacement;

    public ConnectPortal(PortalPlacement portalPlacement) {
        super(UnitAction.CONNECT_PORTAL, portalPlacement.getLevel(), 0, 0.0f, 0.0f, true);
        this.portalPlacement = portalPlacement;
    }

    @Override
    public AbilityButton getButton(Keybinding hotkey) {
        return new AbilityButton("Connect Portal", new ResourceLocation("reignofnether", "textures/icons/blocks/portal.png"), hotkey, () -> false, () -> this.portalPlacement.getPortalType() != PortalPlacement.PortalType.TRANSPORT, () -> true, () -> CursorClientEvents.setLeftClickAction(UnitAction.CONNECT_PORTAL), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.connect_portal", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.connect_portal.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.connect_portal.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_)), this);
    }

    @Override
    public void use(Level level, BuildingPlacement buildingUsing, BlockPos targetBp) {
        if (buildingUsing == this.portalPlacement) {
            PortalPlacement targetPortal;
            this.portalPlacement.disconnectPortal();
            BuildingPlacement targetBuilding = BuildingUtils.findBuilding(level.m_5776_(), targetBp);
            if (targetBuilding instanceof PortalPlacement && (targetPortal = (PortalPlacement)targetBuilding).getPortalType() == PortalPlacement.PortalType.TRANSPORT && targetBuilding != this.portalPlacement && targetBuilding.isBuilt && (targetBuilding.ownerName.equals(this.portalPlacement.ownerName) || targetBuilding.getBuilding() instanceof NeutralTransportPortal && this.portalPlacement.getBuilding() instanceof NeutralTransportPortal)) {
                targetPortal.disconnectPortal();
                targetPortal.destination = this.portalPlacement.centrePos;
                this.portalPlacement.destination = targetPortal.centrePos;
            } else if (level.m_5776_()) {
                HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"abilities.reignofnether.connect_portal.error1", (Object[])new Object[0]));
            }
        }
    }
}

