/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability.heroAbilities.monster;

import com.solegendary.reignofnether.ability.HeroAbility;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.cursor.CursorClientEvents;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.time.TimeClientEvents;
import com.solegendary.reignofnether.time.TimeServerEvents;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.goals.GenericTargetedSpellGoal;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.monsters.NecromancerUnit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class BloodMoon
extends HeroAbility {
    public static final String ENEMY_NAME = "Blood Moon";
    public static final int SPAWN_INTERVAL_TICKS = 120;
    public static final int CHANNEL_TICKS = 0;
    private static final int CD_MAX = 8400;
    public static final int DURATION = 1500;
    public static final int BONUS_DURATION_PER_SOUL_RANK = 200;

    public BloodMoon(HeroUnit hero) {
        super(hero, 1, 175, UnitAction.BLOOD_MOON, 8400, 0.0f, 0.0f, false);
    }

    @Override
    public boolean isCasting() {
        NecromancerUnit necromancerUnit;
        GenericTargetedSpellGoal goal;
        HeroUnit heroUnit = this.hero;
        if (heroUnit instanceof NecromancerUnit && (goal = (necromancerUnit = (NecromancerUnit)heroUnit).getCastBloodMoonGoal()) != null) {
            return goal.isCasting();
        }
        return false;
    }

    @Override
    public AbilityButton getButton(Keybinding hotkey) {
        return new AbilityButton(ENEMY_NAME, new ResourceLocation("minecraft", "textures/block/redstone_block.png"), hotkey, () -> CursorClientEvents.getLeftClickAction() == UnitAction.BLOOD_MOON, () -> this.rank == 0, () -> true, () -> CursorClientEvents.setLeftClickAction(UnitAction.BLOOD_MOON), null, this.getTooltipLines(), this);
    }

    @Override
    public Button getRankUpButton() {
        return super.getRankUpButtonProtected(ENEMY_NAME, new ResourceLocation("minecraft", "textures/block/redstone_block.png"));
    }

    @Override
    public List<FormattedCharSequence> getTooltipLines() {
        return List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.blood_moon", (Object[])new Object[0]), true), MiscUtil.fcsIcons(I18n.m_118938_((String)"abilities.reignofnether.blood_moon.stats", (Object[])new Object[]{420, this.manaCost})), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.blood_moon.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.blood_moon.tooltip2", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.blood_moon.tooltip3", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.blood_moon.tooltip4", (Object[])new Object[]{75, 10})));
    }

    @Override
    public List<FormattedCharSequence> getRankUpTooltipLines() {
        return List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.blood_moon", (Object[])new Object[0]), true), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.level_req", (Object[])new Object[]{this.getLevelRequirement()}), this.getLevelReqStyle()), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.blood_moon.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.blood_moon.tooltip2", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.blood_moon.tooltip3", (Object[])new Object[0])));
    }

    @Override
    public void use(Level level, Unit unitUsing, BlockPos targetBp) {
        BuildingPlacement bpl = BuildingUtils.findBuilding(level.m_5776_(), targetBp);
        if (bpl != null && !bpl.ownerName.isBlank() && !bpl.ownerName.equals(unitUsing.getOwnerName())) {
            this.use(level, unitUsing, bpl);
        } else if (level.m_5776_() && (bpl == null || bpl.ownerName.isBlank() || bpl.ownerName.equals(unitUsing.getOwnerName()))) {
            HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"abilities.reignofnether.blood_moon.error", (Object[])new Object[0]));
        }
    }

    @Override
    public void use(Level level, Unit unitUsing, LivingEntity targetEntity) {
        if (level.m_5776_()) {
            HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"abilities.reignofnether.blood_moon.error", (Object[])new Object[0]));
        }
    }

    private void use(Level level, Unit unitUsing, BuildingPlacement targetBpl) {
        boolean isBloodMoonActive;
        if (level.m_5776_()) {
            isBloodMoonActive = TimeClientEvents.isBloodMoonActive();
            if (isBloodMoonActive) {
                HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"abilities.reignofnether.blood_moon.already_active", (Object[])new Object[0]));
            }
        } else {
            isBloodMoonActive = TimeServerEvents.isBloodMoonActive();
        }
        if (!isBloodMoonActive) {
            ((NecromancerUnit)unitUsing).getCastBloodMoonGoal().setAbility(this);
            ((NecromancerUnit)unitUsing).getCastBloodMoonGoal().startCasting();
            ((NecromancerUnit)unitUsing).getCastBloodMoonGoal().setTarget(targetBpl);
        }
    }
}

