/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.alliance;

import com.solegendary.reignofnether.alliance.AlliancesClient;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class AllianceClientboundRemovePacket {
    private final String owner1;
    private final String owner2;
    private final boolean isReset;

    public AllianceClientboundRemovePacket(String owner1, String owner2) {
        this.owner1 = owner1;
        this.owner2 = owner2;
        this.isReset = false;
    }

    public AllianceClientboundRemovePacket() {
        this.owner1 = "";
        this.owner2 = "";
        this.isReset = true;
    }

    public AllianceClientboundRemovePacket(FriendlyByteBuf buf) {
        this.isReset = buf.readBoolean();
        if (!this.isReset) {
            this.owner1 = buf.m_130136_(Short.MAX_VALUE);
            this.owner2 = buf.m_130136_(Short.MAX_VALUE);
        } else {
            this.owner1 = "";
            this.owner2 = "";
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.isReset);
        if (!this.isReset) {
            buf.m_130070_(this.owner1);
            buf.m_130070_(this.owner2);
        }
    }

    public boolean handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (this.isReset) {
                AlliancesClient.resetAllAlliances();
            } else {
                AlliancesClient.removeAlliance(this.owner1, this.owner2);
            }
        });
        context.setPacketHandled(true);
        return true;
    }
}

