/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.api;

import com.solegendary.reignofnether.building.BuildingProperties;
import com.solegendary.reignofnether.faction.FactionProperties;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.unit.UnitProperties;
import net.minecraft.resources.ResourceLocation;

public final class ModUtils {
    private ModUtils() {
    }

    public static ResourceLocation modResource(String modId, String path) {
        return new ResourceLocation(modId, path);
    }

    public static ResourceLocation reignResource(String path) {
        return new ResourceLocation("reignofnether", path);
    }

    public static ResourceCost foodCost(int amount) {
        return ResourceCost.Unit(amount, 0, 0, 0, 0);
    }

    public static ResourceCost woodCost(int amount) {
        return ResourceCost.Unit(0, amount, 0, 0, 0);
    }

    public static ResourceCost stoneCost(int amount) {
        return ResourceCost.Unit(0, 0, amount, 0, 0);
    }

    public static ResourceCost woodFoodCost(int wood, int food) {
        return ResourceCost.Unit(food, wood, 0, 0, 0);
    }

    public static ResourceCost woodStoneCost(int wood, int stone) {
        return ResourceCost.Unit(0, wood, stone, 0, 0);
    }

    public static ResourceCost foodStoneCost(int food, int stone) {
        return ResourceCost.Unit(food, 0, stone, 0, 0);
    }

    public static ResourceCost allResourcesCost(int wood, int food, int stone) {
        return ResourceCost.Unit(food, wood, stone, 0, 0);
    }

    public static FactionProperties peacefulFactionProperties() {
        return FactionProperties.builder().healingAmount(1.5f).buildTimeMultiplier(0.8f).resourceProductionMultiplier(1.3f).build();
    }

    public static FactionProperties aggressiveFactionProperties() {
        return FactionProperties.builder().damageMultiplier(1.3f).speedMultiplier(1.1f).healingAmount(0.8f).build();
    }

    public static FactionProperties fireFactionProperties() {
        return FactionProperties.builder().fireImmune(true).damageMultiplier(1.2f).aggressive(true).build();
    }

    public static FactionProperties undeadFactionProperties() {
        return FactionProperties.builder().poisonImmune(true).aggressive(true).healingAmount(0.5f).aggressive(false).build();
    }

    public static UnitProperties basicWorkerProperties() {
        return UnitProperties.builder().worker(true).populationCost(1).build();
    }

    public static UnitProperties basicMeleeProperties() {
        return UnitProperties.builder().attacker(true).populationCost(1).build();
    }

    public static UnitProperties basicRangedProperties(int range) {
        return UnitProperties.builder().attacker(true).ranged(true).populationCost(1).attackRange(range).build();
    }

    public static UnitProperties basicFlyingProperties() {
        return UnitProperties.builder().attacker(true).flying(true).populationCost(2).attackRange(5).canClimbLadders(false).build();
    }

    public static UnitProperties basicHeroProperties() {
        return UnitProperties.builder().hero(true).attacker(true).populationCost(0).canBeRevived(true).hasSpecialAbilities(true).build();
    }

    public static BuildingProperties basicProductionProperties(int buildTime) {
        return BuildingProperties.builder().productionBuilding(true).maxHealth(150).buildTime(buildTime).populationRequired(1).visionRange(16).build();
    }

    public static BuildingProperties basicDefensiveProperties(int attackDamage, int attackRange) {
        return BuildingProperties.builder().defensiveBuilding(true).maxHealth(200).buildTime(1000).attackDamage(attackDamage).attackRange(attackRange).hasRangedAttack(true).visionRange(attackRange + 5).build();
    }

    public static BuildingProperties basicResourceProperties(float productionRate) {
        return BuildingProperties.builder().resourceBuilding(true).maxHealth(100).buildTime(600).resourceProductionRate(productionRate).visionRange(12).build();
    }

    public static BuildingProperties basicPopulationProperties(int populationProvided) {
        return BuildingProperties.builder().populationBuilding(true).maxHealth(120).buildTime(800).populationProvided(populationProvided).visionRange(14).build();
    }

    public static int rgb(int red, int green, int blue) {
        return red << 16 | green << 8 | blue;
    }

    public static final class Colors {
        public static final int RED = ModUtils.rgb(255, 0, 0);
        public static final int GREEN = ModUtils.rgb(0, 255, 0);
        public static final int BLUE = ModUtils.rgb(0, 0, 255);
        public static final int YELLOW = ModUtils.rgb(255, 255, 0);
        public static final int PURPLE = ModUtils.rgb(128, 0, 128);
        public static final int ORANGE = ModUtils.rgb(255, 165, 0);
        public static final int CYAN = ModUtils.rgb(0, 255, 255);
        public static final int PINK = ModUtils.rgb(255, 192, 203);
        public static final int BROWN = ModUtils.rgb(139, 69, 19);
        public static final int GRAY = ModUtils.rgb(128, 128, 128);
        public static final int BLACK = ModUtils.rgb(0, 0, 0);
        public static final int WHITE = ModUtils.rgb(255, 255, 255);
        public static final int DARK_RED = ModUtils.rgb(139, 0, 0);
        public static final int FOREST_GREEN = ModUtils.rgb(34, 139, 34);
        public static final int ROYAL_BLUE = ModUtils.rgb(65, 105, 225);
        public static final int GOLD = ModUtils.rgb(255, 215, 0);
        public static final int SILVER = ModUtils.rgb(192, 192, 192);
        public static final int CRIMSON = ModUtils.rgb(220, 20, 60);
        public static final int VIOLET = ModUtils.rgb(138, 43, 226);
    }
}

