/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.blocks;

import com.solegendary.reignofnether.blocks.TemporaryBlock;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.registrars.GameRuleRegistrar;
import com.solegendary.reignofnether.resources.ResourceSources;
import com.solegendary.reignofnether.restoration.OreRestorationManager;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BlockServerEvents {
    public static ArrayList<TemporaryBlock> tempBlocks = new ArrayList();

    public static void addTempBlock(ServerLevel level, BlockPos bp, BlockState bs, BlockState oldBs, int lifespan) {
        if (BuildingUtils.isPosInsideAnyBuilding(level.m_5776_(), bp)) {
            return;
        }
        if (level.m_8055_(bp) != bs) {
            tempBlocks.add(new TemporaryBlock(level, bp, bs, oldBs, lifespan));
        } else {
            for (TemporaryBlock block : tempBlocks) {
                if (!bp.equals((Object)block.bp)) continue;
                block.tickAge = 0;
            }
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END || evt.level.m_5776_() || evt.level.m_46472_() != Level.f_46428_) {
            return;
        }
        tempBlocks.removeIf(tb -> tb.tick((ServerLevel)evt.level));
    }

    @SubscribeEvent
    public static void onPlayerBlockBreak(BlockEvent.BreakEvent evt) {
        if (evt.getLevel().m_5776_() || evt.getLevel().m_7654_() == null) {
            return;
        }
        boolean isResource = ResourceSources.getFromBlockState(evt.getState()) != null;
        boolean isBuilding = BuildingUtils.isPosInsideAnyBuilding(false, evt.getPos());
        if (OreRestorationManager.isTrackableOre(evt.getState())) {
            System.out.println("[OreRestoration] Player mining " + evt.getState().m_60734_().m_49954_().getString() + " at " + evt.getPos());
            OreRestorationManager.trackMinedOre((ServerLevel)evt.getLevel(), evt.getPos(), evt.getState());
        }
        if (!(((GameRules.BooleanValue)evt.getLevel().m_7654_().m_129900_().m_46170_(GameRuleRegistrar.DO_PLAYER_GRIEFING)).m_46223_() || isResource || isBuilding)) {
            evt.setCanceled(true);
        }
    }
}

