/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.bot;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.solegendary.reignofnether.bot.AIBotPlayer;
import com.solegendary.reignofnether.bot.BotDifficulty;
import com.solegendary.reignofnether.bot.BotManager;
import com.solegendary.reignofnether.gamemode.GameMode;
import com.solegendary.reignofnether.gamemode.GameModeServerEvents;
import com.solegendary.reignofnether.util.Faction;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="reignofnether", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BotCommand {
    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"rtsbot").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"faction", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"difficulty", (ArgumentType)StringArgumentType.string()).executes(BotCommand::addBot)).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(BotCommand::addNamedBot)))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(BotCommand::removeBot)))).then(Commands.m_82127_((String)"removeall").executes(BotCommand::removeAllBots))).then(Commands.m_82127_((String)"list").executes(BotCommand::listBots))).then(Commands.m_82127_((String)"stats").executes(BotCommand::showStats))).then(Commands.m_82127_((String)"quick").then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1, (int)4)).then(Commands.m_82129_((String)"difficulty", (ArgumentType)StringArgumentType.string()).executes(BotCommand::quickAddBots))))).then(Commands.m_82127_((String)"reset").executes(BotCommand::resetBots)));
    }

    private static int addBot(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String factionStr = StringArgumentType.getString(context, (String)"faction");
        String difficultyStr = StringArgumentType.getString(context, (String)"difficulty");
        if (GameModeServerEvents.getGameMode() != GameMode.CLASSIC) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"AI bots can only be added in Classic RTS mode"));
            return 0;
        }
        Faction faction = BotCommand.parseFaction(factionStr);
        if (faction == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Invalid faction: " + factionStr + ". Valid factions: villagers, monsters, piglins")));
            return 0;
        }
        BotDifficulty difficulty = BotCommand.parseDifficulty(difficultyStr);
        if (difficulty == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Invalid difficulty: " + difficultyStr + ". Valid difficulties: easy, medium, hard, expert")));
            return 0;
        }
        try {
            AIBotPlayer bot = BotManager.createBot(faction, difficulty);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Created AI bot '" + bot.getName() + "' (" + faction.name() + ", " + difficulty.getDisplayName() + ")")), true);
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to create bot: " + e.getMessage())));
            return 0;
        }
    }

    private static int addNamedBot(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String factionStr = StringArgumentType.getString(context, (String)"faction");
        String difficultyStr = StringArgumentType.getString(context, (String)"difficulty");
        String name = StringArgumentType.getString(context, (String)"name");
        if (GameModeServerEvents.getGameMode() != GameMode.CLASSIC) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"AI bots can only be added in Classic RTS mode"));
            return 0;
        }
        Faction faction = BotCommand.parseFaction(factionStr);
        BotDifficulty difficulty = BotCommand.parseDifficulty(difficultyStr);
        if (faction == null || difficulty == null) {
            return 0;
        }
        if (BotManager.getBotByName(name) != null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Bot name '" + name + "' is already taken")));
            return 0;
        }
        try {
            AIBotPlayer bot = BotManager.createBot(name, faction, difficulty);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Created AI bot '" + bot.getName() + "' (" + faction.name() + ", " + difficulty.getDisplayName() + ")")), true);
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to create bot: " + e.getMessage())));
            return 0;
        }
    }

    private static int removeBot(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String name = StringArgumentType.getString(context, (String)"name");
        AIBotPlayer bot = BotManager.getBotByName(name);
        if (bot == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Bot '" + name + "' not found")));
            return 0;
        }
        BotManager.removeBot(bot.getId());
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Removed AI bot '" + name + "'")), true);
        return 1;
    }

    private static int removeAllBots(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int count = BotManager.getAllBots().size();
        if (count == 0) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"No AI bots to remove"));
            return 0;
        }
        BotManager.removeAllBots();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Removed all " + count + " AI bots")), true);
        return 1;
    }

    private static int listBots(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<AIBotPlayer> bots = BotManager.getAllBots();
        if (bots.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"No AI bots active"), false);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Active AI bots:"), false);
        for (AIBotPlayer bot : bots) {
            String status = bot.isActive() ? "Active" : "Inactive";
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("- " + bot.getName() + " (" + bot.getFaction().name() + ", " + bot.getDifficulty().getDisplayName() + ") - " + status)), false);
        }
        return bots.size();
    }

    private static int showStats(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<AIBotPlayer> bots = BotManager.getAllBots();
        if (bots.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"No AI bots to show stats for"), false);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"AI Bot Performance Statistics:"), false);
        for (AIBotPlayer bot : bots) {
            AIBotPlayer.BotStatistics stats = bot.getStatistics();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("- " + stats.toString())), false);
        }
        Map<BotDifficulty, Integer> distribution = BotManager.getDifficultyDistribution();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Difficulty Distribution:"), false);
        for (Map.Entry<BotDifficulty, Integer> entry : distribution.entrySet()) {
            if (entry.getValue() <= 0) continue;
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("- " + ((BotDifficulty)((Object)((Object)entry.getKey()))).getDisplayName() + ": " + entry.getValue())), false);
        }
        return 1;
    }

    private static int quickAddBots(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int count = IntegerArgumentType.getInteger(context, (String)"count");
        String difficultyStr = StringArgumentType.getString(context, (String)"difficulty");
        if (GameModeServerEvents.getGameMode() != GameMode.CLASSIC) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"AI bots can only be added in Classic RTS mode"));
            return 0;
        }
        BotDifficulty difficulty = BotCommand.parseDifficulty(difficultyStr);
        if (difficulty == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Invalid difficulty: " + difficultyStr)));
            return 0;
        }
        try {
            List<AIBotPlayer> bots = BotManager.createBots(count, difficulty);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Created " + bots.size() + " AI bots at " + difficulty.getDisplayName() + " difficulty")), true);
            return bots.size();
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Failed to create bots: " + e.getMessage())));
            return 0;
        }
    }

    private static int resetBots(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int count = BotManager.getAllBots().size();
        if (count == 0) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"No AI bots to reset"));
            return 0;
        }
        BotManager.resetAllBots();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Reset " + count + " AI bots for new game")), true);
        return 1;
    }

    private static Faction parseFaction(String factionStr) {
        return switch (factionStr.toLowerCase()) {
            case "villagers", "villager", "v" -> Faction.VILLAGERS;
            case "monsters", "monster", "m" -> Faction.MONSTERS;
            case "piglins", "piglin", "p" -> Faction.PIGLINS;
            default -> null;
        };
    }

    private static BotDifficulty parseDifficulty(String difficultyStr) {
        return switch (difficultyStr.toLowerCase()) {
            case "easy", "e" -> BotDifficulty.EASY;
            case "medium", "med", "m" -> BotDifficulty.MEDIUM;
            case "hard", "h" -> BotDifficulty.HARD;
            case "expert", "exp", "x" -> BotDifficulty.EXPERT;
            default -> null;
        };
    }
}

