/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.bot.command;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.bot.AIBotPlayer;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.Buildings;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.interfaces.WorkerUnit;
import com.solegendary.reignofnether.unit.packets.UnitActionServerboundPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Rotation;

public class BotCommandInterface {
    private final AIBotPlayer botPlayer;

    public BotCommandInterface(AIBotPlayer botPlayer) {
        ReignOfNether.LOGGER.info("DEBUG: BotCommandInterface constructor starting for bot '{}'", (Object)(botPlayer != null ? botPlayer.getName() : "null"));
        this.botPlayer = botPlayer;
        ReignOfNether.LOGGER.info("DEBUG: BotCommandInterface constructor completed for bot '{}'", (Object)(botPlayer != null ? botPlayer.getName() : "null"));
    }

    public boolean sendUnitAction(LivingEntity unit, UnitAction action, BlockPos targetPos) {
        return this.sendUnitAction(unit, action, targetPos, null, false);
    }

    public boolean sendUnitAction(LivingEntity unit, UnitAction action, BlockPos targetPos, BlockPos buildingPos, boolean shiftQueue) {
        if (!(unit instanceof Unit)) {
            return false;
        }
        try {
            UnitActionServerboundPacket packet = new UnitActionServerboundPacket(this.botPlayer.getName(), action, unit.m_19879_(), new int[]{unit.m_19879_()}, targetPos, buildingPos, shiftQueue);
            UnitServerEvents.addActionItem(this.botPlayer.getName(), action, unit.m_19879_(), new int[]{unit.m_19879_()}, targetPos, buildingPos, shiftQueue);
            return true;
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error sending unit action for bot '{}': {}", (Object)this.botPlayer.getName(), (Object)e.getMessage());
            return false;
        }
    }

    public boolean sendGroupAction(List<LivingEntity> units, UnitAction action, BlockPos targetPos) {
        return this.sendGroupAction(units, action, targetPos, null, false);
    }

    public boolean sendGroupAction(List<LivingEntity> units, UnitAction action, BlockPos targetPos, BlockPos buildingPos, boolean shiftQueue) {
        if (units.isEmpty()) {
            return false;
        }
        List validUnits = units.stream().filter(entity -> entity instanceof Unit).filter(this::isOwnedByBot).collect(Collectors.toList());
        if (validUnits.isEmpty()) {
            return false;
        }
        try {
            int[] unitIds = validUnits.stream().mapToInt(Entity::m_19879_).toArray();
            int primaryUnitId = ((LivingEntity)validUnits.get(0)).m_19879_();
            UnitServerEvents.addActionItem(this.botPlayer.getName(), action, primaryUnitId, unitIds, targetPos, buildingPos, shiftQueue);
            return true;
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error sending group action for bot '{}': {}", (Object)this.botPlayer.getName(), (Object)e.getMessage());
            return false;
        }
    }

    public boolean commandWorkersToGather(List<LivingEntity> workers, BlockPos resourceLocation) {
        return this.sendGroupAction(workers, UnitAction.MOVE, resourceLocation);
    }

    public boolean commandWorkersToBuild(List<LivingEntity> workers, BlockPos buildingLocation) {
        return this.sendGroupAction(workers, UnitAction.BUILD_REPAIR, buildingLocation);
    }

    public boolean commandWorkersToReturn(List<LivingEntity> workers) {
        return this.sendGroupAction(workers, UnitAction.RETURN_RESOURCES_TO_CLOSEST, null);
    }

    public boolean commandUnitsToAttack(List<LivingEntity> units, BlockPos targetLocation) {
        return this.sendGroupAction(units, UnitAction.ATTACK_MOVE, targetLocation);
    }

    public boolean commandUnitsToAttackBuilding(List<LivingEntity> units, BlockPos buildingLocation) {
        return this.sendGroupAction(units, UnitAction.ATTACK_BUILDING, buildingLocation);
    }

    public boolean commandUnitsToMove(List<LivingEntity> units, BlockPos destination) {
        return this.sendGroupAction(units, UnitAction.MOVE, destination);
    }

    public boolean commandUnitsToHold(List<LivingEntity> units) {
        return this.sendGroupAction(units, UnitAction.HOLD, null);
    }

    public boolean commandUnitsToStop(List<LivingEntity> units) {
        return this.sendGroupAction(units, UnitAction.STOP, null);
    }

    public boolean commandUnitsToGarrison(List<LivingEntity> units, BlockPos buildingLocation) {
        return this.sendGroupAction(units, UnitAction.GARRISON, buildingLocation);
    }

    public boolean commandUnitsToFollow(List<LivingEntity> units, LivingEntity target) {
        if (target == null) {
            return false;
        }
        return this.sendGroupAction(units, UnitAction.FOLLOW, target.m_20183_());
    }

    private boolean isOwnedByBot(LivingEntity entity) {
        if (!(entity instanceof Unit)) {
            return false;
        }
        Unit unit = (Unit)entity;
        try {
            String unitOwner = unit.getOwnerName();
            return this.botPlayer.getName().equals(unitOwner);
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error checking unit ownership for bot '{}': {}", (Object)this.botPlayer.getName(), (Object)e.getMessage());
            return false;
        }
    }

    public List<LivingEntity> getOwnedUnits(ServerLevel level) {
        ArrayList<LivingEntity> ownedUnits = new ArrayList<LivingEntity>();
        try {
            ArrayList<LivingEntity> allUnits = UnitServerEvents.getAllUnits();
            for (LivingEntity entity : allUnits) {
                if (!this.isOwnedByBot(entity)) continue;
                ownedUnits.add(entity);
            }
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error getting owned units for bot '{}': {}", (Object)this.botPlayer.getName(), (Object)e.getMessage());
        }
        return ownedUnits;
    }

    public List<LivingEntity> getOwnedWorkers(ServerLevel level) {
        return this.getOwnedUnits(level).stream().filter(entity -> entity instanceof Unit).filter(this::isWorkerUnit).collect(Collectors.toList());
    }

    public List<LivingEntity> getOwnedMilitaryUnits(ServerLevel level) {
        return this.getOwnedUnits(level).stream().filter(entity -> entity instanceof Unit).filter(this::isMilitaryUnit).collect(Collectors.toList());
    }

    public List<BuildingPlacement> getOwnedBuildings() {
        return BuildingServerEvents.getBuildings().stream().filter(building -> building.ownerName.equals(this.botPlayer.getName())).collect(Collectors.toList());
    }

    private boolean isWorkerUnit(LivingEntity entity) {
        if (!(entity instanceof Unit)) {
            return false;
        }
        try {
            return entity instanceof WorkerUnit;
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error checking if unit is worker for bot '{}': {}", (Object)this.botPlayer.getName(), (Object)e.getMessage());
            return false;
        }
    }

    private boolean isMilitaryUnit(LivingEntity entity) {
        if (!(entity instanceof Unit)) {
            return false;
        }
        try {
            return entity instanceof AttackerUnit && !this.isWorkerUnit(entity);
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error checking if unit is military for bot '{}': {}", (Object)this.botPlayer.getName(), (Object)e.getMessage());
            return false;
        }
    }

    public BlockPos findNearestResourceLocation(BlockPos fromPos, String resourceType) {
        try {
            int searchRadius = 64;
            BlockPos bestLocation = fromPos;
            double bestDistance = Double.MAX_VALUE;
            for (int range = 8; range <= searchRadius; range += 8) {
                for (int x = -range; x <= range; x += 8) {
                    for (int z = -range; z <= range; z += 8) {
                        double distance;
                        BlockPos searchPos = fromPos.m_7918_(x, 0, z);
                        if (!this.isResourceLocation(searchPos, resourceType) || !((distance = fromPos.m_123331_((Vec3i)searchPos)) < bestDistance)) continue;
                        bestDistance = distance;
                        bestLocation = searchPos;
                    }
                }
                if (bestDistance < (double)(range * range)) break;
            }
            return bestLocation;
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error finding resource location for bot '{}': {}", (Object)this.botPlayer.getName(), (Object)e.getMessage());
            return fromPos;
        }
    }

    private boolean isResourceLocation(BlockPos pos, String resourceType) {
        return switch (resourceType.toLowerCase()) {
            case "wood" -> {
                if (Math.random() < 0.1) {
                    yield true;
                }
                yield false;
            }
            case "stone" -> {
                if (Math.random() < 0.05) {
                    yield true;
                }
                yield false;
            }
            case "food" -> {
                if (Math.random() < 0.08) {
                    yield true;
                }
                yield false;
            }
            default -> Math.random() < 0.03;
        };
    }

    public BlockPos findNearestBuilding(BlockPos fromPos, String buildingType) {
        List<BuildingPlacement> buildings = this.getOwnedBuildings();
        BlockPos nearest = null;
        double nearestDistance = Double.MAX_VALUE;
        for (BuildingPlacement building : buildings) {
            double distance;
            if (buildingType != null) {
                if (!BuildingPlacement.structureName.equals(buildingType)) continue;
            }
            if (!((distance = fromPos.m_123331_((Vec3i)building.originPos)) < nearestDistance)) continue;
            nearestDistance = distance;
            nearest = building.originPos;
        }
        return nearest;
    }

    public int countUnits(ServerLevel level, String unitType) {
        return (int)this.getOwnedUnits(level).stream().filter(entity -> unitType == null || entity.getClass().getSimpleName().toLowerCase().contains(unitType.toLowerCase())).count();
    }

    public int countBuildings(String buildingType) {
        return (int)this.getOwnedBuildings().stream().filter(building -> {
            if (buildingType == null) return true;
            if (!BuildingPlacement.structureName.equals(buildingType)) return false;
            return true;
        }).count();
    }

    public boolean placeBuilding(String buildingName, BlockPos position) {
        try {
            Building building = this.getBuildingByName(buildingName);
            if (building == null) {
                ReignOfNether.LOGGER.debug("Bot '{}' could not find building definition for '{}'", (Object)this.botPlayer.getName(), (Object)buildingName);
                return false;
            }
            BuildingServerEvents.placeBuilding(building, position, Rotation.NONE, this.botPlayer.getName(), new int[0], false, false);
            ReignOfNether.LOGGER.debug("Bot '{}' placed '{}' at {}", (Object)this.botPlayer.getName(), (Object)buildingName, (Object)position);
            return true;
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error placing building '{}' for bot '{}': {}", (Object)buildingName, (Object)this.botPlayer.getName(), (Object)e.getMessage());
            return false;
        }
    }

    public boolean isLocationSuitableForBuilding(BlockPos position) {
        try {
            List<BuildingPlacement> existingBuildings = this.getOwnedBuildings();
            for (BuildingPlacement building : existingBuildings) {
                double distance = position.m_123331_((Vec3i)building.originPos);
                if (!(distance < 100.0)) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error checking building location for bot '{}': {}", (Object)this.botPlayer.getName(), (Object)e.getMessage());
            return false;
        }
    }

    public BlockPos findNearestBuildableLand(BlockPos fromPos, int searchRadius) {
        try {
            for (int radius = 2; radius <= searchRadius; radius += 2) {
                for (int x = -radius; x <= radius; ++x) {
                    for (int z = -radius; z <= radius; ++z) {
                        BlockPos testPos;
                        if (Math.abs(x) != radius && Math.abs(z) != radius || !this.isLocationSuitableForBuilding(testPos = fromPos.m_7918_(x, 0, z))) continue;
                        return testPos;
                    }
                }
            }
            return fromPos.m_7918_(10, 0, 10);
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error finding buildable land for bot '{}': {}", (Object)this.botPlayer.getName(), (Object)e.getMessage());
            return fromPos.m_7918_(10, 0, 10);
        }
    }

    private Building getBuildingByName(String buildingName) {
        try {
            return switch (buildingName) {
                case "Town Centre" -> Buildings.TOWN_CENTRE;
                case "Oak Stockpile" -> Buildings.OAK_STOCKPILE;
                case "Wheat Farm" -> Buildings.WHEAT_FARM;
                case "Barracks" -> Buildings.BARRACKS;
                case "Archery Range" -> Buildings.ARCANE_TOWER;
                case "Library" -> Buildings.LIBRARY;
                case "Blacksmith" -> Buildings.BLACKSMITH;
                case "Watchtower" -> Buildings.WATCHTOWER;
                case "Oak Bridge" -> Buildings.OAK_BRIDGE;
                case "Mausoleum" -> Buildings.MAUSOLEUM;
                case "Spruce Stockpile" -> Buildings.SPRUCE_STOCKPILE;
                case "Pumpkin Farm" -> Buildings.PUMPKIN_FARM;
                case "Dungeon" -> Buildings.DUNGEON;
                case "Graveyard" -> Buildings.GRAVEYARD;
                case "Laboratory" -> Buildings.LABORATORY;
                case "Haunted House" -> Buildings.HAUNTED_HOUSE;
                case "Dark Watchtower" -> Buildings.DARK_WATCHTOWER;
                case "Spruce Bridge" -> Buildings.SPRUCE_BRIDGE;
                case "Central Portal" -> Buildings.CENTRAL_PORTAL;
                case "Basalt Springs" -> Buildings.BASALT_SPRINGS;
                case "Netherwart Farm" -> Buildings.NETHERWART_FARM;
                case "Fortress" -> Buildings.FORTRESS;
                case "Flame Sanctuary" -> Buildings.FLAME_SANCTUARY;
                case "Wither Shrine" -> Buildings.WITHER_SHRINE;
                case "Hoglin Stables" -> Buildings.HOGLIN_STABLES;
                case "Blackstone Bridge" -> Buildings.BLACKSTONE_BRIDGE;
                default -> null;
            };
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error getting building '{}' for bot '{}': {}", (Object)buildingName, (Object)this.botPlayer.getName(), (Object)e.getMessage());
            return null;
        }
    }
}

