/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.bot.controllers.managers;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.bot.BotDifficulty;
import com.solegendary.reignofnether.bot.command.BotCommandInterface;
import com.solegendary.reignofnether.bot.controllers.AIStrategicController;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.buildings.placements.ProductionPlacement;
import com.solegendary.reignofnether.building.production.ProductionBuilding;
import com.solegendary.reignofnether.building.production.ProductionItem;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.resources.ResourcesServerEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.util.Faction;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;

public class MilitaryManager {
    private final AIStrategicController strategicController;
    private ArmyComposition targetComposition = ArmyComposition.BALANCED;
    private MilitaryStance currentStance = MilitaryStance.DEFENSIVE;
    private int targetArmySize = 10;
    private int currentArmySize = 0;
    private boolean isUnderAttack = false;
    private int ticksSinceLastAttack = 0;
    private long lastAttackTime = 0L;
    private double combatReadinessLevel = 0.2;
    private final Queue<MilitaryAction> actionQueue = new LinkedList<MilitaryAction>();

    public MilitaryManager(AIStrategicController strategicController) {
        this.strategicController = strategicController;
    }

    public void tick(ServerLevel level) {
        this.updateMilitaryState(level);
        this.processCombatSituation(level);
        this.processActionQueue(level);
    }

    public void makeMilitaryDecision(ServerLevel level) {
        try {
            Resources resources = this.getPlayerResources();
            if (resources == null) {
                return;
            }
            if (this.isUnderAttack) {
                this.handleEmergencyDefense(level);
                return;
            }
            if (this.shouldBuildMilitaryBuildings(resources)) {
                this.planMilitaryBuildings();
            }
            if (this.shouldProduceUnits(resources)) {
                this.planUnitProduction(resources);
            }
            if (this.shouldPlanOffensive()) {
                this.planOffensiveOperation();
            }
            ReignOfNether.LOGGER.debug("Bot '{}' made military decision: {} units, stance: {}, composition: {}", (Object)this.getBotName(), (Object)this.currentArmySize, (Object)this.currentStance, (Object)this.targetComposition);
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error in military decision making for bot '{}': {}", (Object)this.getBotName(), (Object)e.getMessage());
        }
    }

    public void makeDefensiveDecision(ServerLevel level) {
        try {
            if (this.isUnderAttack || this.shouldEnterDefensiveStance()) {
                this.currentStance = MilitaryStance.DEFENSIVE;
                this.targetComposition = ArmyComposition.DEFENSIVE;
                this.queueAction(new MilitaryAction(MilitaryAction.Type.PRODUCE_DEFENSIVE_UNITS, 0.8));
                this.queueAction(new MilitaryAction(MilitaryAction.Type.GARRISON_UNITS, 0.6));
                ReignOfNether.LOGGER.debug("Bot '{}' entering defensive stance", (Object)this.getBotName());
            }
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error in defensive decision making for bot '{}': {}", (Object)this.getBotName(), (Object)e.getMessage());
        }
    }

    private void updateMilitaryState(ServerLevel level) {
        ++this.ticksSinceLastAttack;
        if (this.ticksSinceLastAttack > 600) {
            this.isUnderAttack = false;
        }
        try {
            BotCommandInterface commandInterface = this.strategicController.getBotPlayer().getCommandInterface();
            List<LivingEntity> militaryUnits = commandInterface.getOwnedMilitaryUnits(level);
            this.currentArmySize = militaryUnits.size();
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error counting military units for bot '{}': {}", (Object)this.strategicController.getBotPlayer().getName(), (Object)e.getMessage());
            this.currentArmySize = 5;
        }
        switch (this.strategicController.getCurrentPhase()) {
            case EARLY_GAME: {
                this.targetArmySize = 5;
                break;
            }
            case MID_GAME: {
                this.targetArmySize = 12;
                break;
            }
            case LATE_GAME: {
                this.targetArmySize = 20;
            }
        }
        float difficultyMod = this.strategicController.getBotPlayer().getDifficulty().getSkillMultiplier();
        this.targetArmySize = (int)((float)this.targetArmySize * (0.5f + difficultyMod * 0.5f));
    }

    private void processCombatSituation(ServerLevel level) {
        try {
            boolean enemiesDetected = this.detectNearbyEnemies(level);
            boolean basesUnderThreat = this.assessBaseSecurity(level);
            if (enemiesDetected || basesUnderThreat) {
                if (!this.isUnderAttack) {
                    this.isUnderAttack = true;
                    this.lastAttackTime = System.currentTimeMillis();
                    ReignOfNether.LOGGER.info("Bot '{}' detected enemy threat - entering combat mode", (Object)this.strategicController.getBotPlayer().getName());
                }
                this.combatReadinessLevel = enemiesDetected ? 0.8 : 0.6;
            } else {
                this.combatReadinessLevel = Math.max(0.2, this.combatReadinessLevel - 0.1);
            }
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error processing combat situation for bot '{}': {}", (Object)this.strategicController.getBotPlayer().getName(), (Object)e.getMessage());
        }
    }

    private void processActionQueue(ServerLevel level) {
        if (this.actionQueue.isEmpty()) {
            return;
        }
        MilitaryAction action = this.actionQueue.poll();
        if (action.shouldExecute(this.strategicController.getBotPlayer().getDifficulty())) {
            this.executeAction(action, level);
        }
    }

    private void handleEmergencyDefense(ServerLevel level) {
        this.currentStance = MilitaryStance.EMERGENCY_DEFENSE;
        this.queueAction(new MilitaryAction(MilitaryAction.Type.RECALL_WORKERS, 1.0));
        this.queueAction(new MilitaryAction(MilitaryAction.Type.PRODUCE_EMERGENCY_UNITS, 0.9));
        this.queueAction(new MilitaryAction(MilitaryAction.Type.ACTIVATE_DEFENSES, 1.0));
        ReignOfNether.LOGGER.warn("Bot '{}' under attack! Initiating emergency defense", (Object)this.getBotName());
    }

    private boolean shouldBuildMilitaryBuildings(Resources resources) {
        return resources.wood >= 150 && resources.ore >= 100 && (double)this.currentArmySize < (double)this.targetArmySize * 0.3;
    }

    private boolean shouldProduceUnits(Resources resources) {
        if (this.currentArmySize >= this.targetArmySize) {
            return false;
        }
        String factionName = this.strategicController.getBotPlayer().getFaction().name().toLowerCase();
        ResourceCost unitCost = this.getAverageUnitCostByFaction(factionName);
        int costFood = unitCost.food;
        int costWood = unitCost.wood;
        int costOre = unitCost.ore;
        return resources.food >= costFood && resources.wood >= costWood && resources.ore >= costOre;
    }

    private boolean shouldPlanOffensive() {
        return !this.isUnderAttack && (double)this.currentArmySize >= (double)this.targetArmySize * 0.8 && this.currentStance != MilitaryStance.EMERGENCY_DEFENSE && this.strategicController.getCurrentPhase() != AIStrategicController.GamePhase.EARLY_GAME;
    }

    private boolean shouldEnterDefensiveStance() {
        try {
            double enemyStrength = this.estimateEnemyStrength();
            double ourStrength = (double)this.currentArmySize * this.combatReadinessLevel;
            return this.isUnderAttack || enemyStrength > ourStrength * 1.5 || this.combatReadinessLevel > 0.7;
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error checking defensive stance for bot '{}': {}", (Object)this.strategicController.getBotPlayer().getName(), (Object)e.getMessage());
            return this.isUnderAttack;
        }
    }

    private void planMilitaryBuildings() {
        ReignOfNether.LOGGER.debug("Bot '{}' planning military buildings", (Object)this.getBotName());
    }

    private void planUnitProduction(Resources resources) {
        ReignOfNether.LOGGER.debug("Bot '{}' planning unit production: {}", (Object)this.getBotName(), (Object)this.targetComposition);
        switch (this.targetComposition) {
            case OFFENSIVE: {
                this.queueAction(new MilitaryAction(MilitaryAction.Type.PRODUCE_OFFENSIVE_UNITS, 0.7));
                break;
            }
            case DEFENSIVE: {
                this.queueAction(new MilitaryAction(MilitaryAction.Type.PRODUCE_DEFENSIVE_UNITS, 0.8));
                break;
            }
            case BALANCED: {
                this.queueAction(new MilitaryAction(MilitaryAction.Type.PRODUCE_BALANCED_UNITS, 0.6));
                break;
            }
            case SPECIALIZED: {
                this.queueAction(new MilitaryAction(MilitaryAction.Type.PRODUCE_SPECIALIZED_UNITS, 0.5));
            }
        }
    }

    private void planOffensiveOperation() {
        this.currentStance = MilitaryStance.OFFENSIVE;
        ReignOfNether.LOGGER.debug("Bot '{}' planning offensive operation", (Object)this.getBotName());
        this.queueAction(new MilitaryAction(MilitaryAction.Type.SCOUT_ENEMY, 0.8));
        this.queueAction(new MilitaryAction(MilitaryAction.Type.GROUP_UNITS, 0.7));
        this.queueAction(new MilitaryAction(MilitaryAction.Type.ATTACK_ENEMY_BASE, 0.6));
    }

    private void queueAction(MilitaryAction action) {
        this.actionQueue.offer(action);
    }

    private void executeAction(MilitaryAction action, ServerLevel level) {
        ReignOfNether.LOGGER.debug("Bot '{}' executing military action: {}", (Object)this.getBotName(), (Object)action.getType());
        BotCommandInterface commandInterface = this.strategicController.getBotPlayer().getCommandInterface();
        switch (action.getType()) {
            case PRODUCE_WORKERS: {
                this.produceWorkers(commandInterface, level);
                break;
            }
            case PRODUCE_OFFENSIVE_UNITS: 
            case PRODUCE_DEFENSIVE_UNITS: 
            case PRODUCE_BALANCED_UNITS: {
                this.produceUnits(action.getType(), commandInterface, level);
                break;
            }
            case SCOUT_ENEMY: {
                BlockPos scoutTarget;
                List<LivingEntity> scouts = commandInterface.getOwnedMilitaryUnits(level);
                if (scouts.isEmpty() || (scoutTarget = this.findScoutTarget(scouts.get(0).m_20183_())) == null) break;
                commandInterface.commandUnitsToMove(scouts.subList(0, 1), scoutTarget);
                break;
            }
            case GROUP_UNITS: {
                BlockPos rallyPoint;
                List<LivingEntity> militaryUnits = commandInterface.getOwnedMilitaryUnits(level);
                if (militaryUnits.size() <= 1 || (rallyPoint = this.findRallyPoint(militaryUnits.get(0).m_20183_())) == null) break;
                commandInterface.commandUnitsToMove(militaryUnits, rallyPoint);
                break;
            }
            case ATTACK_ENEMY_BASE: {
                BlockPos enemyBase;
                List<LivingEntity> attackUnits = commandInterface.getOwnedMilitaryUnits(level);
                if (attackUnits.isEmpty() || (enemyBase = this.findEnemyBase(attackUnits.get(0).m_20183_())) == null) break;
                commandInterface.commandUnitsToAttack(attackUnits, enemyBase);
                ReignOfNether.LOGGER.info("Bot '{}' launching attack on enemy base at {}", (Object)this.getBotName(), (Object)enemyBase);
                break;
            }
            case GARRISON_UNITS: {
                List<LivingEntity> units = commandInterface.getOwnedMilitaryUnits(level);
                BlockPos nearestBuilding = commandInterface.findNearestBuilding(units.isEmpty() ? BlockPos.f_121853_ : units.get(0).m_20183_(), null);
                if (units.isEmpty() || nearestBuilding == null) break;
                commandInterface.commandUnitsToGarrison(units, nearestBuilding);
                break;
            }
            case RECALL_WORKERS: {
                List<LivingEntity> workers = commandInterface.getOwnedWorkers(level);
                BlockPos safeLocation = commandInterface.findNearestBuilding(workers.isEmpty() ? BlockPos.f_121853_ : workers.get(0).m_20183_(), "capitol");
                if (workers.isEmpty() || safeLocation == null) break;
                commandInterface.commandUnitsToMove(workers, safeLocation);
                break;
            }
            default: {
                ReignOfNether.LOGGER.debug("Bot '{}' unhandled military action: {}", (Object)this.getBotName(), (Object)action.getType());
            }
        }
    }

    private BlockPos findScoutTarget(BlockPos fromPos) {
        int x = fromPos.m_123341_() + (int)(Math.random() * 200.0 - 100.0);
        int z = fromPos.m_123343_() + (int)(Math.random() * 200.0 - 100.0);
        return new BlockPos(x, fromPos.m_123342_(), z);
    }

    private BlockPos findRallyPoint(BlockPos fromPos) {
        BlockPos mainBase = this.strategicController.getBotPlayer().getCommandInterface().findNearestBuilding(fromPos, "capitol");
        if (mainBase != null) {
            return mainBase.m_7918_(5, 0, 5);
        }
        return fromPos;
    }

    private BlockPos findEnemyBase(BlockPos fromPos) {
        try {
            String botName = this.strategicController.getBotPlayer().getName();
            for (int radius = 50; radius <= 200; radius += 50) {
                for (int angle = 0; angle < 360; angle += 45) {
                    double radians = Math.toRadians(angle);
                    int x = (int)((double)fromPos.m_123341_() + (double)radius * Math.cos(radians));
                    int z = (int)((double)fromPos.m_123343_() + (double)radius * Math.sin(radians));
                    BlockPos searchPos = new BlockPos(x, fromPos.m_123342_(), z);
                    ArrayList<BuildingPlacement> allBuildings = BuildingServerEvents.getBuildings();
                    for (BuildingPlacement building : allBuildings) {
                        double distanceToSearch;
                        if (building.ownerName.equals(botName) || building.ownerName.isEmpty() || !((distanceToSearch = building.originPos.m_123331_((Vec3i)searchPos)) < 1600.0)) continue;
                        return building.originPos;
                    }
                }
            }
            return fromPos.m_7918_(120, 0, 80);
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error finding enemy base for bot '{}': {}", (Object)this.strategicController.getBotPlayer().getName(), (Object)e.getMessage());
            return fromPos.m_7918_(100, 0, 100);
        }
    }

    private void simulateAttack() {
        this.isUnderAttack = true;
        this.ticksSinceLastAttack = 0;
        ReignOfNether.LOGGER.debug("Bot '{}' simulating attack detection", (Object)this.getBotName());
    }

    private Resources getPlayerResources() {
        String botName = this.getBotName();
        for (Resources resources : ResourcesServerEvents.resourcesList) {
            if (!resources.ownerName.equals(botName)) continue;
            return resources;
        }
        return null;
    }

    private String getBotName() {
        return this.strategicController.getBotPlayer().getName();
    }

    public void requestWorkerProduction() {
        ReignOfNether.LOGGER.debug("Bot '{}' received worker production request", (Object)this.getBotName());
        this.queueAction(new MilitaryAction(MilitaryAction.Type.PRODUCE_WORKERS, 0.9));
    }

    public void reset() {
        this.targetComposition = ArmyComposition.BALANCED;
        this.currentStance = MilitaryStance.DEFENSIVE;
        this.currentArmySize = 0;
        this.isUnderAttack = false;
        this.ticksSinceLastAttack = 0;
        this.actionQueue.clear();
    }

    public ArmyComposition getTargetComposition() {
        return this.targetComposition;
    }

    public MilitaryStance getCurrentStance() {
        return this.currentStance;
    }

    public int getCurrentArmySize() {
        return this.currentArmySize;
    }

    public int getTargetArmySize() {
        return this.targetArmySize;
    }

    public boolean isUnderAttack() {
        return this.isUnderAttack;
    }

    private ResourceCost getAverageUnitCostByFaction(String faction) {
        return switch (faction) {
            case "villagers" -> ResourceCost.Unit(60, 0, 20, 20, 1);
            case "piglins" -> ResourceCost.Unit(50, 30, 10, 20, 1);
            case "monsters" -> ResourceCost.Unit(70, 0, 30, 20, 1);
            default -> ResourceCost.Unit(60, 15, 20, 20, 1);
        };
    }

    private double estimateEnemyStrength() {
        try {
            String botName = this.strategicController.getBotPlayer().getName();
            ArrayList<BuildingPlacement> allBuildings = BuildingServerEvents.getBuildings();
            long enemyMilitaryBuildings = allBuildings.stream().filter(building -> !building.ownerName.equals(botName) && !building.ownerName.isEmpty()).filter(building -> {
                try {
                    String buildingName = building.getBuilding().structureName.toLowerCase();
                    return buildingName.contains("barracks") || buildingName.contains("archery") || buildingName.contains("fortress") || buildingName.contains("castle");
                }
                catch (Exception e) {
                    return false;
                }
            }).count();
            return (double)enemyMilitaryBuildings * 4.0;
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error estimating enemy strength for bot '{}': {}", (Object)this.strategicController.getBotPlayer().getName(), (Object)e.getMessage());
            return 5.0;
        }
    }

    private boolean detectNearbyEnemies(ServerLevel level) {
        try {
            BotCommandInterface commandInterface = this.strategicController.getBotPlayer().getCommandInterface();
            List<BuildingPlacement> ownBuildings = commandInterface.getOwnedBuildings();
            if (ownBuildings.isEmpty()) {
                return false;
            }
            String botName = this.strategicController.getBotPlayer().getName();
            for (BuildingPlacement building : ownBuildings) {
                BlockPos buildingPos = building.originPos;
                List nearbyEntities = level.m_45976_(LivingEntity.class, new AABB(buildingPos).m_82400_(32.0));
                for (LivingEntity entity : nearbyEntities) {
                    Unit unit;
                    String unitOwner;
                    if (!(entity instanceof Unit) || (unitOwner = (unit = (Unit)entity).getOwnerName()) == null || unitOwner.equals(botName) || unitOwner.isEmpty()) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error detecting nearby enemies for bot '{}': {}", (Object)this.strategicController.getBotPlayer().getName(), (Object)e.getMessage());
            return false;
        }
    }

    private boolean assessBaseSecurity(ServerLevel level) {
        try {
            BotCommandInterface commandInterface = this.strategicController.getBotPlayer().getCommandInterface();
            List<BuildingPlacement> ownBuildings = commandInterface.getOwnedBuildings();
            List<LivingEntity> militaryUnits = commandInterface.getOwnedMilitaryUnits(level);
            long importantBuildings = ownBuildings.stream().filter(building -> {
                try {
                    String buildingName = building.getBuilding().structureName.toLowerCase();
                    return buildingName.contains("town") || buildingName.contains("castle") || buildingName.contains("fortress");
                }
                catch (Exception e) {
                    return false;
                }
            }).count();
            if (importantBuildings == 0L) {
                return false;
            }
            double defenseRatio = (double)militaryUnits.size() / (double)importantBuildings;
            return defenseRatio < 2.0;
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error assessing base security for bot '{}': {}", (Object)this.strategicController.getBotPlayer().getName(), (Object)e.getMessage());
            return false;
        }
    }

    private void produceWorkers(BotCommandInterface commandInterface, ServerLevel level) {
        ReignOfNether.LOGGER.debug("Bot '{}' producing workers", (Object)this.getBotName());
        try {
            List<BuildingPlacement> allBuildings = commandInterface.getOwnedBuildings();
            ReignOfNether.LOGGER.debug("Bot '{}' owns {} buildings total", (Object)this.getBotName(), (Object)allBuildings.size());
            for (BuildingPlacement building : allBuildings) {
                ReignOfNether.LOGGER.debug("Bot '{}' owns building: '{}' (structure: '{}')", (Object)this.getBotName(), (Object)building.getBuilding().structureName, (Object)BuildingPlacement.structureName);
            }
            List<BuildingPlacement> workerBuildings = commandInterface.getOwnedBuildings().stream().filter(this::isWorkerProductionBuilding).toList();
            if (workerBuildings.isEmpty()) {
                ReignOfNether.LOGGER.debug("Bot '{}' has no worker production buildings", (Object)this.getBotName());
                return;
            }
            ReignOfNether.LOGGER.debug("Bot '{}' found {} worker production buildings", (Object)this.getBotName(), (Object)workerBuildings.size());
            for (BuildingPlacement building : workerBuildings) {
                ReignOfNether.LOGGER.debug("Bot '{}' checking worker building '{}' - Built: {}, Owner: '{}'", (Object)this.getBotName(), (Object)building.getBuilding().structureName, (Object)building.isBuilt, (Object)building.ownerName);
                if (!building.isBuilt) {
                    ReignOfNether.LOGGER.debug("Bot '{}' skipping unbuilt building '{}'", (Object)this.getBotName(), (Object)building.getBuilding().structureName);
                    continue;
                }
                if (!(building instanceof ProductionPlacement)) continue;
                ProductionPlacement prodBuilding = (ProductionPlacement)building;
                if (!prodBuilding.productionQueue.isEmpty()) continue;
                String workerType = this.getWorkerTypeForFaction(this.strategicController.getBotPlayer().getFaction());
                ProductionItem workerProduction = this.findProductionItemByName(prodBuilding, workerType);
                if (workerProduction != null) {
                    boolean success = prodBuilding.startProductionItem(workerProduction, building.originPos);
                    if (success) {
                        ReignOfNether.LOGGER.info("Bot '{}' started producing {} worker at {}", (Object)this.getBotName(), (Object)workerType, (Object)building.originPos);
                        break;
                    }
                    ReignOfNether.LOGGER.debug("Bot '{}' failed to start producing {} worker (insufficient resources?)", (Object)this.getBotName(), (Object)workerType);
                    continue;
                }
                ReignOfNether.LOGGER.debug("Bot '{}' could not find production item for {} worker", (Object)this.getBotName(), (Object)workerType);
            }
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error producing workers for bot '{}': {}", (Object)this.getBotName(), (Object)e.getMessage());
        }
    }

    private boolean isWorkerProductionBuilding(BuildingPlacement building) {
        String buildingName = building.getBuilding().structureName.toLowerCase();
        return buildingName.contains("town") || buildingName.contains("mausoleum") || buildingName.contains("central_portal") || buildingName.contains("capitol");
    }

    private String getWorkerTypeForFaction(Faction faction) {
        return switch (faction) {
            case Faction.VILLAGERS -> "Villager";
            case Faction.MONSTERS -> "Zombie Villager";
            case Faction.PIGLINS -> "Grunt";
            default -> "Villager";
        };
    }

    private void produceUnits(MilitaryAction.Type actionType, BotCommandInterface commandInterface, ServerLevel level) {
        ReignOfNether.LOGGER.debug("Bot '{}' producing military units: {}", (Object)this.getBotName(), (Object)actionType);
        try {
            List<BuildingPlacement> productionBuildings = commandInterface.getOwnedBuildings().stream().filter(this::isMilitaryProductionBuilding).toList();
            if (productionBuildings.isEmpty()) {
                ReignOfNether.LOGGER.debug("Bot '{}' has no military production buildings", (Object)this.getBotName());
                return;
            }
            for (BuildingPlacement building : productionBuildings) {
                if (!(building instanceof ProductionPlacement)) continue;
                ProductionPlacement prodBuilding = (ProductionPlacement)building;
                if (!prodBuilding.productionQueue.isEmpty()) continue;
                String unitTypeToProduce = this.selectUnitTypeToProduce(actionType, this.strategicController.getBotPlayer().getFaction());
                ProductionItem unitProduction = this.findProductionItemByName(prodBuilding, unitTypeToProduce);
                if (unitProduction != null) {
                    boolean success = prodBuilding.startProductionItem(unitProduction, building.originPos);
                    if (success) {
                        ReignOfNether.LOGGER.info("Bot '{}' started producing {} at {}", (Object)this.getBotName(), (Object)unitTypeToProduce, (Object)building.originPos);
                        break;
                    }
                    ReignOfNether.LOGGER.debug("Bot '{}' failed to start producing {} (insufficient resources?)", (Object)this.getBotName(), (Object)unitTypeToProduce);
                    continue;
                }
                ReignOfNether.LOGGER.debug("Bot '{}' could not find production item for {}", (Object)this.getBotName(), (Object)unitTypeToProduce);
            }
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error producing units for bot '{}': {}", (Object)this.getBotName(), (Object)e.getMessage());
        }
    }

    private boolean isMilitaryProductionBuilding(BuildingPlacement building) {
        String buildingName = building.getBuilding().structureName.toLowerCase();
        return buildingName.contains("barracks") || buildingName.contains("stable") || buildingName.contains("archery") || buildingName.contains("fortress") || buildingName.contains("bastion");
    }

    private String selectUnitTypeToProduce(MilitaryAction.Type actionType, Faction faction) {
        return switch (faction) {
            case Faction.VILLAGERS -> {
                switch (actionType) {
                    case PRODUCE_OFFENSIVE_UNITS: {
                        yield "Vindicator";
                    }
                    case PRODUCE_DEFENSIVE_UNITS: {
                        yield "Iron Golem";
                    }
                    case PRODUCE_BALANCED_UNITS: {
                        if (Math.random() < 0.5) {
                            yield "Vindicator";
                        }
                        yield "Pillager";
                    }
                }
                yield "Vindicator";
            }
            case Faction.MONSTERS -> {
                switch (actionType) {
                    case PRODUCE_OFFENSIVE_UNITS: {
                        yield "Zombie";
                    }
                    case PRODUCE_DEFENSIVE_UNITS: {
                        yield "Skeleton";
                    }
                    case PRODUCE_BALANCED_UNITS: {
                        if (Math.random() < 0.5) {
                            yield "Zombie";
                        }
                        yield "Skeleton";
                    }
                }
                yield "Zombie";
            }
            case Faction.PIGLINS -> {
                switch (actionType) {
                    case PRODUCE_OFFENSIVE_UNITS: {
                        yield "Brute";
                    }
                    case PRODUCE_DEFENSIVE_UNITS: {
                        yield "Grunt";
                    }
                    case PRODUCE_BALANCED_UNITS: {
                        if (Math.random() < 0.5) {
                            yield "Brute";
                        }
                        yield "Grunt";
                    }
                }
                yield "Grunt";
            }
            default -> "Villager";
        };
    }

    private ProductionItem findProductionItemByName(ProductionPlacement building, String unitName) {
        try {
            Building building2 = building.getBuilding();
            if (!(building2 instanceof ProductionBuilding)) {
                return null;
            }
            ProductionBuilding prodBuilding = (ProductionBuilding)building2;
            for (ProductionItem prodItem : prodBuilding.productions.productions.keySet()) {
                String itemName = prodItem.getItemName();
                if (itemName == null || !itemName.toLowerCase().contains(unitName.toLowerCase())) continue;
                return prodItem;
            }
            return null;
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error finding production item '{}': {}", (Object)unitName, (Object)e.getMessage());
            return null;
        }
    }

    public static enum ArmyComposition {
        OFFENSIVE,
        DEFENSIVE,
        BALANCED,
        SPECIALIZED;

    }

    public static enum MilitaryStance {
        DEFENSIVE,
        OFFENSIVE,
        EMERGENCY_DEFENSE,
        SCOUTING,
        REGROUPING;

    }

    public static class MilitaryAction {
        private final Type type;
        private final double priority;
        private final long createdTime;

        public MilitaryAction(Type type, double priority) {
            this.type = type;
            this.priority = priority;
            this.createdTime = System.currentTimeMillis();
        }

        public boolean shouldExecute(BotDifficulty difficulty) {
            return Math.random() < this.priority * (double)difficulty.getSkillMultiplier();
        }

        public Type getType() {
            return this.type;
        }

        public double getPriority() {
            return this.priority;
        }

        public static enum Type {
            PRODUCE_OFFENSIVE_UNITS,
            PRODUCE_DEFENSIVE_UNITS,
            PRODUCE_BALANCED_UNITS,
            PRODUCE_SPECIALIZED_UNITS,
            PRODUCE_EMERGENCY_UNITS,
            PRODUCE_WORKERS,
            SCOUT_ENEMY,
            GROUP_UNITS,
            ATTACK_ENEMY_BASE,
            GARRISON_UNITS,
            RECALL_WORKERS,
            ACTIVATE_DEFENSES;

        }
    }
}

