/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.bot.ml;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.bot.ml.ActionType;
import com.solegendary.reignofnether.bot.ml.GamePhase;
import com.solegendary.reignofnether.bot.ml.GameState;
import com.solegendary.reignofnether.bot.ml.StrategicPriority;

public class GameStateVectorizer {
    private static final int RESOURCE_FEATURES = 6;
    private static final int UNIT_FEATURES = 12;
    private static final int BUILDING_FEATURES = 10;
    private static final int STRATEGIC_FEATURES = 8;
    private static final int TACTICAL_FEATURES = 8;
    private static final int HISTORICAL_FEATURES = 20;
    public static final int TOTAL_FEATURES = 64;

    public double[] vectorizeGameState(GameState gameState) {
        double[] vector = new double[64];
        int index = 0;
        try {
            index = this.addResourceFeatures(vector, index, gameState);
            index = this.addUnitFeatures(vector, index, gameState);
            index = this.addBuildingFeatures(vector, index, gameState);
            index = this.addStrategicFeatures(vector, index, gameState);
            index = this.addTacticalFeatures(vector, index, gameState);
            index = this.addHistoricalFeatures(vector, index, gameState);
            return this.normalizeVector(vector);
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error vectorizing game state: {}", (Object)e.getMessage());
            return new double[64];
        }
    }

    private int addResourceFeatures(double[] vector, int index, GameState state) {
        vector[index++] = this.normalize(state.selfResources.food, 0.0, 2000.0);
        vector[index++] = this.normalize(state.selfResources.wood, 0.0, 3000.0);
        vector[index++] = this.normalize(state.selfResources.ore, 0.0, 1500.0);
        vector[index++] = this.normalize(state.enemyResourcesEstimate.food, 0.0, 2000.0);
        vector[index++] = this.normalize(state.enemyResourcesEstimate.wood, 0.0, 3000.0);
        vector[index++] = this.normalize(state.enemyResourcesEstimate.ore, 0.0, 1500.0);
        return index;
    }

    private int addUnitFeatures(double[] vector, int index, GameState state) {
        vector[index++] = this.normalize(state.selfUnits.workers, 0.0, 20.0);
        vector[index++] = this.normalize(state.selfUnits.militaryUnits, 0.0, 50.0);
        vector[index++] = this.normalize(state.selfUnits.rangedUnits, 0.0, 30.0);
        vector[index++] = this.normalize(state.selfUnits.meleeUnits, 0.0, 40.0);
        vector[index++] = this.normalize(state.selfUnits.specialUnits, 0.0, 10.0);
        vector[index++] = this.normalize(state.selfUnits.heroUnits, 0.0, 3.0);
        vector[index++] = this.normalize(state.enemyUnitsEstimate.workers, 0.0, 20.0);
        vector[index++] = this.normalize(state.enemyUnitsEstimate.militaryUnits, 0.0, 50.0);
        vector[index++] = this.normalize(state.enemyUnitsEstimate.rangedUnits, 0.0, 30.0);
        vector[index++] = this.normalize(state.enemyUnitsEstimate.meleeUnits, 0.0, 40.0);
        vector[index++] = this.normalize(state.enemyUnitsEstimate.specialUnits, 0.0, 10.0);
        vector[index++] = this.normalize(state.enemyUnitsEstimate.heroUnits, 0.0, 3.0);
        return index;
    }

    private int addBuildingFeatures(double[] vector, int index, GameState state) {
        vector[index++] = this.normalize(state.selfBuildings.capitols, 0.0, 3.0);
        vector[index++] = this.normalize(state.selfBuildings.economicBuildings, 0.0, 15.0);
        vector[index++] = this.normalize(state.selfBuildings.militaryBuildings, 0.0, 10.0);
        vector[index++] = this.normalize(state.selfBuildings.defensiveBuildings, 0.0, 8.0);
        vector[index++] = this.normalize(state.selfBuildings.techBuildings, 0.0, 5.0);
        vector[index++] = this.normalize(state.enemyBuildingsEstimate.capitols, 0.0, 3.0);
        vector[index++] = this.normalize(state.enemyBuildingsEstimate.economicBuildings, 0.0, 15.0);
        vector[index++] = this.normalize(state.enemyBuildingsEstimate.militaryBuildings, 0.0, 10.0);
        vector[index++] = this.normalize(state.enemyBuildingsEstimate.defensiveBuildings, 0.0, 8.0);
        vector[index++] = this.normalize(state.enemyBuildingsEstimate.techBuildings, 0.0, 5.0);
        return index;
    }

    private int addStrategicFeatures(double[] vector, int index, GameState state) {
        vector[index++] = this.normalize(state.gameTime, 0.0, 72000.0);
        vector[index++] = this.encodeGamePhase(state.gamePhase);
        vector[index++] = this.normalize(state.mapControlPercentage, 0.0, 100.0);
        vector[index++] = this.normalizeAdvantage(state.resourceAdvantage);
        vector[index++] = this.normalizeAdvantage(state.militaryAdvantage);
        vector[index++] = this.normalizeAdvantage(state.technologyAdvantage);
        vector[index++] = this.normalize(state.economicStrength, 0.0, 200.0);
        vector[index++] = this.encodeStrategicPriority(state.currentPriority);
        return index;
    }

    private int addTacticalFeatures(double[] vector, int index, GameState state) {
        vector[index++] = state.isInCombat ? 1.0 : 0.0;
        vector[index++] = state.isUnderAttack ? 1.0 : 0.0;
        vector[index++] = this.normalize(state.threatLevel, 0.0, 10.0);
        vector[index++] = this.normalize(state.opportunityScore, 0.0, 10.0);
        vector[index++] = this.normalize(state.distanceToEnemy, 0.0, 1000.0);
        vector[index++] = this.normalize(state.defensiveStrength, 0.0, 100.0);
        vector[index++] = this.normalize(state.offensiveCapability, 0.0, 100.0);
        vector[index++] = this.normalize(state.recentLosses, 0.0, 20.0);
        return index;
    }

    private int addHistoricalFeatures(double[] vector, int index, GameState state) {
        for (int i = 0; i < 5; ++i) {
            vector[index++] = i < state.recentActions.size() ? this.encodeAction(state.recentActions.get(i)) : 0.0;
        }
        vector[index++] = state.recentSuccessRate;
        vector[index++] = state.historicalWinRate;
        vector[index++] = this.normalize(state.averageGameLength, 0.0, 72000.0);
        vector[index++] = state.economicPreference;
        vector[index++] = state.militaryPreference;
        vector[index++] = state.expansionPreference;
        vector[index++] = state.technologyPreference;
        vector[index++] = state.adaptationRate;
        vector[index++] = state.learningProgress;
        vector[index++] = this.normalizeAdvantage(state.performanceTrend);
        vector[index++] = state.opponentModelConfidence;
        vector[index++] = state.metaGameAwareness;
        return index;
    }

    private double normalize(double value, double min, double max) {
        if (max == min) {
            return 0.5;
        }
        return Math.max(0.0, Math.min(1.0, (value - min) / (max - min)));
    }

    private double normalizeAdvantage(double advantage) {
        double clamped = Math.max(-2.0, Math.min(2.0, advantage));
        return (clamped + 2.0) / 4.0;
    }

    private double encodeGamePhase(GamePhase phase) {
        return switch (phase) {
            default -> throw new IncompatibleClassChangeError();
            case GamePhase.EARLY_GAME -> 0.0;
            case GamePhase.MID_GAME -> 0.5;
            case GamePhase.LATE_GAME -> 1.0;
        };
    }

    private double encodeStrategicPriority(StrategicPriority priority) {
        return switch (priority) {
            default -> throw new IncompatibleClassChangeError();
            case StrategicPriority.ECONOMY -> 0.0;
            case StrategicPriority.MILITARY -> 0.25;
            case StrategicPriority.EXPANSION -> 0.5;
            case StrategicPriority.TECHNOLOGY -> 0.75;
            case StrategicPriority.DEFENSE -> 1.0;
        };
    }

    private double encodeAction(ActionType action) {
        return switch (action) {
            default -> throw new IncompatibleClassChangeError();
            case ActionType.GATHER_RESOURCES -> 0.05;
            case ActionType.BUILD_ECONOMIC -> 0.1;
            case ActionType.BUILD_MILITARY -> 0.15;
            case ActionType.PRODUCE_WORKERS -> 0.2;
            case ActionType.PRODUCE_MILITARY -> 0.25;
            case ActionType.ATTACK -> 0.3;
            case ActionType.DEFEND -> 0.35;
            case ActionType.EXPAND -> 0.4;
            case ActionType.RESEARCH -> 0.45;
            case ActionType.SCOUT -> 0.5;
            case ActionType.UPGRADE -> 0.55;
            case ActionType.RETREAT -> 0.6;
            case ActionType.ECONOMIC_DECISION -> 0.65;
            case ActionType.MILITARY_DECISION -> 0.7;
            case ActionType.STRATEGIC_DECISION -> 0.75;
            case ActionType.NONE -> 0.0;
        };
    }

    private double[] normalizeVector(double[] vector) {
        double sum = 0.0;
        for (double v : vector) {
            sum += v;
        }
        double mean = sum / (double)vector.length;
        double sumSquaredDiffs = 0.0;
        for (double v : vector) {
            sumSquaredDiffs += (v - mean) * (v - mean);
        }
        double stdDev = Math.sqrt(sumSquaredDiffs / (double)vector.length);
        if (stdDev < 1.0E-8) {
            return vector;
        }
        double[] normalized = new double[vector.length];
        for (int i = 0; i < vector.length; ++i) {
            double zScore = (vector[i] - mean) / stdDev;
            normalized[i] = Math.max(0.0, Math.min(1.0, (zScore + 3.0) / 6.0));
        }
        return normalized;
    }

    public String[] getFeatureNames() {
        String[] names = new String[64];
        int index = 0;
        names[index++] = "self_food";
        names[index++] = "self_wood";
        names[index++] = "self_ore";
        names[index++] = "enemy_food_est";
        names[index++] = "enemy_wood_est";
        names[index++] = "enemy_ore_est";
        names[index++] = "self_workers";
        names[index++] = "self_military";
        names[index++] = "self_ranged";
        names[index++] = "self_melee";
        names[index++] = "self_special";
        names[index++] = "self_heroes";
        names[index++] = "enemy_workers_est";
        names[index++] = "enemy_military_est";
        names[index++] = "enemy_ranged_est";
        names[index++] = "enemy_melee_est";
        names[index++] = "enemy_special_est";
        names[index++] = "enemy_heroes_est";
        names[index++] = "self_capitols";
        names[index++] = "self_economic_buildings";
        names[index++] = "self_military_buildings";
        names[index++] = "self_defensive_buildings";
        names[index++] = "self_tech_buildings";
        names[index++] = "enemy_capitols_est";
        names[index++] = "enemy_economic_buildings_est";
        names[index++] = "enemy_military_buildings_est";
        names[index++] = "enemy_defensive_buildings_est";
        names[index++] = "enemy_tech_buildings_est";
        names[index++] = "game_time";
        names[index++] = "game_phase";
        names[index++] = "map_control";
        names[index++] = "resource_advantage";
        names[index++] = "military_advantage";
        names[index++] = "tech_advantage";
        names[index++] = "economic_strength";
        names[index++] = "strategic_priority";
        names[index++] = "in_combat";
        names[index++] = "under_attack";
        names[index++] = "threat_level";
        names[index++] = "opportunity_score";
        names[index++] = "distance_to_enemy";
        names[index++] = "defensive_strength";
        names[index++] = "offensive_capability";
        names[index++] = "recent_losses";
        for (int i = 0; i < 5; ++i) {
            names[index++] = "recent_action_" + i;
        }
        names[index++] = "success_rate";
        names[index++] = "win_rate";
        names[index++] = "avg_game_length";
        names[index++] = "economic_preference";
        names[index++] = "military_preference";
        names[index++] = "expansion_preference";
        names[index++] = "tech_preference";
        names[index++] = "adaptation_rate";
        names[index++] = "learning_progress";
        names[index++] = "performance_trend";
        names[index++] = "opponent_confidence";
        names[index++] = "meta_awareness";
        return names;
    }
}

