/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.bot.ml;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.bot.AIBotPlayer;
import com.solegendary.reignofnether.bot.BotManager;
import com.solegendary.reignofnether.bot.ml.ActionType;
import com.solegendary.reignofnether.bot.ml.AdaptiveDifficultyManager;
import com.solegendary.reignofnether.bot.ml.DataCollectionManager;
import com.solegendary.reignofnether.bot.ml.GamePhase;
import com.solegendary.reignofnether.bot.ml.GameState;
import com.solegendary.reignofnether.bot.ml.MLDecision;
import com.solegendary.reignofnether.bot.ml.MLFramework;
import com.solegendary.reignofnether.bot.ml.PlayerAction;
import com.solegendary.reignofnether.bot.ml.PlayerBehaviorAnalyzer;
import com.solegendary.reignofnether.bot.ml.StrategicPriority;
import com.solegendary.reignofnether.player.PlayerServerEvents;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;

public class MLCommandInterface {
    public static void startTestSession(CommandSourceStack source) {
        try {
            String sessionId = "test-session-" + System.currentTimeMillis();
            List<String> playerNames = PlayerServerEvents.rtsPlayers.stream().filter(p -> BotManager.getBotByName(p.name) == null).map(p -> p.name).collect(Collectors.toList());
            BotManager.startMLGameSession(sessionId, playerNames, "test");
            source.m_288197_(() -> Component.m_237113_((String)("Started ML test session '" + sessionId + "' with " + playerNames.size() + " players and " + BotManager.getActiveBotCount() + " bots")), true);
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("Failed to start ML test session: " + e.getMessage())));
            ReignOfNether.LOGGER.error("Error starting ML test session", (Throwable)e);
        }
    }

    public static void endTestSession(CommandSourceStack source) {
        try {
            HashMap<String, Boolean> results = new HashMap<String, Boolean>();
            PlayerServerEvents.rtsPlayers.stream().filter(p -> BotManager.getBotByName(p.name) == null).forEach(p -> results.put(p.name, true));
            BotManager.getAllBots().forEach(bot -> results.put(bot.getName(), false));
            BotManager.endMLGameSession(results, "Test session ended");
            source.m_288197_(() -> Component.m_237113_((String)("Ended ML test session with results: " + results)), true);
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("Failed to end ML test session: " + e.getMessage())));
            ReignOfNether.LOGGER.error("Error ending ML test session", (Throwable)e);
        }
    }

    public static void getMLStatistics(CommandSourceStack source) {
        try {
            MLFramework framework = MLFramework.getInstance();
            if (!framework.isReady()) {
                source.m_81352_((Component)Component.m_237113_((String)"ML Framework is not initialized"));
                return;
            }
            StringBuilder stats = new StringBuilder("=== ML Framework Statistics ===\n");
            MLFramework.MLStatistics mlStats = framework.getStatistics();
            stats.append(mlStats.toString()).append("\n");
            DataCollectionManager.DataCollectionStatistics dataStats = framework.getDataCollectionStatistics();
            if (dataStats != null) {
                stats.append(dataStats.toString()).append("\n");
            }
            stats.append("\n=== Bot Performance Analysis ===\n");
            for (AIBotPlayer bot : BotManager.getAllBots()) {
                PlayerBehaviorAnalyzer.BehaviorAnalysis analysis = framework.getPlayerBehaviorAnalysis(bot.getName());
                if (analysis == null) continue;
                stats.append(analysis.toString()).append("\n");
            }
            source.m_288197_(() -> Component.m_237113_((String)stats.toString()), true);
            ReignOfNether.LOGGER.info("ML Statistics requested via command: {}", (Object)stats.toString());
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("Failed to get ML statistics: " + e.getMessage())));
            ReignOfNether.LOGGER.error("Error getting ML statistics", (Throwable)e);
        }
    }

    public static void testMLDecision(CommandSourceStack source, String botName) {
        try {
            AIBotPlayer bot = BotManager.getBotByName(botName);
            if (bot == null) {
                source.m_81352_((Component)Component.m_237113_((String)("Bot '" + botName + "' not found")));
                return;
            }
            MLFramework framework = MLFramework.getInstance();
            if (!framework.isReady()) {
                source.m_81352_((Component)Component.m_237113_((String)"ML Framework is not initialized"));
                return;
            }
            GameState testState = MLCommandInterface.createTestGameState();
            MLDecision decision = framework.getStrategicDecision(testState, botName);
            if (decision == null) {
                source.m_288197_(() -> Component.m_237113_((String)("Bot '" + botName + "' - ML system returned no decision (falling back to rules)")), true);
            } else {
                source.m_288197_(() -> Component.m_237113_((String)("Bot '" + botName + "' - ML Decision: " + decision.getDecisionType() + " (confidence: " + String.format("%.2f", decision.getConfidence()) + ")")), true);
                framework.recordDecisionOutcome(botName, testState, decision, 0.8, "Command test");
            }
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("Failed to test ML decision: " + e.getMessage())));
            ReignOfNether.LOGGER.error("Error testing ML decision", (Throwable)e);
        }
    }

    public static void triggerMLTraining(CommandSourceStack source) {
        try {
            MLFramework framework = MLFramework.getInstance();
            if (!framework.isReady()) {
                source.m_81352_((Component)Component.m_237113_((String)"ML Framework is not initialized"));
                return;
            }
            framework.getLearningPipeline().forceTraining();
            source.m_288197_(() -> Component.m_237113_((String)"ML training session triggered manually"), true);
            ReignOfNether.LOGGER.info("ML training triggered manually via command");
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("Failed to trigger ML training: " + e.getMessage())));
            ReignOfNether.LOGGER.error("Error triggering ML training", (Throwable)e);
        }
    }

    public static void toggleOnlineLearning(CommandSourceStack source) {
        try {
            MLFramework framework = MLFramework.getInstance();
            if (!framework.isReady()) {
                source.m_81352_((Component)Component.m_237113_((String)"ML Framework is not initialized"));
                return;
            }
            boolean currentState = framework.getOnlineLearningManager().isOnlineLearningEnabled();
            framework.setOnlineLearningEnabled(!currentState);
            source.m_288197_(() -> Component.m_237113_((String)("Online learning " + (!currentState ? "enabled" : "disabled"))), true);
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("Failed to toggle online learning: " + e.getMessage())));
            ReignOfNether.LOGGER.error("Error toggling online learning", (Throwable)e);
        }
    }

    public static void testPlayerActionRecording(CommandSourceStack source, String playerName) {
        try {
            MLFramework framework = MLFramework.getInstance();
            if (!framework.isReady()) {
                source.m_81352_((Component)Component.m_237113_((String)"ML Framework is not initialized"));
                return;
            }
            GameState testState = MLCommandInterface.createTestGameState();
            PlayerAction testAction = new PlayerAction(ActionType.GATHER_RESOURCES, Map.of("resourceType", 1.0, "intensity", 0.8), null, playerName);
            PlayerBehaviorAnalyzer.ActionOutcome outcome = new PlayerBehaviorAnalyzer.ActionOutcome(0.9, "Command test", 5000L);
            framework.recordPlayerAction("test-session", playerName, testState, testAction, outcome);
            source.m_288197_(() -> Component.m_237113_((String)("Recorded test action for player '" + playerName + "': " + testAction.getActionType())), true);
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("Failed to record test action: " + e.getMessage())));
            ReignOfNether.LOGGER.error("Error recording test action", (Throwable)e);
        }
    }

    public static void getDifficultyAdjustment(CommandSourceStack source, String playerName, String botName) {
        try {
            MLFramework framework = MLFramework.getInstance();
            if (!framework.isReady()) {
                source.m_81352_((Component)Component.m_237113_((String)"ML Framework is not initialized"));
                return;
            }
            AdaptiveDifficultyManager.DifficultyAdjustment adjustment = framework.getDifficultyAdjustment(playerName, botName);
            if (adjustment == null) {
                source.m_288197_(() -> Component.m_237113_((String)("No difficulty data available for " + playerName + " vs " + botName)), true);
            } else {
                source.m_288197_(() -> Component.m_237113_((String)("Difficulty adjustment for " + playerName + " vs " + botName + ": " + adjustment.toString())), true);
            }
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("Failed to get difficulty adjustment: " + e.getMessage())));
            ReignOfNether.LOGGER.error("Error getting difficulty adjustment", (Throwable)e);
        }
    }

    private static GameState createTestGameState() {
        GameState state = new GameState();
        state.gameTime = 12000L;
        state.gamePhase = GamePhase.MID_GAME;
        state.currentPriority = StrategicPriority.MILITARY;
        state.selfResources.food = 150;
        state.selfResources.wood = 200;
        state.selfResources.ore = 75;
        state.enemyResourcesEstimate.food = 120;
        state.enemyResourcesEstimate.wood = 180;
        state.enemyResourcesEstimate.ore = 60;
        state.selfUnits.workers = 8;
        state.selfUnits.militaryUnits = 12;
        state.selfUnits.rangedUnits = 5;
        state.selfUnits.meleeUnits = 7;
        state.enemyUnitsEstimate.workers = 6;
        state.enemyUnitsEstimate.militaryUnits = 10;
        state.selfBuildings.capitols = 1;
        state.selfBuildings.economicBuildings = 3;
        state.selfBuildings.militaryBuildings = 2;
        state.mapControlPercentage = 35.0;
        state.resourceAdvantage = 1.2;
        state.militaryAdvantage = 1.1;
        state.economicStrength = 0.8;
        state.isInCombat = false;
        state.isUnderAttack = false;
        state.threatLevel = 3.5;
        return state;
    }

    public static void initializeMLFramework(CommandSourceStack source) {
        try {
            MLFramework framework = MLFramework.getInstance();
            if (framework.isReady()) {
                source.m_288197_(() -> Component.m_237113_((String)"ML Framework is already initialized"), true);
            } else {
                framework.initialize();
                source.m_288197_(() -> Component.m_237113_((String)"ML Framework initialized successfully"), true);
            }
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("Failed to initialize ML Framework: " + e.getMessage())));
            ReignOfNether.LOGGER.error("Error initializing ML Framework", (Throwable)e);
        }
    }

    public static void showMLStatus(CommandSourceStack source) {
        try {
            MLFramework framework = MLFramework.getInstance();
            StringBuilder status = new StringBuilder("=== ML Framework Status ===\n");
            status.append("Framework Ready: ").append(framework.isReady()).append("\n");
            if (framework.isReady()) {
                status.append("Neural Networks: ").append(framework.getNetworkManager().getActiveNetworkCount()).append(" active\n");
                status.append("Online Learning: ").append(framework.getOnlineLearningManager().isOnlineLearningEnabled()).append("\n");
                status.append("Data Collection: ").append(framework.getDataCollectionManager().isEnabled()).append("\n");
                MLFramework.MLStatistics stats = framework.getStatistics();
                status.append("Training Examples: ").append(stats.trainingExamples).append("\n");
                status.append("Games Analyzed: ").append(stats.gamesAnalyzed).append("\n");
                status.append("Training Iterations: ").append(stats.trainingIterations).append("\n");
                status.append("Average Accuracy: ").append(String.format("%.2f%%", stats.averageAccuracy * 100.0)).append("\n");
            }
            status.append("Active Bots: ").append(BotManager.getActiveBotCount()).append("\n");
            source.m_288197_(() -> Component.m_237113_((String)status.toString()), true);
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("Failed to get ML status: " + e.getMessage())));
            ReignOfNether.LOGGER.error("Error getting ML status", (Throwable)e);
        }
    }
}

