/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.bot.ml;

import java.util.HashMap;
import java.util.Map;

public class MLDecision {
    private final DecisionType decisionType;
    private final double confidence;
    private final Map<String, Double> parameters;
    private final String reasoning;
    private final long timestamp;

    public MLDecision(DecisionType decisionType, double confidence, Map<String, Double> parameters, String reasoning) {
        this.decisionType = decisionType;
        this.confidence = Math.max(0.0, Math.min(1.0, confidence));
        this.parameters = new HashMap<String, Double>(parameters);
        this.reasoning = reasoning;
        this.timestamp = System.currentTimeMillis();
    }

    public MLDecision(DecisionType decisionType, double confidence) {
        this(decisionType, confidence, new HashMap<String, Double>(), "");
    }

    public DecisionType getDecisionType() {
        return this.decisionType;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public Map<String, Double> getParameters() {
        return new HashMap<String, Double>(this.parameters);
    }

    public double getParameter(String key, double defaultValue) {
        return this.parameters.getOrDefault(key, defaultValue);
    }

    public String getReasoning() {
        return this.reasoning;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isTrusted(double threshold) {
        return this.confidence >= threshold;
    }

    public boolean isRecent(long maxAgeMs) {
        return System.currentTimeMillis() - this.timestamp <= maxAgeMs;
    }

    public String toString() {
        return String.format("MLDecision{type=%s, confidence=%.2f, params=%d, reasoning='%s'}", new Object[]{this.decisionType, this.confidence, this.parameters.size(), this.reasoning});
    }

    public static enum DecisionType {
        FOCUS_ON_ECONOMY,
        PRODUCE_WORKERS,
        BUILD_ECONOMIC_BUILDINGS,
        GATHER_SPECIFIC_RESOURCE,
        FOCUS_ON_MILITARY,
        PRODUCE_MILITARY_UNITS,
        BUILD_MILITARY_BUILDINGS,
        ATTACK_ENEMY,
        DEFEND_BASE,
        EXPAND_TERRITORY,
        RESEARCH_TECHNOLOGY,
        CHANGE_STRATEGY,
        RETREAT_AND_REBUILD,
        GROUP_UNITS,
        SCOUT_ENEMY,
        HARASS_ENEMY,
        FORTIFY_POSITION,
        NO_DECISION,
        FALLBACK_TO_RULES;

    }
}

