/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.bot.ml;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.bot.AIBotPlayer;
import com.solegendary.reignofnether.bot.BotDifficulty;
import com.solegendary.reignofnether.bot.BotManager;
import com.solegendary.reignofnether.bot.controllers.AIStrategicController;
import com.solegendary.reignofnether.bot.ml.ActionType;
import com.solegendary.reignofnether.bot.ml.AdaptiveDifficultyManager;
import com.solegendary.reignofnether.bot.ml.DataCollectionManager;
import com.solegendary.reignofnether.bot.ml.GameMetrics;
import com.solegendary.reignofnether.bot.ml.GamePhase;
import com.solegendary.reignofnether.bot.ml.GameState;
import com.solegendary.reignofnether.bot.ml.MLDecision;
import com.solegendary.reignofnether.bot.ml.MLFramework;
import com.solegendary.reignofnether.bot.ml.OnlineLearningManager;
import com.solegendary.reignofnether.bot.ml.PlayerAction;
import com.solegendary.reignofnether.bot.ml.PlayerBehaviorAnalyzer;
import com.solegendary.reignofnether.bot.ml.StrategicPriority;
import com.solegendary.reignofnether.util.Faction;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class MLFrameworkTest {
    private static final String TEST_SESSION_ID = "ml-test-session";
    private static final String TEST_PLAYER_NAME = "TestPlayer";
    private static final String TEST_BOT_NAME = "TestBot";

    public static void runComprehensiveTest() {
        ReignOfNether.LOGGER.info("=== Starting ML Framework Comprehensive Test ===");
        try {
            MLFrameworkTest.testFrameworkInitialization();
            MLFrameworkTest.testGameSessionManagement();
            MLFrameworkTest.testPlayerActionRecording();
            MLFrameworkTest.testBotDecisionMaking();
            MLFrameworkTest.testOnlineLearning();
            MLFrameworkTest.testAdaptiveDifficulty();
            MLFrameworkTest.testDataCollection();
            MLFrameworkTest.testTrainingPipeline();
            MLFrameworkTest.testPlayerBehaviorAnalysis();
            MLFrameworkTest.testPerformanceStatistics();
            ReignOfNether.LOGGER.info("=== ML Framework Comprehensive Test Completed Successfully ===");
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("ML Framework test failed: {}", (Object)e.getMessage());
            throw new RuntimeException("ML Framework test failure", e);
        }
    }

    private static void testFrameworkInitialization() {
        ReignOfNether.LOGGER.info("Testing ML Framework initialization...");
        MLFramework framework = MLFramework.getInstance();
        framework.initialize();
        assert (framework.isReady()) : "Framework should be ready after initialization";
        assert (framework.getNetworkManager() != null) : "Network manager should be initialized";
        assert (framework.getDataManager() != null) : "Data manager should be initialized";
        assert (framework.getLearningPipeline() != null) : "Learning pipeline should be initialized";
        assert (framework.getDifficultyManager() != null) : "Difficulty manager should be initialized";
        assert (framework.getOnlineLearningManager() != null) : "Online learning manager should be initialized";
        assert (framework.getBehaviorAnalyzer() != null) : "Behavior analyzer should be initialized";
        assert (framework.getDataCollectionManager() != null) : "Data collection manager should be initialized";
        ReignOfNether.LOGGER.info("\u2713 Framework initialization test passed");
    }

    private static void testGameSessionManagement() {
        ReignOfNether.LOGGER.info("Testing game session management...");
        MLFramework framework = MLFramework.getInstance();
        List<String> players = Arrays.asList(TEST_PLAYER_NAME);
        List<String> bots = Arrays.asList(TEST_BOT_NAME);
        Map<String, String> params = Map.of("gameMode", "test", "difficulty", "medium");
        framework.startGameSession(TEST_SESSION_ID, players, bots, "test", params);
        Map<String, Boolean> results = Map.of(TEST_PLAYER_NAME, true, TEST_BOT_NAME, false);
        GameMetrics metrics = new GameMetrics(600000L, 100, 0.8, 0.7, 20, 5, 1000, 15, 8);
        framework.endGameSession(TEST_SESSION_ID, results, metrics, "Test completed");
        ReignOfNether.LOGGER.info("\u2713 Game session management test passed");
    }

    private static void testPlayerActionRecording() {
        ReignOfNether.LOGGER.info("Testing player action recording...");
        MLFramework framework = MLFramework.getInstance();
        GameState gameState = MLFrameworkTest.createTestGameState();
        Map<String, Double> actionParams = Map.of("resourceType", 1.0, "priority", 0.8);
        PlayerAction action = new PlayerAction(ActionType.GATHER_RESOURCES, actionParams, null, TEST_PLAYER_NAME);
        PlayerBehaviorAnalyzer.ActionOutcome outcome = new PlayerBehaviorAnalyzer.ActionOutcome(0.9, "Successful resource gathering", 5000L);
        framework.recordPlayerAction(TEST_SESSION_ID, TEST_PLAYER_NAME, gameState, action, outcome);
        PlayerBehaviorAnalyzer.BehaviorAnalysis analysis = framework.getPlayerBehaviorAnalysis(TEST_PLAYER_NAME);
        ReignOfNether.LOGGER.info("\u2713 Player action recording test passed");
    }

    private static void testBotDecisionMaking() {
        ReignOfNether.LOGGER.info("Testing bot decision making...");
        MLFramework framework = MLFramework.getInstance();
        GameState gameState = MLFrameworkTest.createTestGameState();
        MLDecision decision = framework.getStrategicDecision(gameState, TEST_BOT_NAME);
        if (decision != null) {
            assert (decision.getDecisionType() != null) : "Decision should have a type";
            assert (decision.getConfidence() >= 0.0 && decision.getConfidence() <= 1.0) : "Confidence should be between 0 and 1";
            framework.recordBotDecision(TEST_SESSION_ID, TEST_BOT_NAME, gameState, decision, 0.8, "Test decision");
        }
        ReignOfNether.LOGGER.info("\u2713 Bot decision making test passed");
    }

    private static void testOnlineLearning() {
        ReignOfNether.LOGGER.info("Testing online learning...");
        MLFramework framework = MLFramework.getInstance();
        framework.setOnlineLearningEnabled(false);
        framework.setOnlineLearningEnabled(true);
        GameState gameState = MLFrameworkTest.createTestGameState();
        MLDecision decision = new MLDecision(MLDecision.DecisionType.FOCUS_ON_ECONOMY, 0.7);
        framework.recordDecisionOutcome(TEST_BOT_NAME, gameState, decision, 0.8, "Online learning test");
        OnlineLearningManager.OnlineLearningStats stats = framework.getOnlineLearningManager().getStats(TEST_BOT_NAME);
        ReignOfNether.LOGGER.info("\u2713 Online learning test passed");
    }

    private static void testAdaptiveDifficulty() {
        ReignOfNether.LOGGER.info("Testing adaptive difficulty...");
        MLFramework framework = MLFramework.getInstance();
        GameMetrics metrics = new GameMetrics(600000L, 120, 0.75, 0.8, 25, 6, 1200, 18, 10);
        framework.recordGameOutcome(TEST_PLAYER_NAME, TEST_BOT_NAME, true, metrics);
        framework.recordGameOutcome(TEST_PLAYER_NAME, TEST_BOT_NAME, false, metrics);
        AdaptiveDifficultyManager.DifficultyAdjustment adjustment = framework.getDifficultyAdjustment(TEST_PLAYER_NAME, TEST_BOT_NAME);
        if (adjustment != null) {
            assert (adjustment.skillMultiplier > 0.0) : "Skill multiplier should be positive";
            assert (adjustment.aggressionMultiplier > 0.0) : "Aggression multiplier should be positive";
            assert (adjustment.recommendedDifficulty != null) : "Recommended difficulty should not be null";
        }
        ReignOfNether.LOGGER.info("\u2713 Adaptive difficulty test passed");
    }

    private static void testDataCollection() {
        ReignOfNether.LOGGER.info("Testing data collection...");
        MLFramework framework = MLFramework.getInstance();
        framework.setDataCollectionEnabled(false);
        framework.setDataCollectionEnabled(true);
        DataCollectionManager.DataCollectionStatistics stats = framework.getDataCollectionStatistics();
        assert (stats != null) : "Data collection statistics should be available";
        assert (stats.enabled) : "Data collection should be enabled";
        ReignOfNether.LOGGER.info("\u2713 Data collection test passed");
    }

    private static void testTrainingPipeline() {
        ReignOfNether.LOGGER.info("Testing training pipeline...");
        MLFramework framework = MLFramework.getInstance();
        framework.getLearningPipeline().triggerTraining();
        int totalSessions = framework.getLearningPipeline().getTotalTrainingSessions();
        boolean inProgress = framework.getLearningPipeline().isTrainingInProgress();
        long timeSinceLast = framework.getLearningPipeline().getTimeSinceLastTraining();
        assert (totalSessions >= 0) : "Training sessions should be non-negative";
        ReignOfNether.LOGGER.info("\u2713 Training pipeline test passed");
    }

    private static void testPlayerBehaviorAnalysis() {
        ActionType[] actions;
        ReignOfNether.LOGGER.info("Testing player behavior analysis...");
        MLFramework framework = MLFramework.getInstance();
        GameState gameState = MLFrameworkTest.createTestGameState();
        for (ActionType actionType : actions = new ActionType[]{ActionType.GATHER_RESOURCES, ActionType.BUILD_ECONOMIC, ActionType.PRODUCE_WORKERS, ActionType.RESEARCH}) {
            PlayerAction action = new PlayerAction(actionType, Map.of("priority", Math.random()), null, TEST_PLAYER_NAME);
            PlayerBehaviorAnalyzer.ActionOutcome outcome = new PlayerBehaviorAnalyzer.ActionOutcome(0.7 + Math.random() * 0.3, "Test action", 3000L + (long)(Math.random() * 5000.0));
            framework.recordPlayerAction(TEST_SESSION_ID, TEST_PLAYER_NAME, gameState, action, outcome);
        }
        PlayerBehaviorAnalyzer.BehaviorAnalysis analysis = framework.getPlayerBehaviorAnalysis(TEST_PLAYER_NAME);
        ReignOfNether.LOGGER.info("\u2713 Player behavior analysis test passed");
    }

    private static void testPerformanceStatistics() {
        ReignOfNether.LOGGER.info("Testing performance statistics...");
        MLFramework framework = MLFramework.getInstance();
        MLFramework.MLStatistics stats = framework.getStatistics();
        assert (stats != null) : "Statistics should not be null";
        assert (stats.enabled == framework.isReady()) : "Statistics should match framework state";
        String report = framework.getPerformanceStats(TEST_PLAYER_NAME, TEST_BOT_NAME);
        assert (report != null && !report.isEmpty()) : "Performance report should not be empty";
        ReignOfNether.LOGGER.info("\u2713 Performance statistics test passed");
    }

    private static GameState createTestGameState() {
        GameState state = new GameState();
        state.gameTime = 15000L;
        state.gamePhase = GamePhase.MID_GAME;
        state.currentPriority = StrategicPriority.ECONOMY;
        state.selfResources.food = 100;
        state.selfResources.wood = 150;
        state.selfResources.ore = 50;
        state.enemyResourcesEstimate.food = 90;
        state.enemyResourcesEstimate.wood = 120;
        state.enemyResourcesEstimate.ore = 40;
        state.selfUnits.workers = 6;
        state.selfUnits.militaryUnits = 8;
        state.enemyUnitsEstimate.workers = 5;
        state.enemyUnitsEstimate.militaryUnits = 7;
        state.selfBuildings.capitols = 1;
        state.selfBuildings.economicBuildings = 2;
        state.selfBuildings.militaryBuildings = 1;
        state.mapControlPercentage = 30.0;
        state.threatLevel = 4.0;
        state.isInCombat = false;
        state.isUnderAttack = false;
        return state;
    }

    public static void testWithBotIntegration() {
        ReignOfNether.LOGGER.info("Testing ML framework with bot integration...");
        try {
            AIBotPlayer testBot = BotManager.createBot("ML-Test-Bot", Faction.VILLAGERS, BotDifficulty.MEDIUM);
            List<String> players = Arrays.asList(TEST_PLAYER_NAME);
            BotManager.startMLGameSession("bot-integration-test", players, "integration-test");
            AIStrategicController controller = testBot.getStrategicController();
            for (int i = 0; i < 5; ++i) {
                Thread.sleep(100L);
            }
            Map<String, Boolean> results = Map.of(TEST_PLAYER_NAME, true, "ML-Test-Bot", false);
            BotManager.endMLGameSession(results, "Integration test completed");
            BotManager.removeBot(testBot.getId());
            ReignOfNether.LOGGER.info("\u2713 Bot integration test passed");
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Bot integration test failed: {}", (Object)e.getMessage());
        }
    }

    public static boolean quickFunctionalityCheck() {
        try {
            boolean allGood;
            MLFramework framework = MLFramework.getInstance();
            boolean bl = allGood = framework.getVectorizer() != null && framework.getNetworkManager() != null && framework.getDataManager() != null && framework.getLearningPipeline() != null && framework.getDifficultyManager() != null && framework.getOnlineLearningManager() != null && framework.getBehaviorAnalyzer() != null && framework.getDataCollectionManager() != null;
            if (allGood) {
                ReignOfNether.LOGGER.info("\u2713 ML Framework quick functionality check passed");
            } else {
                ReignOfNether.LOGGER.error("\u2717 ML Framework quick functionality check failed - missing components");
            }
            return allGood;
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("\u2717 ML Framework quick functionality check failed: {}", (Object)e.getMessage());
            return false;
        }
    }
}

