/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building;

public class BuildingProperties {
    private final boolean isProductionBuilding;
    private final boolean isGarrisonBuilding;
    private final boolean isDefensiveBuilding;
    private final boolean isResourceBuilding;
    private final boolean isPopulationBuilding;
    private final int maxHealth;
    private final float armorValue;
    private final float explosionResistance;
    private final boolean fireProof;
    private final boolean canBeDestroyed;
    private final int buildTime;
    private final int populationProvided;
    private final int populationRequired;
    private final float resourceProductionRate;
    private final int attackDamage;
    private final int attackRange;
    private final int visionRange;
    private final boolean hasRangedAttack;
    private final int garrisonCapacity;
    private final boolean requiresNether;
    private final boolean requiresWater;
    private final boolean requiresFlat;
    private final boolean canBeBridge;
    private final boolean convertsNether;
    private final boolean providesNightVision;

    private BuildingProperties(Builder builder) {
        this.isProductionBuilding = builder.isProductionBuilding;
        this.isGarrisonBuilding = builder.isGarrisonBuilding;
        this.isDefensiveBuilding = builder.isDefensiveBuilding;
        this.isResourceBuilding = builder.isResourceBuilding;
        this.isPopulationBuilding = builder.isPopulationBuilding;
        this.maxHealth = builder.maxHealth;
        this.armorValue = builder.armorValue;
        this.explosionResistance = builder.explosionResistance;
        this.fireProof = builder.fireProof;
        this.canBeDestroyed = builder.canBeDestroyed;
        this.buildTime = builder.buildTime;
        this.populationProvided = builder.populationProvided;
        this.populationRequired = builder.populationRequired;
        this.resourceProductionRate = builder.resourceProductionRate;
        this.attackDamage = builder.attackDamage;
        this.attackRange = builder.attackRange;
        this.visionRange = builder.visionRange;
        this.hasRangedAttack = builder.hasRangedAttack;
        this.garrisonCapacity = builder.garrisonCapacity;
        this.requiresNether = builder.requiresNether;
        this.requiresWater = builder.requiresWater;
        this.requiresFlat = builder.requiresFlat;
        this.canBeBridge = builder.canBeBridge;
        this.convertsNether = builder.convertsNether;
        this.providesNightVision = builder.providesNightVision;
    }

    public static BuildingProperties defaultProperties() {
        return new Builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isProductionBuilding() {
        return this.isProductionBuilding;
    }

    public boolean isGarrisonBuilding() {
        return this.isGarrisonBuilding;
    }

    public boolean isDefensiveBuilding() {
        return this.isDefensiveBuilding;
    }

    public boolean isResourceBuilding() {
        return this.isResourceBuilding;
    }

    public boolean isPopulationBuilding() {
        return this.isPopulationBuilding;
    }

    public int getMaxHealth() {
        return this.maxHealth;
    }

    public float getArmorValue() {
        return this.armorValue;
    }

    public float getExplosionResistance() {
        return this.explosionResistance;
    }

    public boolean isFireProof() {
        return this.fireProof;
    }

    public boolean canBeDestroyed() {
        return this.canBeDestroyed;
    }

    public int getBuildTime() {
        return this.buildTime;
    }

    public int getPopulationProvided() {
        return this.populationProvided;
    }

    public int getPopulationRequired() {
        return this.populationRequired;
    }

    public float getResourceProductionRate() {
        return this.resourceProductionRate;
    }

    public int getAttackDamage() {
        return this.attackDamage;
    }

    public int getAttackRange() {
        return this.attackRange;
    }

    public int getVisionRange() {
        return this.visionRange;
    }

    public boolean hasRangedAttack() {
        return this.hasRangedAttack;
    }

    public int getGarrisonCapacity() {
        return this.garrisonCapacity;
    }

    public boolean requiresNether() {
        return this.requiresNether;
    }

    public boolean requiresWater() {
        return this.requiresWater;
    }

    public boolean requiresFlat() {
        return this.requiresFlat;
    }

    public boolean canBeBridge() {
        return this.canBeBridge;
    }

    public boolean convertsNether() {
        return this.convertsNether;
    }

    public boolean providesNightVision() {
        return this.providesNightVision;
    }

    public static class Builder {
        private boolean isProductionBuilding = false;
        private boolean isGarrisonBuilding = false;
        private boolean isDefensiveBuilding = false;
        private boolean isResourceBuilding = false;
        private boolean isPopulationBuilding = false;
        private int maxHealth = 100;
        private float armorValue = 0.0f;
        private float explosionResistance = 1.0f;
        private boolean fireProof = false;
        private boolean canBeDestroyed = true;
        private int buildTime = 600;
        private int populationProvided = 0;
        private int populationRequired = 0;
        private float resourceProductionRate = 0.0f;
        private int attackDamage = 0;
        private int attackRange = 0;
        private int visionRange = 16;
        private boolean hasRangedAttack = false;
        private int garrisonCapacity = 0;
        private boolean requiresNether = false;
        private boolean requiresWater = false;
        private boolean requiresFlat = false;
        private boolean canBeBridge = false;
        private boolean convertsNether = false;
        private boolean providesNightVision = false;

        public Builder productionBuilding(boolean isProduction) {
            this.isProductionBuilding = isProduction;
            return this;
        }

        public Builder garrisonBuilding(boolean isGarrison) {
            this.isGarrisonBuilding = isGarrison;
            return this;
        }

        public Builder defensiveBuilding(boolean isDefensive) {
            this.isDefensiveBuilding = isDefensive;
            return this;
        }

        public Builder resourceBuilding(boolean isResource) {
            this.isResourceBuilding = isResource;
            return this;
        }

        public Builder populationBuilding(boolean isPopulation) {
            this.isPopulationBuilding = isPopulation;
            return this;
        }

        public Builder maxHealth(int health) {
            this.maxHealth = health;
            return this;
        }

        public Builder armorValue(float armor) {
            this.armorValue = armor;
            return this;
        }

        public Builder explosionResistance(float resistance) {
            this.explosionResistance = resistance;
            return this;
        }

        public Builder fireProof(boolean fireProof) {
            this.fireProof = fireProof;
            return this;
        }

        public Builder canBeDestroyed(boolean canDestroy) {
            this.canBeDestroyed = canDestroy;
            return this;
        }

        public Builder buildTime(int ticks) {
            this.buildTime = ticks;
            return this;
        }

        public Builder populationProvided(int provided) {
            this.populationProvided = provided;
            return this;
        }

        public Builder populationRequired(int required) {
            this.populationRequired = required;
            return this;
        }

        public Builder resourceProductionRate(float rate) {
            this.resourceProductionRate = rate;
            return this;
        }

        public Builder attackDamage(int damage) {
            this.attackDamage = damage;
            return this;
        }

        public Builder attackRange(int range) {
            this.attackRange = range;
            return this;
        }

        public Builder visionRange(int range) {
            this.visionRange = range;
            return this;
        }

        public Builder hasRangedAttack(boolean hasRanged) {
            this.hasRangedAttack = hasRanged;
            return this;
        }

        public Builder garrisonCapacity(int capacity) {
            this.garrisonCapacity = capacity;
            return this;
        }

        public Builder requiresNether(boolean requires) {
            this.requiresNether = requires;
            return this;
        }

        public Builder requiresWater(boolean requires) {
            this.requiresWater = requires;
            return this;
        }

        public Builder requiresFlat(boolean requires) {
            this.requiresFlat = requires;
            return this;
        }

        public Builder canBeBridge(boolean canBridge) {
            this.canBeBridge = canBridge;
            return this;
        }

        public Builder convertsNether(boolean converts) {
            this.convertsNether = converts;
            return this;
        }

        public Builder providesNightVision(boolean provides) {
            this.providesNightVision = provides;
            return this;
        }

        public BuildingProperties build() {
            return new BuildingProperties(this);
        }
    }
}

