/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingProperties;
import com.solegendary.reignofnether.building.BuildingType;
import com.solegendary.reignofnether.faction.FactionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.Event;

public class BuildingRegistry {
    private static final Map<ResourceLocation, BuildingType<?>> BUILDINGS = new ConcurrentHashMap();
    private static final Map<Class<?>, BuildingType<?>> BUILDINGS_BY_CLASS = new ConcurrentHashMap();
    private static final Map<ResourceLocation, List<BuildingType<?>>> BUILDINGS_BY_FACTION = new ConcurrentHashMap();
    private static final List<BuildingType<?>> BUILDING_LIST = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized <T extends Building> BuildingType<T> register(BuildingType<T> buildingType) {
        if (buildingType == null) {
            throw new IllegalArgumentException("BuildingType cannot be null");
        }
        ResourceLocation id = buildingType.getId();
        if (BUILDINGS.containsKey(id)) {
            ReignOfNether.LOGGER.warn("Building {} is already registered, skipping duplicate registration", (Object)id);
            return BUILDINGS.get(id);
        }
        BUILDINGS.put(id, buildingType);
        BUILDINGS_BY_CLASS.put(buildingType.getBuildingClass(), buildingType);
        if (buildingType.getFaction() != null) {
            BUILDINGS_BY_FACTION.computeIfAbsent(buildingType.getFaction().getId(), k -> new ArrayList()).add(buildingType);
        }
        List<BuildingType<?>> list = BUILDING_LIST;
        synchronized (list) {
            BUILDING_LIST.add(buildingType);
        }
        ReignOfNether.LOGGER.info("Registered building: {} ({}) for faction {}", (Object)buildingType.getDisplayName(), (Object)id, (Object)(buildingType.getFaction() != null ? buildingType.getFaction().getDisplayName() : "None"));
        return buildingType;
    }

    public static BuildingType<?> getBuildingType(ResourceLocation id) {
        return BUILDINGS.get(id);
    }

    public static <T extends Building> BuildingType<T> getBuildingType(T building) {
        if (building == null) {
            return null;
        }
        BuildingType<?> buildingType = BUILDINGS_BY_CLASS.get(building.getClass());
        if (buildingType != null) {
            return buildingType;
        }
        for (Map.Entry<Class<?>, BuildingType<?>> entry : BUILDINGS_BY_CLASS.entrySet()) {
            if (!entry.getKey().isInstance(building)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static <T extends Building> BuildingType<T> getBuildingType(Class<T> buildingClass) {
        return BUILDINGS_BY_CLASS.get(buildingClass);
    }

    public static List<BuildingType<?>> getBuildingsForFaction(FactionType faction) {
        if (faction == null) {
            return new ArrayList();
        }
        return new ArrayList(BUILDINGS_BY_FACTION.getOrDefault(faction.getId(), Collections.emptyList()));
    }

    public static List<BuildingType<?>> getBuildingsForFaction(ResourceLocation factionId) {
        return new ArrayList(BUILDINGS_BY_FACTION.getOrDefault(factionId, Collections.emptyList()));
    }

    public static List<BuildingType<?>> getAllBuildings() {
        return new ArrayList(BUILDING_LIST);
    }

    public static Set<ResourceLocation> getAllBuildingIds() {
        return new HashSet<ResourceLocation>(BUILDINGS.keySet());
    }

    public static List<BuildingType<?>> getProductionBuildings() {
        return BUILDING_LIST.stream().filter(building -> building.getProperties().isProductionBuilding()).collect(Collectors.toList());
    }

    public static List<BuildingType<?>> getDefensiveBuildings() {
        return BUILDING_LIST.stream().filter(building -> building.getProperties().isDefensiveBuilding()).collect(Collectors.toList());
    }

    public static List<BuildingType<?>> getResourceBuildings() {
        return BUILDING_LIST.stream().filter(building -> building.getProperties().isResourceBuilding()).collect(Collectors.toList());
    }

    public static List<BuildingType<?>> getPopulationBuildings() {
        return BUILDING_LIST.stream().filter(building -> building.getProperties().isPopulationBuilding()).collect(Collectors.toList());
    }

    public static List<BuildingType<?>> getGarrisonBuildings() {
        return BUILDING_LIST.stream().filter(building -> building.getProperties().isGarrisonBuilding()).collect(Collectors.toList());
    }

    public static boolean isRegistered(ResourceLocation id) {
        return BUILDINGS.containsKey(id);
    }

    public static boolean isRegistered(Class<?> buildingClass) {
        return BUILDINGS_BY_CLASS.containsKey(buildingClass);
    }

    public static FactionType getFactionForBuilding(Building building) {
        BuildingType<Building> buildingType = BuildingRegistry.getBuildingType(building);
        return buildingType != null ? buildingType.getFaction() : null;
    }

    public static List<BuildingType<?>> getBuildingsWithProperties(FactionType faction, boolean production, boolean defensive, boolean resource, boolean population) {
        List<BuildingType<?>> factionBuildings = BuildingRegistry.getBuildingsForFaction(faction);
        return factionBuildings.stream().filter(building -> {
            BuildingProperties props = building.getProperties();
            return !(production && !props.isProductionBuilding() || defensive && !props.isDefensiveBuilding() || resource && !props.isResourceBuilding() || population && !props.isPopulationBuilding());
        }).collect(Collectors.toList());
    }

    public static synchronized void clear() {
        BUILDINGS.clear();
        BUILDINGS_BY_CLASS.clear();
        BUILDINGS_BY_FACTION.clear();
        BUILDING_LIST.clear();
    }

    public static class BuildingRegistrationEvent
    extends Event {
        public <T extends Building> BuildingType<T> registerBuilding(BuildingType<T> buildingType) {
            return BuildingRegistry.register(buildingType);
        }
    }
}

