/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.alliance.AlliancesServerEvents;
import com.solegendary.reignofnether.api.ReignOfNetherRegistries;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingAction;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingClientboundPacket;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.buildings.piglins.PortalCivilian;
import com.solegendary.reignofnether.building.buildings.placements.PortalPlacement;
import com.solegendary.reignofnether.building.buildings.placements.ProductionPlacement;
import com.solegendary.reignofnether.building.buildings.placements.StockpilePlacement;
import com.solegendary.reignofnether.building.production.ProductionItem;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.sandbox.SandboxServer;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Rotation;
import net.minecraftforge.network.NetworkEvent;

public class BuildingServerboundPacket {
    public String itemName;
    public BlockPos buildingPos;
    public BlockPos rallyPos;
    public Rotation rotation;
    public String ownerName;
    public int[] builderUnitIds;
    public BuildingAction action;
    public Boolean isDiagonalBridge;
    private static final List<BuildingAction> newBuildingAuthActions = List.of(BuildingAction.PLACE, BuildingAction.PLACE_AND_QUEUE);
    private static final List<BuildingAction> existingBuildingAuthActions = List.of(BuildingAction.DESTROY, BuildingAction.SET_RALLY_POINT, BuildingAction.SET_RALLY_POINT_ENTITY, BuildingAction.START_PRODUCTION, BuildingAction.CANCEL_PRODUCTION, BuildingAction.CANCEL_BACK_PRODUCTION, BuildingAction.CHANGE_PORTAL);

    public static void placeBuilding(Building building, BlockPos originPos, Rotation rotation, String ownerName, int[] builderUnitIds, boolean isDiagonalBridge) {
        PacketHandler.INSTANCE.sendToServer((Object)new BuildingServerboundPacket(BuildingAction.PLACE, ReignOfNetherRegistries.BUILDING.m_7981_((Object)building).toString(), originPos, BlockPos.f_121853_, rotation, ownerName, builderUnitIds, isDiagonalBridge));
    }

    public static void placeAndQueueBuilding(Building building, BlockPos originPos, Rotation rotation, String ownerName, int[] builderUnitIds, boolean isDiagonalBridge) {
        PacketHandler.INSTANCE.sendToServer((Object)new BuildingServerboundPacket(BuildingAction.PLACE_AND_QUEUE, ReignOfNetherRegistries.BUILDING.m_7981_((Object)building).toString(), originPos, BlockPos.f_121853_, rotation, ownerName, builderUnitIds, isDiagonalBridge));
    }

    public static void cancelBuilding(BlockPos buildingPos, String ownerName) {
        PacketHandler.INSTANCE.sendToServer((Object)new BuildingServerboundPacket(BuildingAction.DESTROY, "", buildingPos, BlockPos.f_121853_, Rotation.NONE, ownerName, new int[0], false));
    }

    public static void setRallyPoint(BlockPos buildingPos, BlockPos rallyPos) {
        PacketHandler.INSTANCE.sendToServer((Object)new BuildingServerboundPacket(BuildingAction.SET_RALLY_POINT, "", buildingPos, rallyPos, Rotation.NONE, "", new int[0], false));
    }

    public static void setRallyPointEntity(BlockPos buildingPos, int entityId) {
        PacketHandler.INSTANCE.sendToServer((Object)new BuildingServerboundPacket(BuildingAction.SET_RALLY_POINT_ENTITY, "", buildingPos, BlockPos.f_121853_, Rotation.NONE, "", new int[]{entityId}, false));
    }

    public static void startProduction(BlockPos buildingPos, ProductionItem item) {
        BuildingClientEvents.switchHudToIdlestBuilding();
        if (HudClientEvents.hudSelectedPlacement != null) {
            PacketHandler.INSTANCE.sendToServer((Object)new BuildingServerboundPacket(BuildingAction.START_PRODUCTION, ReignOfNetherRegistries.PRODUCTION_ITEM.m_7981_((Object)item).toString(), HudClientEvents.hudSelectedPlacement.originPos, BlockPos.f_121853_, Rotation.NONE, "", new int[0], false));
        }
    }

    public static void cancelProduction(BlockPos buildingPos, ProductionItem item, boolean frontItem) {
        PacketHandler.INSTANCE.sendToServer((Object)new BuildingServerboundPacket(frontItem ? BuildingAction.CANCEL_PRODUCTION : BuildingAction.CANCEL_BACK_PRODUCTION, ReignOfNetherRegistries.PRODUCTION_ITEM.m_7981_((Object)item).toString(), buildingPos, BlockPos.f_121853_, Rotation.NONE, "", new int[0], false));
    }

    public static void checkStockpileChests(BlockPos chestPos) {
        PacketHandler.INSTANCE.sendToServer((Object)new BuildingServerboundPacket(BuildingAction.CHECK_STOCKPILE_CHEST, "", chestPos, BlockPos.f_121853_, Rotation.NONE, "", new int[0], false));
    }

    public static void requestReplacement(BlockPos buildingPos) {
        PacketHandler.INSTANCE.sendToServer((Object)new BuildingServerboundPacket(BuildingAction.REQUEST_REPLACEMENT, "", buildingPos, BlockPos.f_121853_, Rotation.NONE, "", new int[0], false));
    }

    public BuildingServerboundPacket(BuildingAction action, String itemName, BlockPos buildingPos, BlockPos rallyPos, Rotation rotation, String ownerName, int[] builderUnitIds, boolean isDiagonalBridge) {
        this.action = action;
        this.itemName = itemName;
        this.buildingPos = buildingPos;
        this.rallyPos = rallyPos;
        this.rotation = rotation;
        this.ownerName = ownerName;
        this.builderUnitIds = builderUnitIds;
        this.isDiagonalBridge = isDiagonalBridge;
    }

    public BuildingServerboundPacket(FriendlyByteBuf buffer) {
        this.action = (BuildingAction)buffer.m_130066_(BuildingAction.class);
        this.itemName = buffer.m_130277_();
        this.buildingPos = buffer.m_130135_();
        this.rallyPos = buffer.m_130135_();
        this.rotation = (Rotation)buffer.m_130066_(Rotation.class);
        this.ownerName = buffer.m_130277_();
        this.builderUnitIds = buffer.m_130100_();
        this.isDiagonalBridge = buffer.readBoolean();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.action);
        buffer.m_130070_(this.itemName);
        buffer.m_130064_(this.buildingPos);
        buffer.m_130064_(this.rallyPos);
        buffer.m_130068_((Enum)this.rotation);
        buffer.m_130070_(this.ownerName);
        buffer.m_130089_(this.builderUnitIds);
        buffer.writeBoolean(this.isDiagonalBridge.booleanValue());
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> {
            BuildingPlacement building = null;
            if (!List.of(BuildingAction.PLACE, BuildingAction.PLACE_AND_QUEUE).contains((Object)this.action) && (building = BuildingUtils.findBuilding(false, this.buildingPos)) == null) {
                return;
            }
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                ReignOfNether.LOGGER.warn("Sender for unit action packet was null");
                success.set(false);
                return;
            }
            if ((newBuildingAuthActions.contains((Object)this.action) && !player.m_7755_().getString().equals(this.ownerName) || existingBuildingAuthActions.contains((Object)this.action) && building != null && !player.m_7755_().getString().equals(building.ownerName)) && !SandboxServer.isAnyoneASandboxPlayer() && !AlliancesServerEvents.canControlAlly(player.m_7755_().getString(), this.ownerName)) {
                ReignOfNether.LOGGER.warn("BuildingServerboundPacket: Tried to process packet from " + player.m_7755_() + " for " + this.ownerName);
                success.set(false);
                return;
            }
            switch (this.action) {
                case PLACE: {
                    BuildingServerEvents.placeBuilding((Building)ReignOfNetherRegistries.BUILDING.m_7745_(ResourceLocation.m_135820_((String)this.itemName)), this.buildingPos, this.rotation, this.ownerName, this.builderUnitIds, false, this.isDiagonalBridge);
                    break;
                }
                case PLACE_AND_QUEUE: {
                    BuildingServerEvents.placeBuilding((Building)ReignOfNetherRegistries.BUILDING.m_7745_(ResourceLocation.m_135820_((String)this.itemName)), this.buildingPos, this.rotation, this.ownerName, this.builderUnitIds, true, this.isDiagonalBridge);
                    break;
                }
                case DESTROY: {
                    BuildingServerEvents.cancelBuilding(building, this.ownerName);
                    break;
                }
                case SET_RALLY_POINT: {
                    if (!(building instanceof ProductionPlacement)) break;
                    ProductionPlacement productionBuilding = (ProductionPlacement)building;
                    productionBuilding.setRallyPoint(this.rallyPos);
                    break;
                }
                case SET_RALLY_POINT_ENTITY: {
                    if (!(building instanceof ProductionPlacement)) break;
                    ProductionPlacement productionBuilding = (ProductionPlacement)building;
                    Entity e = building.level.m_6815_(this.builderUnitIds[0]);
                    if (!(e instanceof LivingEntity)) break;
                    LivingEntity le = (LivingEntity)e;
                    productionBuilding.setRallyPointEntity(le);
                    break;
                }
                case START_PRODUCTION: {
                    boolean prodSuccess = ((ProductionPlacement)building).startProductionItem((ProductionItem)ReignOfNetherRegistries.PRODUCTION_ITEM.m_7745_(ResourceLocation.m_135820_((String)this.itemName)), this.buildingPos);
                    if (!prodSuccess) break;
                    BuildingClientboundPacket.startProduction(this.buildingPos, (ProductionItem)ReignOfNetherRegistries.PRODUCTION_ITEM.m_7745_(ResourceLocation.m_135820_((String)this.itemName)));
                    break;
                }
                case CANCEL_PRODUCTION: {
                    ProductionPlacement pBuilding;
                    boolean cancelSuccess;
                    if (!(building instanceof ProductionPlacement) || !(cancelSuccess = (pBuilding = (ProductionPlacement)building).cancelProductionItem((ProductionItem)ReignOfNetherRegistries.PRODUCTION_ITEM.m_7745_(ResourceLocation.m_135820_((String)this.itemName)), this.buildingPos, true)) && !pBuilding.productionQueue.isEmpty()) break;
                    BuildingClientboundPacket.cancelProduction(this.buildingPos, (ProductionItem)ReignOfNetherRegistries.PRODUCTION_ITEM.m_7745_(ResourceLocation.m_135820_((String)this.itemName)), true);
                    break;
                }
                case CANCEL_BACK_PRODUCTION: {
                    ProductionPlacement pBuilding;
                    boolean cancelSuccess;
                    if (!(building instanceof ProductionPlacement) || !(cancelSuccess = (pBuilding = (ProductionPlacement)building).cancelProductionItem((ProductionItem)ReignOfNetherRegistries.PRODUCTION_ITEM.m_7745_(ResourceLocation.m_135820_((String)this.itemName)), this.buildingPos, false)) && !pBuilding.productionQueue.isEmpty()) break;
                    BuildingClientboundPacket.cancelProduction(this.buildingPos, (ProductionItem)ReignOfNetherRegistries.PRODUCTION_ITEM.m_7745_(ResourceLocation.m_135820_((String)this.itemName)), false);
                    break;
                }
                case CHECK_STOCKPILE_CHEST: {
                    PortalPlacement portal;
                    if (building instanceof StockpilePlacement) {
                        StockpilePlacement stockpile = (StockpilePlacement)building;
                        stockpile.checkAndConsumeChestItems();
                        break;
                    }
                    if (!(building instanceof PortalPlacement) || !((portal = (PortalPlacement)building).getBuilding() instanceof PortalCivilian)) break;
                    portal.checkAndConsumeChestItems();
                    break;
                }
                case REQUEST_REPLACEMENT: {
                    BuildingServerEvents.replaceClientBuilding(this.buildingPos);
                }
            }
            success.set(true);
        });
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

