/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building;

import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.nether.NetherBlocks;
import com.solegendary.reignofnether.restoration.OreRestorationData;
import com.solegendary.reignofnether.restoration.OreRestorationManager;
import com.solegendary.reignofnether.restoration.OreRestorationSaveData;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class NetherZone {
    private final int MAX_TICKS = 5;
    private final int MAX_CONVERTS_AFTER_CONSTANT_RANGE = 60;
    private final BlockPos origin;
    private final Random random = new Random();
    private boolean isRestoring = false;
    private final double maxRange;
    private double range;
    private int ticksLeft = 5;
    private int convertsAfterConstantRange = 0;

    public BlockPos getOrigin() {
        return this.origin;
    }

    public double getRange() {
        return this.range;
    }

    public double getMaxRange() {
        return this.maxRange;
    }

    public boolean isRestoring() {
        return this.isRestoring;
    }

    public int getTicksLeft() {
        return this.ticksLeft;
    }

    public int getConvertsAfterConstantRange() {
        return this.convertsAfterConstantRange;
    }

    public NetherZone(BlockPos origin, double maxRange, double range) {
        this.origin = origin;
        this.maxRange = maxRange;
        this.range = range;
    }

    private NetherZone(BlockPos origin, double maxRange, double range, boolean isRestoring, int ticksLeft, int convertsAfterConstantRange) {
        this.origin = origin;
        this.maxRange = maxRange;
        this.range = range;
        this.isRestoring = isRestoring;
        this.ticksLeft = ticksLeft;
        this.convertsAfterConstantRange = convertsAfterConstantRange;
    }

    public static NetherZone getFromSave(BlockPos origin, double maxRange, double range, boolean isRestoring, int ticksLeft, int convertsAfterConstantRange) {
        return new NetherZone(origin, maxRange, range, isRestoring, ticksLeft, convertsAfterConstantRange);
    }

    public void startRestoring() {
        this.convertsAfterConstantRange = 0;
        this.isRestoring = true;
    }

    public boolean isDone() {
        return this.isRestoring && this.convertsAfterConstantRange >= 60;
    }

    public void tick(ServerLevel level) {
        if (!level.m_5776_()) {
            --this.ticksLeft;
            if (this.ticksLeft <= 0 && this.convertsAfterConstantRange < 60) {
                if (!this.isRestoring) {
                    this.netherConvertTick(level);
                    if (this.range < this.maxRange) {
                        this.range += (double)0.1f;
                    } else {
                        ++this.convertsAfterConstantRange;
                    }
                } else {
                    this.overworldRestoreTick(level);
                    if (this.range > 0.0) {
                        this.range -= (double)0.05f;
                    } else {
                        ++this.convertsAfterConstantRange;
                    }
                }
                this.ticksLeft = 5;
            }
        }
    }

    private boolean isBlockInBuilding(ServerLevel level, BlockPos bp) {
        FluidState fs = level.m_8055_(bp).m_60819_();
        boolean isBuilding = !fs.m_76178_() && !fs.m_76170_() ? BuildingUtils.isPosInsideAnyBuilding(level.m_5776_(), bp) : BuildingUtils.isPosPartOfAnyBuilding(level.m_5776_(), bp, true, (int)(this.maxRange * 2.0));
        return isBuilding;
    }

    private void overworldRestoreTick(ServerLevel level) {
        double restoreRange = this.range + 5.0;
        ArrayList<BlockPos> bps = new ArrayList<BlockPos>();
        for (double x = -restoreRange; x < restoreRange; x += 1.0) {
            for (double y = -restoreRange / 2.0; y < restoreRange / 2.0; y += 1.0) {
                for (double z = -restoreRange; z < restoreRange; z += 1.0) {
                    bps.add(this.origin.m_7918_((int)x, (int)y, (int)z));
                }
            }
        }
        block3: for (BlockPos bp : bps) {
            double distSqr = bp.m_123331_((Vec3i)this.origin);
            double rangeSqr = this.range * this.range;
            double rangeMaxSqr = this.maxRange * this.maxRange;
            if (distSqr < rangeSqr) continue;
            double chance = 0.1f;
            if (this.random.nextDouble() > chance) continue;
            for (NetherZone ncz : BuildingServerEvents.netherZones) {
                if (ncz.isRestoring || !(bp.m_123331_((Vec3i)ncz.origin) < ncz.maxRange * ncz.maxRange)) continue;
                continue block3;
            }
            BlockState bs = NetherBlocks.getOverworldBlock((Level)level, bp);
            BlockState bsPlant = NetherBlocks.getOverworldPlantBlock((Level)level, bp.m_7494_(), true);
            if (bs == null || this.isBlockInBuilding(level, bp)) continue;
            OreRestorationSaveData saveData = OreRestorationSaveData.get(level);
            OreRestorationData.OreRecord oreRecord = saveData.getOreData().findOreRecord(bp, "nether_converted");
            if (oreRecord != null) {
                level.m_46597_(bp, oreRecord.originalBlockState);
                OreRestorationManager.removeOreRecord(level, bp, "nether_converted");
            } else {
                level.m_46597_(bp, bs);
            }
            if (bsPlant == null) continue;
            level.m_46597_(bp.m_7494_(), bsPlant);
        }
    }

    private void netherConvertTick(ServerLevel level) {
        ArrayList<BlockPos> bps = new ArrayList<BlockPos>();
        for (double x = -this.range; x < this.range; x += 1.0) {
            for (double y = -this.range / 2.0; y < this.range / 2.0; y += 1.0) {
                for (double z = -this.range; z < this.range; z += 1.0) {
                    bps.add(this.origin.m_7918_((int)x, (int)y, (int)z));
                }
            }
        }
        for (BlockPos bp : bps) {
            double distSqr = bp.m_123331_((Vec3i)this.origin);
            double rangeSqr = this.range * this.range;
            double rangeMaxSqr = this.maxRange * this.maxRange;
            if (distSqr > rangeSqr) continue;
            double chance = (1.0 - distSqr / rangeMaxSqr) / 10.0;
            if (level.m_8055_(bp).m_60734_() == Blocks.f_49990_ || level.m_8055_(bp).m_60734_() == Blocks.f_50628_) {
                int adjObs = 0;
                if (level.m_8055_(bp.m_122012_()).m_60734_() == Blocks.f_50080_) {
                    ++adjObs;
                }
                if (level.m_8055_(bp.m_122019_()).m_60734_() == Blocks.f_50080_) {
                    ++adjObs;
                }
                if (level.m_8055_(bp.m_122029_()).m_60734_() == Blocks.f_50080_) {
                    ++adjObs;
                }
                if (level.m_8055_(bp.m_122024_()).m_60734_() == Blocks.f_50080_) {
                    ++adjObs;
                }
                if (adjObs >= 3) {
                    chance = 1.0;
                }
            }
            if (this.random.nextDouble() > chance) continue;
            BlockState bs = NetherBlocks.getNetherBlock((Level)level, bp);
            BlockState bsPlant = NetherBlocks.getNetherPlantBlock((Level)level, bp.m_7494_());
            if (bs == null || this.isBlockInBuilding(level, bp)) continue;
            BlockState currentBlockState = level.m_8055_(bp);
            if (OreRestorationManager.isTrackableOre(currentBlockState)) {
                OreRestorationManager.trackNetherConvertedOre(level, bp, currentBlockState);
            }
            if (bsPlant != null) {
                level.m_46961_(bp.m_7494_(), false);
                level.m_46597_(bp.m_7494_(), bsPlant);
            }
            level.m_46597_(bp, bs);
        }
    }
}

