/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.monsters;

import com.solegendary.reignofnether.api.ReignOfNetherRegistries;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.Buildings;
import com.solegendary.reignofnether.building.buildings.placements.DungeonPlacement;
import com.solegendary.reignofnether.building.production.ProductionBuilding;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.util.Faction;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;

public class Dungeon
extends ProductionBuilding {
    public static final String buildingName = "Dungeon";
    public static final String structureName = "dungeon";
    public static final ResourceCost cost = ResourceCosts.DUNGEON;

    public Dungeon() {
        super(structureName, cost, false);
        this.name = buildingName;
        this.portraitBlock = Blocks.f_50085_;
        this.icon = new ResourceLocation("minecraft", "textures/block/spawner.png");
        this.startingBlockTypes.add(Blocks.f_152590_);
        this.explodeChance = 0.2f;
        this.productions.add(ProductionItems.CREEPER, Keybindings.keyQ);
    }

    @Override
    public Faction getFaction() {
        return Faction.MONSTERS;
    }

    @Override
    public BuildingPlacement createBuildingPlacement(Level level, BlockPos pos, Rotation rotation, String ownerName) {
        return new DungeonPlacement(this, level, pos, rotation, ownerName, BuildingUtils.getAbsoluteBlockData(this.getRelativeBlockData((LevelAccessor)level), (LevelAccessor)level, pos, rotation), false);
    }

    @Override
    public AbilityButton getBuildButton(Keybinding hotkey) {
        ResourceLocation key = ReignOfNetherRegistries.BUILDING.m_7981_((Object)this);
        String name = I18n.m_118938_((String)("buildings." + this.getFaction().name().toLowerCase() + "." + key.m_135827_() + "." + key.m_135815_()), (Object[])new Object[0]);
        return new AbilityButton(name, new ResourceLocation("minecraft", "textures/block/spawner.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == Buildings.DUNGEON, () -> false, () -> BuildingClientEvents.hasFinishedBuilding(Buildings.GRAVEYARD) || ResearchClient.hasCheat("modifythephasevariance"), () -> BuildingClientEvents.setBuildingToPlace(Buildings.DUNGEON), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.dungeon", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.dungeon.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.dungeon.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_)), null);
    }

    @Override
    public BlockPos getIndoorSpawnPoint(ServerLevel level, BlockPos centerPos) {
        return super.getIndoorSpawnPoint(level, centerPos).m_7918_(-1, 0, 0);
    }
}

