/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.piglins;

import com.solegendary.reignofnether.api.ReignOfNetherRegistries;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.Buildings;
import com.solegendary.reignofnether.building.production.ProductionBuilding;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.util.Faction;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.block.Blocks;

public class WitherShrine
extends ProductionBuilding {
    public static final String buildingName = "Wither Shrine";
    public static final String structureName = "wither_shrine";
    public static final ResourceCost cost = ResourceCosts.WITHER_SHRINE;

    public WitherShrine() {
        super(structureName, cost, false);
        this.name = buildingName;
        this.portraitBlock = Blocks.f_50706_;
        this.icon = new ResourceLocation("minecraft", "textures/block/gilded_blackstone.png");
        this.canSetRallyPoint = false;
        this.startingBlockTypes.add(Blocks.f_50707_);
        this.explodeChance = 0.2f;
        this.productions.add(ProductionItems.RESEARCH_WITHER_CLOUDS, Keybindings.keyQ);
    }

    @Override
    public Faction getFaction() {
        return Faction.PIGLINS;
    }

    @Override
    public AbilityButton getBuildButton(Keybinding hotkey) {
        ResourceLocation key = ReignOfNetherRegistries.BUILDING.m_7981_((Object)this);
        String name = I18n.m_118938_((String)("buildings." + this.getFaction().name().toLowerCase() + "." + key.m_135827_() + "." + key.m_135815_()), (Object[])new Object[0]);
        return new AbilityButton(name, new ResourceLocation("minecraft", "textures/block/gilded_blackstone.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == Buildings.WITHER_SHRINE, () -> false, () -> BuildingClientEvents.hasFinishedBuilding(Buildings.BASTION) || ResearchClient.hasCheat("modifythephasevariance"), () -> BuildingClientEvents.setBuildingToPlace(Buildings.WITHER_SHRINE), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.piglins.reignofnether.wither_shrine", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.piglins.reignofnether.wither_shrine.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.piglins.reignofnether.wither_shrine.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.piglins.reignofnether.wither_shrine.tooltip3", (Object[])new Object[0]), (Style)Style.f_131099_)), null);
    }
}

