/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.placements;

import com.solegendary.reignofnether.ability.abilities.PromoteIllager;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.GarrisonableBuilding;
import com.solegendary.reignofnether.building.buildings.placements.ProductionPlacement;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;

public class CastlePlacement
extends ProductionPlacement
implements GarrisonableBuilding {
    public static final int MAX_OCCUPANTS = 7;

    public CastlePlacement(Building building, Level level, BlockPos originPos, Rotation rotation, String ownerName, ArrayList<BuildingBlock> blocks, boolean isCapitol) {
        super(building, level, originPos, rotation, ownerName, blocks, isCapitol);
        PromoteIllager promoteIllager = new PromoteIllager(this);
        this.abilities.add(promoteIllager);
    }

    @Override
    public int getAttackRange() {
        return 30;
    }

    @Override
    public int getExternalAttackRangeBonus() {
        return 15;
    }

    @Override
    public boolean canDestroyBlock(BlockPos relativeBp) {
        return relativeBp.m_123342_() != 15 && relativeBp.m_123342_() != 17;
    }

    @Override
    public BlockPos getEntryPosition() {
        if (this.rotation == Rotation.NONE) {
            return new BlockPos(5, 16, 5);
        }
        if (this.rotation == Rotation.CLOCKWISE_90) {
            return new BlockPos(-5, 16, 5);
        }
        if (this.rotation == Rotation.CLOCKWISE_180) {
            return new BlockPos(-5, 16, -5);
        }
        return new BlockPos(5, 16, -5);
    }

    @Override
    public BlockPos getExitPosition() {
        if (this.rotation == Rotation.NONE) {
            return new BlockPos(5, 2, 5);
        }
        if (this.rotation == Rotation.CLOCKWISE_90) {
            return new BlockPos(-5, 2, 5);
        }
        if (this.rotation == Rotation.CLOCKWISE_180) {
            return new BlockPos(-5, 2, -5);
        }
        return new BlockPos(5, 2, -5);
    }

    @Override
    public boolean isFull() {
        return GarrisonableBuilding.getNumOccupants(this) >= 7;
    }

    @Override
    public BlockPos getIndoorSpawnPoint(ServerLevel level) {
        return this.originPos.m_121955_((Vec3i)this.getExitPosition());
    }
}

