/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.placements;

import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.Buildings;
import com.solegendary.reignofnether.building.NetherConvertingBuilding;
import com.solegendary.reignofnether.building.NetherZone;
import com.solegendary.reignofnether.building.buildings.piglins.PortalCivilian;
import com.solegendary.reignofnether.building.buildings.piglins.PortalMilitary;
import com.solegendary.reignofnether.building.buildings.piglins.PortalTransport;
import com.solegendary.reignofnether.building.buildings.placements.ProductionPlacement;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.resources.ResourceName;
import com.solegendary.reignofnether.resources.ResourceSource;
import com.solegendary.reignofnether.resources.ResourceSources;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.resources.ResourcesClientboundPacket;
import com.solegendary.reignofnether.resources.ResourcesServerEvents;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;

public class PortalPlacement
extends ProductionPlacement
implements NetherConvertingBuilding {
    public static final float NON_NETHER_BUILD_TIME_MODIFIER = 2.0f;
    public BlockPos destination;
    public NetherZone netherConversionZone = null;

    public PortalPlacement(Building building, Level level, BlockPos originPos, Rotation rotation, String ownerName, ArrayList<BuildingBlock> blocks, boolean isCapitol) {
        super(building, level, originPos, rotation, ownerName, blocks, isCapitol);
    }

    public PortalType getPortalType() {
        if (this.getBuilding() instanceof PortalCivilian) {
            return PortalType.CIVILIAN;
        }
        if (this.getBuilding() instanceof PortalMilitary) {
            return PortalType.MILITARY;
        }
        if (this.getBuilding() instanceof PortalTransport) {
            return PortalType.TRANSPORT;
        }
        return PortalType.BASIC;
    }

    @Override
    public void tick(Level tickLevel) {
        super.tick(tickLevel);
        if (!this.getLevel().m_5776_() && this.getBlocksPlaced() >= this.getBlocksTotal() && this.getLevel().m_8055_(this.centrePos).m_60795_()) {
            this.getLevel().m_46597_(this.centrePos, Blocks.f_50083_.m_49966_());
        }
    }

    @Override
    public boolean shouldBeDestroyed() {
        boolean shouldBeDestroyed = super.shouldBeDestroyed();
        if (shouldBeDestroyed) {
            this.disconnectPortal();
        }
        return shouldBeDestroyed;
    }

    @Override
    public void destroy(ServerLevel serverLevel) {
        this.disconnectPortal();
        super.destroy(serverLevel);
    }

    @Override
    public void setNetherZone(NetherZone nz) {
        if (this.netherConversionZone == null) {
            this.netherConversionZone = nz;
            if (!this.level.m_5776_()) {
                BuildingServerEvents.netherZones.add(this.netherConversionZone);
                BuildingServerEvents.saveNetherZones((ServerLevel)this.level);
            }
        }
    }

    @Override
    public void onBuilt() {
        super.onBuilt();
        this.setNetherZone(new NetherZone(this.centrePos.m_7918_(0, -2, 0), this.getMaxRange(), this.getStartingRange()));
    }

    public void disconnectPortal() {
        BuildingPlacement targetBuilding;
        if (this.destination != null && (targetBuilding = BuildingUtils.findBuilding(this.getLevel().m_5776_(), this.destination)) instanceof PortalPlacement) {
            PortalPlacement targetPortal = (PortalPlacement)targetBuilding;
            if (this.getBuilding() instanceof PortalTransport) {
                targetPortal.destination = null;
            }
        }
        this.destination = null;
    }

    @Override
    public boolean canDestroyBlock(BlockPos relativeBp) {
        BlockPos worldBp = relativeBp.m_121955_((Vec3i)this.originPos);
        Block block = this.getLevel().m_8055_(worldBp).m_60734_();
        return block != Blocks.f_50080_ && block != Blocks.f_50142_;
    }

    public void changeStructure(PortalType portalType) {
        String newStructureName = "";
        switch (portalType) {
            case CIVILIAN: {
                this.setBuilding(Buildings.PORTAL_CIVILIAN);
                newStructureName = "portal_civilian";
                break;
            }
            case MILITARY: {
                this.setBuilding(Buildings.PORTAL_MILITARY);
                newStructureName = "portal_military";
                break;
            }
            case TRANSPORT: {
                this.setBuilding(Buildings.PORTAL_TRANSPORT);
                newStructureName = "portal_transport";
            }
        }
        this.updateButtons();
        if (!newStructureName.isEmpty()) {
            ArrayList<BuildingBlock> newBlocks = BuildingBlockData.getBuildingBlocksFromNbt(newStructureName, (LevelAccessor)this.getLevel());
            this.blocks = BuildingUtils.getAbsoluteBlockData(newBlocks, (LevelAccessor)this.getLevel(), this.originPos, this.rotation);
            super.refreshBlocks();
        }
    }

    @Override
    public void updateButtons() {
        if (this.level.m_5776_()) {
            super.updateButtons();
            switch (this.getPortalType()) {
                case CIVILIAN: {
                    this.productionButtons = List.of(ProductionItems.RESEARCH_RESOURCE_CAPACITY.getStartButton(this, Keybindings.keyQ));
                    break;
                }
                case MILITARY: {
                    this.productionButtons = Arrays.asList(ProductionItems.BRUTE.getStartButton(this, Keybindings.keyQ), ProductionItems.HEADHUNTER.getStartButton(this, Keybindings.keyW), ProductionItems.HOGLIN.getStartButton(this, Keybindings.keyE), ProductionItems.BLAZE.getStartButton(this, Keybindings.keyR), ProductionItems.WITHER_SKELETON.getStartButton(this, Keybindings.keyT), ProductionItems.MAGMA_CUBE.getStartButton(this, Keybindings.keyY), ProductionItems.GHAST.getStartButton(this, Keybindings.keyU));
                    break;
                }
                case TRANSPORT: {
                    this.productionButtons = List.of();
                }
            }
        }
    }

    @Override
    public double getMaxRange() {
        return 20.0;
    }

    @Override
    public double getStartingRange() {
        return 3.0;
    }

    @Override
    public NetherZone getZone() {
        return this.netherConversionZone;
    }

    public void checkAndConsumeChestItems() {
        if (!this.getLevel().m_5776_()) {
            BlockPos textPos = null;
            int food = 0;
            int wood = 0;
            int ore = 0;
            for (BuildingBlock block : this.getBlocks()) {
                BlockEntity blockEntity;
                if (block.getBlockState().m_60734_() != Blocks.f_50087_ || !((blockEntity = this.getLevel().m_7702_(block.getBlockPos())) instanceof ChestBlockEntity)) continue;
                ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
                for (int i = 0; i < chest.f_59073_.size(); ++i) {
                    ResourceSource resource = ResourceSources.getFromItem(chest.m_8020_(i).m_41720_());
                    if (resource == null) continue;
                    int numItems = chest.m_8020_(i).m_41613_();
                    food += resource.resourceName == ResourceName.FOOD ? resource.resourceValue * numItems : 0;
                    wood += resource.resourceName == ResourceName.WOOD ? resource.resourceValue * numItems : 0;
                    ore += resource.resourceName == ResourceName.ORE ? resource.resourceValue * numItems : 0;
                    chest.m_7407_(i, numItems);
                    textPos = block.getBlockPos().m_7918_(0, -2, 0);
                }
            }
            if (food > 0 || wood > 0 || ore > 0) {
                Resources res = new Resources(this.ownerName, food, wood, ore);
                ResourcesServerEvents.addSubtractResources(res);
                ResourcesClientboundPacket.showFloatingText(res, textPos);
            }
        }
    }

    public boolean hasDestination() {
        return this.isBuilt && this.getBuilding() instanceof PortalTransport && this.destination != null && !this.destination.equals((Object)new BlockPos(0, 0, 0));
    }

    public static enum PortalType {
        BASIC,
        CIVILIAN,
        MILITARY,
        TRANSPORT;

    }
}

