/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.placements;

import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingClientboundPacket;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.production.ActiveProduction;
import com.solegendary.reignofnether.building.production.ProductionBuilding;
import com.solegendary.reignofnether.building.production.ProductionItem;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.registrars.EntityRegistrar;
import com.solegendary.reignofnether.resources.ResourceName;
import com.solegendary.reignofnether.resources.ResourceSources;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.resources.ResourcesClientboundPacket;
import com.solegendary.reignofnether.resources.ResourcesServerEvents;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;

public class ProductionPlacement
extends BuildingPlacement {
    private BlockPos rallyPoint;
    private LivingEntity rallyPointEntity;
    public List<Button> productionButtons;
    public final List<ActiveProduction> productionQueue = new ArrayList<ActiveProduction>();
    private ActiveProduction active;

    public ProductionPlacement(Building building, Level level, BlockPos originPos, Rotation rotation, String ownerName, ArrayList<BuildingBlock> blocks, boolean isCapitol) {
        super(building, level, originPos, rotation, ownerName, blocks, isCapitol);
        if (building instanceof ProductionBuilding) {
            ProductionBuilding productionBuilding = (ProductionBuilding)building;
            this.productionButtons = productionBuilding.productions.getButtons(this);
        }
    }

    public BlockPos getRallyPoint() {
        return this.rallyPoint;
    }

    public LivingEntity getRallyPointEntity() {
        if (this.rallyPointEntity == null) {
            return null;
        }
        if (!this.rallyPointEntity.m_6084_()) {
            this.rallyPointEntity = null;
            return null;
        }
        return this.rallyPointEntity;
    }

    public void setRallyPoint(BlockPos rallyPoint) {
        ProductionBuilding building = (ProductionBuilding)this.getBuilding();
        if (!this.canSetRallyPoint()) {
            return;
        }
        this.rallyPoint = this.isPosInsideBuilding(rallyPoint) ? null : rallyPoint;
        this.rallyPointEntity = null;
    }

    public boolean canSetRallyPoint() {
        return ((ProductionBuilding)this.getBuilding()).canSetRallyPoint;
    }

    public void setRallyPointEntity(LivingEntity entity) {
        Unit unit;
        ProductionBuilding building = (ProductionBuilding)this.getBuilding();
        if (!this.canSetRallyPoint() || entity == null) {
            return;
        }
        if (!(entity instanceof Unit) || (unit = (Unit)entity).getOwnerName().equals(this.ownerName)) {
            this.rallyPointEntity = entity;
        }
        this.rallyPoint = null;
    }

    private boolean isProducing() {
        return this.productionQueue.size() > 0;
    }

    public BlockPos getIndoorSpawnPoint(ServerLevel level) {
        ProductionBuilding building = (ProductionBuilding)this.getBuilding();
        return building.getIndoorSpawnPoint(level, this.centrePos);
    }

    public BlockPos getDefaultOutdoorSpawnPoint() {
        ProductionBuilding building = (ProductionBuilding)this.getBuilding();
        return building.getDefaultOutdoorSpawnPoint(BuildingUtils.getMinCorner(this.blocks));
    }

    public Entity produceUnit(ServerLevel level, EntityType<? extends Unit> entityType, String ownerName, boolean spawnIndoors) {
        BlockPos rallyPoint;
        BlockPos spawnPoint;
        ProductionBuilding building = (ProductionBuilding)this.getBuilding();
        LivingEntity rallyEntity = this.getRallyPointEntity();
        if (spawnIndoors) {
            spawnPoint = this.getIndoorSpawnPoint(level);
            if (entityType == EntityRegistrar.GHAST_UNIT.get()) {
                spawnPoint = spawnPoint.m_7918_(0, 5, 0);
            }
        } else {
            spawnPoint = this.rallyPoint != null ? this.getClosestGroundPos(this.rallyPoint, (int)building.spawnRadiusOffset) : (this.rallyPointEntity != null ? this.getClosestGroundPos(this.rallyPointEntity.m_20097_(), (int)building.spawnRadiusOffset) : this.getDefaultOutdoorSpawnPoint());
        }
        Entity entity = entityType.m_262455_(level, (CompoundTag)null, null, spawnPoint, MobSpawnType.SPAWNER, true, false);
        BlockPos defaultRallyPoint = this.getDefaultOutdoorSpawnPoint();
        BlockPos blockPos = rallyPoint = this.rallyPoint == null ? defaultRallyPoint : this.rallyPoint;
        if (entity instanceof Unit) {
            Unit unit = (Unit)entity;
            unit.setOwnerName(ownerName);
            unit.setupEquipmentAndUpgradesServer();
            if (rallyEntity != null) {
                if (ResourceSources.isHuntableAnimal(rallyEntity)) {
                    CompletableFuture.delayedExecutor(500L, TimeUnit.MILLISECONDS).execute(() -> UnitServerEvents.addActionItem(this.ownerName, UnitAction.ATTACK, rallyEntity.m_19879_(), new int[]{entity.m_19879_()}, rallyPoint, new BlockPos(0, 0, 0)));
                } else {
                    CompletableFuture.delayedExecutor(500L, TimeUnit.MILLISECONDS).execute(() -> UnitServerEvents.addActionItem(this.ownerName, UnitAction.FOLLOW, rallyEntity.m_19879_(), new int[]{entity.m_19879_()}, rallyPoint, new BlockPos(0, 0, 0)));
                }
            } else {
                CompletableFuture.delayedExecutor(500L, TimeUnit.MILLISECONDS).execute(() -> UnitServerEvents.addActionItem(this.ownerName, UnitAction.MOVE, -1, new int[]{entity.m_19879_()}, rallyPoint, new BlockPos(0, 0, 0)));
            }
        }
        return entity;
    }

    public boolean startProductionItem(ProductionItem prodItem, BlockPos pos) {
        boolean success = false;
        if (prodItem != null) {
            if (this.getLevel().m_5776_()) {
                ActiveProduction activeProduction = new ActiveProduction(prodItem, true, this.ownerName);
                this.productionQueue.add(activeProduction);
                success = true;
            } else if (prodItem.canAfford(this.getLevel(), this.ownerName)) {
                ActiveProduction activeProduction = new ActiveProduction(prodItem, false, this.ownerName);
                this.productionQueue.add(activeProduction);
                ResourcesServerEvents.addSubtractResources(new Resources(this.ownerName, -prodItem.getCost((boolean)this.level.m_5776_(), (String)this.ownerName).food, -prodItem.getCost((boolean)this.level.m_5776_(), (String)this.ownerName).wood, -prodItem.getCost((boolean)this.level.m_5776_(), (String)this.ownerName).ore));
                success = true;
            } else if (!prodItem.isBelowMaxPopulation(this.level, this.ownerName)) {
                ResourcesClientboundPacket.warnMaxPopulation(this.ownerName);
            } else if (!prodItem.canAffordPopulation(this.getLevel(), this.ownerName)) {
                ResourcesClientboundPacket.warnInsufficientPopulation(this.ownerName);
            } else {
                ResourcesClientboundPacket.warnInsufficientResources(this.ownerName, ResourcesServerEvents.canAfford(this.ownerName, ResourceName.FOOD, prodItem.getCost((boolean)this.level.m_5776_(), (String)this.ownerName).food), ResourcesServerEvents.canAfford(this.ownerName, ResourceName.WOOD, prodItem.getCost((boolean)this.level.m_5776_(), (String)this.ownerName).wood), ResourcesServerEvents.canAfford(this.ownerName, ResourceName.ORE, prodItem.getCost((boolean)this.level.m_5776_(), (String)this.ownerName).ore));
            }
        }
        return success;
    }

    public boolean cancelProductionItem(ProductionItem item, BlockPos pos, boolean frontItem) {
        boolean success = false;
        if (!this.productionQueue.isEmpty()) {
            if (frontItem) {
                ActiveProduction prodItem = this.productionQueue.get(0);
                this.productionQueue.remove(0);
                this.active = null;
                if (!this.getLevel().m_5776_()) {
                    ResourcesServerEvents.addSubtractResources(new Resources(this.ownerName, prodItem.item.getCost((boolean)this.level.m_5776_(), (String)this.ownerName).food, prodItem.item.getCost((boolean)this.level.m_5776_(), (String)this.ownerName).wood, prodItem.item.getCost((boolean)this.level.m_5776_(), (String)this.ownerName).ore));
                }
                success = true;
            } else {
                for (int i = 0; i < this.productionQueue.size(); ++i) {
                    ActiveProduction prodItem = this.productionQueue.get(i);
                    if (!prodItem.item.equals(item) || !(prodItem.ticksLeft >= (float)prodItem.item.getCost((boolean)this.level.m_5776_(), (String)this.ownerName).ticks)) continue;
                    this.productionQueue.remove(prodItem);
                    if (!this.getLevel().m_5776_()) {
                        ResourcesServerEvents.addSubtractResources(new Resources(this.ownerName, prodItem.item.getCost((boolean)this.level.m_5776_(), (String)this.ownerName).food, prodItem.item.getCost((boolean)this.level.m_5776_(), (String)this.ownerName).wood, prodItem.item.getCost((boolean)this.level.m_5776_(), (String)this.ownerName).ore));
                    }
                    success = true;
                    break;
                }
            }
        }
        return success;
    }

    @Override
    public void tick(Level tickLevel) {
        ActiveProduction nextItem;
        super.tick(tickLevel);
        if (this.productionQueue.size() >= 1 && nextItem.item.tick(this, nextItem = this.productionQueue.get(0)) && !tickLevel.m_5776_()) {
            this.active = null;
            this.productionQueue.remove(0);
            if (this.productionQueue.isEmpty()) {
                BuildingClientboundPacket.clearQueue(this.originPos);
            } else {
                BuildingClientboundPacket.completeProduction(this.originPos);
            }
        }
    }

    @Override
    public void updateButtons() {
        if (this.level.m_5776_()) {
            super.updateButtons();
            Building building = this.getBuilding();
            if (building instanceof ProductionBuilding) {
                ProductionBuilding productionBuilding = (ProductionBuilding)building;
                this.productionButtons = productionBuilding.productions.getButtons(this);
            }
        }
    }
}

