/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.production.dynamic;

import com.solegendary.reignofnether.building.production.dynamic.DynamicProductionProperties;
import com.solegendary.reignofnether.building.production.dynamic.ProductionType;
import com.solegendary.reignofnether.faction.FactionType;
import com.solegendary.reignofnether.resources.dynamic.DynamicResourceType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class DynamicProductionItem {
    private final ResourceLocation id;
    private final String displayName;
    private final FactionType faction;
    private final ProductionType productionType;
    private final ItemStack result;
    private final Map<DynamicResourceType, Integer> resourceCosts;
    private final DynamicProductionProperties properties;
    private final List<ResourceLocation> requirements;

    public DynamicProductionItem(ResourceLocation id, String displayName, FactionType faction, ProductionType productionType, ItemStack result, Map<DynamicResourceType, Integer> resourceCosts, DynamicProductionProperties properties, List<ResourceLocation> requirements) {
        this.id = id;
        this.displayName = displayName;
        this.faction = faction;
        this.productionType = productionType;
        this.result = result;
        this.resourceCosts = resourceCosts;
        this.properties = properties != null ? properties : DynamicProductionProperties.defaultProperties();
        this.requirements = requirements != null ? requirements : List.of();
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public FactionType getFaction() {
        return this.faction;
    }

    public ProductionType getProductionType() {
        return this.productionType;
    }

    public ItemStack getResult() {
        return this.result.m_41777_();
    }

    public Map<DynamicResourceType, Integer> getResourceCosts() {
        return Map.copyOf(this.resourceCosts);
    }

    public DynamicProductionProperties getProperties() {
        return this.properties;
    }

    public List<ResourceLocation> getRequirements() {
        return List.copyOf(this.requirements);
    }

    public int getResourceCost(DynamicResourceType resourceType) {
        return this.resourceCosts.getOrDefault(resourceType, 0);
    }

    public boolean requiresResource(DynamicResourceType resourceType) {
        return this.resourceCosts.containsKey(resourceType) && this.resourceCosts.get(resourceType) > 0;
    }

    public int getProductionTime() {
        return this.properties.getProductionTime();
    }

    public boolean hasRequirements() {
        return !this.requirements.isEmpty();
    }

    public int getTotalResourceValue() {
        return this.resourceCosts.entrySet().stream().mapToInt(entry -> ((DynamicResourceType)entry.getKey()).getProperties().getBaseValue() * (Integer)entry.getValue()).sum();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DynamicProductionItem that = (DynamicProductionItem)obj;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "DynamicProductionItem{id=" + this.id + ", displayName='" + this.displayName + "', faction=" + (this.faction != null ? this.faction.getDisplayName() : "null") + ", productionType=" + this.productionType + ", result=" + this.result + "}";
    }
}

