/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.config.ResourceBlockConfig;
import com.solegendary.reignofnether.resources.ResourceName;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fml.loading.FMLPaths;

public class ResourceBlockConfigHandler {
    private static final String CONFIG_FILENAME = "resource_blocks.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    private static Path getConfigPath() {
        Path configDir = FMLPaths.CONFIGDIR.get();
        return configDir.resolve("reignofnether").resolve(CONFIG_FILENAME);
    }

    public static void loadConfig() {
        Path configPath = ResourceBlockConfigHandler.getConfigPath();
        if (!Files.exists(configPath, new LinkOption[0])) {
            ReignOfNether.LOGGER.info("Resource block config file not found, creating default config at: " + configPath);
            ResourceBlockConfigHandler.saveConfig();
            return;
        }
        try (FileReader reader = new FileReader(configPath.toFile());){
            int version;
            JsonObject rootObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            if (rootObject.has("config_version") && (version = rootObject.get("config_version").getAsInt()) > ResourceBlockConfigHandler.getCurrentConfigVersion()) {
                ReignOfNether.LOGGER.warn("Resource block config version {} is newer than supported version {}. Some features may not work correctly.", (Object)version, (Object)ResourceBlockConfigHandler.getCurrentConfigVersion());
            }
            if (rootObject.has("resource_blocks")) {
                JsonObject blocksObject = rootObject.getAsJsonObject("resource_blocks");
                HashMap<String, ResourceBlockConfig.ResourceBlockEntry> loadedConfigs = new HashMap<String, ResourceBlockConfig.ResourceBlockEntry>();
                for (Map.Entry entry : blocksObject.entrySet()) {
                    String blockId = (String)entry.getKey();
                    JsonObject blockConfig = ((JsonElement)entry.getValue()).getAsJsonObject();
                    try {
                        ResourceBlockConfig.ResourceBlockEntry configEntry = ResourceBlockConfigHandler.parseBlockConfig(blockId, blockConfig);
                        if (configEntry != null && configEntry.isValidBlock()) {
                            loadedConfigs.put(blockId, configEntry);
                            continue;
                        }
                        if (configEntry == null) continue;
                        ReignOfNether.LOGGER.warn("Block '{}' not found in registry, skipping config entry", (Object)blockId);
                    }
                    catch (Exception e) {
                        ReignOfNether.LOGGER.error("Failed to parse config for block '{}': {}", (Object)blockId, (Object)e.getMessage());
                    }
                }
                ResourceBlockConfig.loadConfigs(loadedConfigs);
                ReignOfNether.LOGGER.info("Loaded {} resource block configurations", (Object)loadedConfigs.size());
                Map<String, Integer> stats = ResourceBlockConfig.getStatistics();
                ReignOfNether.LOGGER.info("Resource block stats - Total: {}, Enabled: {}, Wood: {}, Food: {}, Ore: {}, Modded: {}", (Object)stats.get("total"), (Object)stats.get("enabled"), (Object)stats.get("wood"), (Object)stats.get("food"), (Object)stats.get("ore"), (Object)stats.get("modded"));
            }
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Failed to load resource block config: {}", (Object)e.getMessage());
            ReignOfNether.LOGGER.info("Using default resource block configurations");
        }
    }

    public static void saveConfig() {
        Path configPath = ResourceBlockConfigHandler.getConfigPath();
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            JsonObject rootObject = new JsonObject();
            rootObject.addProperty("config_version", (Number)ResourceBlockConfigHandler.getCurrentConfigVersion());
            rootObject.addProperty("description", "Resource block configuration for Reign of Nether. Modify values to customize resource generation from blocks.");
            JsonObject infoObject = new JsonObject();
            infoObject.addProperty("resource_types", "WOOD, FOOD, ORE");
            infoObject.addProperty("resource_value", "Amount of resources generated when harvested");
            infoObject.addProperty("gather_ticks", "Time in ticks (20 ticks = 1 second) to harvest the block");
            infoObject.addProperty("enabled", "Whether this block can generate resources");
            infoObject.addProperty("modded_blocks", "You can add modded blocks using their full resource location (e.g., 'modname:blockname')");
            rootObject.add("info", (JsonElement)infoObject);
            JsonObject blocksObject = new JsonObject();
            Map<String, ResourceBlockConfig.ResourceBlockEntry> allConfigs = ResourceBlockConfig.getAllConfigs();
            for (Map.Entry<String, ResourceBlockConfig.ResourceBlockEntry> entry : allConfigs.entrySet()) {
                String blockId = entry.getKey();
                ResourceBlockConfig.ResourceBlockEntry config = entry.getValue();
                JsonObject blockConfig = new JsonObject();
                blockConfig.addProperty("resource_type", config.resourceType.toString());
                blockConfig.addProperty("resource_value", (Number)config.resourceValue);
                blockConfig.addProperty("gather_ticks", (Number)config.gatherTicks);
                blockConfig.addProperty("enabled", Boolean.valueOf(config.enabled));
                blocksObject.add(blockId, (JsonElement)blockConfig);
            }
            rootObject.add("resource_blocks", (JsonElement)blocksObject);
            try (FileWriter writer = new FileWriter(configPath.toFile());){
                GSON.toJson((JsonElement)rootObject, (Appendable)writer);
            }
            ReignOfNether.LOGGER.info("Saved resource block configuration to: " + configPath);
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Failed to save resource block config: {}", (Object)e.getMessage());
        }
    }

    private static ResourceBlockConfig.ResourceBlockEntry parseBlockConfig(String blockId, JsonObject config) {
        try {
            String resourceTypeStr = config.get("resource_type").getAsString().toUpperCase();
            ResourceName resourceType = ResourceName.valueOf(resourceTypeStr);
            int resourceValue = config.get("resource_value").getAsInt();
            int gatherTicks = config.get("gather_ticks").getAsInt();
            boolean enabled = config.get("enabled").getAsBoolean();
            if (resourceValue < 0) {
                ReignOfNether.LOGGER.warn("Invalid resource_value {} for block {}, setting to 1", (Object)resourceValue, (Object)blockId);
                resourceValue = 1;
            }
            if (gatherTicks < 1) {
                ReignOfNether.LOGGER.warn("Invalid gather_ticks {} for block {}, setting to 20", (Object)gatherTicks, (Object)blockId);
                gatherTicks = 20;
            }
            return new ResourceBlockConfig.ResourceBlockEntry(blockId, resourceType, resourceValue, gatherTicks, enabled);
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Failed to parse block config for '{}': {}", (Object)blockId, (Object)e.getMessage());
            return null;
        }
    }

    private static int getCurrentConfigVersion() {
        return 1;
    }

    public static void addBlockConfig(String blockId, ResourceName resourceType, int resourceValue, int gatherTicks, boolean enabled) {
        ResourceBlockConfig.setConfig(blockId, resourceType, resourceValue, gatherTicks, enabled);
        ResourceBlockConfigHandler.saveConfig();
        ReignOfNether.LOGGER.info("Added configuration for block '{}': {} resources, {} ticks, enabled: {}", (Object)blockId, (Object)resourceValue, (Object)gatherTicks, (Object)enabled);
    }

    public static void removeBlockConfig(String blockId) {
        ResourceBlockConfig.removeConfig(blockId);
        ResourceBlockConfigHandler.saveConfig();
        ReignOfNether.LOGGER.info("Removed configuration for block '{}'", (Object)blockId);
    }

    public static void reloadConfig() {
        ReignOfNether.LOGGER.info("Reloading resource block configuration...");
        ResourceBlockConfig.resetToDefaults();
        ResourceBlockConfigHandler.loadConfig();
    }

    public static void exportTemplate(Path outputPath) {
        try {
            JsonObject templateObject = new JsonObject();
            templateObject.addProperty("_template_info", "This is a template for resource block configurations. Copy entries to your resource_blocks.json file.");
            templateObject.addProperty("_mod_id", "reignofnether");
            templateObject.addProperty("_version", (Number)ResourceBlockConfigHandler.getCurrentConfigVersion());
            JsonObject woodBlocks = new JsonObject();
            JsonObject foodBlocks = new JsonObject();
            JsonObject oreBlocks = new JsonObject();
            Map<String, ResourceBlockConfig.ResourceBlockEntry> allConfigs = ResourceBlockConfig.getAllConfigs();
            for (Map.Entry<String, ResourceBlockConfig.ResourceBlockEntry> entry : allConfigs.entrySet()) {
                String blockId = entry.getKey();
                ResourceBlockConfig.ResourceBlockEntry config = entry.getValue();
                JsonObject blockConfig = new JsonObject();
                blockConfig.addProperty("resource_type", config.resourceType.toString());
                blockConfig.addProperty("resource_value", (Number)config.resourceValue);
                blockConfig.addProperty("gather_ticks", (Number)config.gatherTicks);
                blockConfig.addProperty("enabled", Boolean.valueOf(config.enabled));
                switch (config.resourceType) {
                    case WOOD: {
                        woodBlocks.add(blockId, (JsonElement)blockConfig);
                        break;
                    }
                    case FOOD: {
                        foodBlocks.add(blockId, (JsonElement)blockConfig);
                        break;
                    }
                    case ORE: {
                        oreBlocks.add(blockId, (JsonElement)blockConfig);
                    }
                }
            }
            templateObject.add("wood_blocks", (JsonElement)woodBlocks);
            templateObject.add("food_blocks", (JsonElement)foodBlocks);
            templateObject.add("ore_blocks", (JsonElement)oreBlocks);
            try (FileWriter writer = new FileWriter(outputPath.toFile());){
                GSON.toJson((JsonElement)templateObject, (Appendable)writer);
            }
            ReignOfNether.LOGGER.info("Exported resource block template to: " + outputPath);
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Failed to export template: {}", (Object)e.getMessage());
        }
    }
}

