/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.essentialpartnermod.modal;

import com.solegendary.reignofnether.essentialpartnermod.Draw;
import com.solegendary.reignofnether.essentialpartnermod.UResolution;
import com.solegendary.reignofnether.essentialpartnermod.modal.ModalButton;
import com.solegendary.reignofnether.essentialpartnermod.modal.ModalManager;
import java.util.ArrayList;
import java.util.List;

public abstract class Modal {
    protected int width;
    protected int height;
    protected int centreX;
    protected int centreY;
    protected int startX;
    protected int startY;
    protected List<ModalButton> buttonList = new ArrayList<ModalButton>();

    protected void setDimensions(int width, int height) {
        this.width = width;
        this.height = height;
        this.centreX = UResolution.getScaledWidth() / 2;
        this.centreY = UResolution.getScaledHeight() / 2;
        this.startX = this.centreX - width / 2;
        this.startY = this.centreY - height / 2;
    }

    public void init() {
        this.buttonList.clear();
    }

    public void draw(Draw draw) {
        draw.rect(0, 0, UResolution.getScaledWidth(), UResolution.getScaledHeight(), -1778384896);
        this.drawBackground(draw);
        for (ModalButton button : this.buttonList) {
            button.draw(draw);
        }
    }

    protected void drawBackground(Draw draw) {
        draw.rect(this.startX, this.startY, this.startX + this.width, this.startY + this.height, -12105913);
        draw.rect(this.startX + 1, this.startY + 1, this.startX + this.width - 1, this.startY + this.height - 1, -15198184);
    }

    public void mouseClicked(int mouseX, int mouseY) {
        for (ModalButton button : this.buttonList) {
            if (!Draw.hovered(mouseX, mouseY, button.x, button.y, button.width, button.height)) continue;
            button.onClick();
            return;
        }
        if (Draw.hovered(mouseX, mouseY, this.startX, this.startY, this.width, this.height)) {
            return;
        }
        ModalManager.INSTANCE.setModal(null);
    }

    public void keyPressed(int key) {
        if (key == 256) {
            ModalManager.INSTANCE.setModal(null);
        }
    }

    public void close() {
    }
}

