/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.faction;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.faction.FactionProperties;
import com.solegendary.reignofnether.faction.FactionType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.Event;

public class FactionRegistry {
    private static final Map<ResourceLocation, FactionType> FACTIONS = new ConcurrentHashMap<ResourceLocation, FactionType>();
    private static final Map<String, FactionType> FACTIONS_BY_NAME = new ConcurrentHashMap<String, FactionType>();
    private static final List<FactionType> FACTION_LIST = new ArrayList<FactionType>();
    private static boolean initialized = false;
    public static final ResourceLocation VILLAGERS_ID = new ResourceLocation("reignofnether", "villagers");
    public static final ResourceLocation MONSTERS_ID = new ResourceLocation("reignofnether", "monsters");
    public static final ResourceLocation PIGLINS_ID = new ResourceLocation("reignofnether", "piglins");
    public static final ResourceLocation NONE_ID = new ResourceLocation("reignofnether", "none");
    private static FactionType villagersCache;
    private static FactionType monstersCache;
    private static FactionType piglinsCache;
    private static FactionType noneCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized FactionType register(FactionType factionType) {
        if (factionType == null) {
            throw new IllegalArgumentException("FactionType cannot be null");
        }
        ResourceLocation id = factionType.getId();
        if (FACTIONS.containsKey(id)) {
            ReignOfNether.LOGGER.warn("Faction {} is already registered, skipping duplicate registration", (Object)id);
            return FACTIONS.get(id);
        }
        FACTIONS.put(id, factionType);
        FACTIONS_BY_NAME.put(factionType.getDisplayName().toLowerCase(), factionType);
        List<FactionType> list = FACTION_LIST;
        synchronized (list) {
            FACTION_LIST.add(factionType);
        }
        ReignOfNether.LOGGER.info("Registered faction: {} ({})", (Object)factionType.getDisplayName(), (Object)id);
        return factionType;
    }

    public static FactionType getFaction(ResourceLocation id) {
        return FACTIONS.get(id);
    }

    public static FactionType getFactionByName(String name) {
        return FACTIONS_BY_NAME.get(name.toLowerCase());
    }

    public static List<FactionType> getAllFactions() {
        return new ArrayList<FactionType>(FACTION_LIST);
    }

    public static Set<ResourceLocation> getAllFactionIds() {
        return new HashSet<ResourceLocation>(FACTIONS.keySet());
    }

    public static boolean isRegistered(ResourceLocation id) {
        return FACTIONS.containsKey(id);
    }

    public static FactionType getVillagers() {
        if (villagersCache == null) {
            villagersCache = FactionRegistry.getFaction(VILLAGERS_ID);
        }
        return villagersCache;
    }

    public static FactionType getMonsters() {
        if (monstersCache == null) {
            monstersCache = FactionRegistry.getFaction(MONSTERS_ID);
        }
        return monstersCache;
    }

    public static FactionType getPiglins() {
        if (piglinsCache == null) {
            piglinsCache = FactionRegistry.getFaction(PIGLINS_ID);
        }
        return piglinsCache;
    }

    public static FactionType getNone() {
        if (noneCache == null) {
            noneCache = FactionRegistry.getFaction(NONE_ID);
        }
        return noneCache;
    }

    public static synchronized void initializeDefaultFactions() {
        if (initialized) {
            return;
        }
        ReignOfNether.LOGGER.info("Initializing default factions...");
        FactionType villagers = new FactionType(VILLAGERS_ID, "Villagers", 65280, 3329330, FactionProperties.builder().defensive(true).resourceProductionMultiplier(1.2f).buildTimeMultiplier(0.9f).aiDifficultyMultiplier(1.0f).build());
        FactionType monsters = new FactionType(MONSTERS_ID, "Monsters", 0xFF0000, 0x8B0000, FactionProperties.builder().nightHealing(true).nightSourceHealing(true).healingTicks(60).aggressive(true).damageMultiplier(1.1f).aiDifficultyMultiplier(1.2f).build());
        FactionType piglins = new FactionType(PIGLINS_ID, "Piglins", 16766720, 16747520, FactionProperties.builder().fireImmune(true).netherHealing(true).healingTicks(80).expansionist(true).speedMultiplier(1.1f).aiDifficultyMultiplier(1.1f).build());
        FactionType none = new FactionType(NONE_ID, "None", 0x808080, 0x696969, FactionProperties.builder().aiDifficultyMultiplier(0.5f).build());
        FactionRegistry.register(villagers);
        FactionRegistry.register(monsters);
        FactionRegistry.register(piglins);
        FactionRegistry.register(none);
        initialized = true;
        ReignOfNether.LOGGER.info("Default factions initialized successfully");
    }

    public static synchronized void clear() {
        FACTIONS.clear();
        FACTIONS_BY_NAME.clear();
        FACTION_LIST.clear();
        villagersCache = null;
        monstersCache = null;
        piglinsCache = null;
        noneCache = null;
        initialized = false;
    }

    public static class FactionRegistrationEvent
    extends Event {
        public FactionType registerFaction(FactionType factionType) {
            return FactionRegistry.register(factionType);
        }

        public FactionType registerFaction(ResourceLocation id, String displayName, int primaryColor, int secondaryColor) {
            return this.registerFaction(new FactionType(id, displayName, primaryColor, secondaryColor));
        }

        public FactionType registerFaction(ResourceLocation id, String displayName, int primaryColor, int secondaryColor, FactionProperties properties) {
            return this.registerFaction(new FactionType(id, displayName, primaryColor, secondaryColor, properties));
        }
    }
}

