/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.faction;

import com.solegendary.reignofnether.faction.FactionProperties;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;

public class FactionType {
    private final ResourceLocation id;
    private final String displayName;
    private final int primaryColor;
    private final int secondaryColor;
    private final FactionProperties properties;

    public FactionType(ResourceLocation id, String displayName, int primaryColor, int secondaryColor, FactionProperties properties) {
        this.id = id;
        this.displayName = displayName;
        this.primaryColor = primaryColor;
        this.secondaryColor = secondaryColor;
        this.properties = properties != null ? properties : FactionProperties.defaultProperties();
    }

    public FactionType(ResourceLocation id, String displayName, int primaryColor, int secondaryColor) {
        this(id, displayName, primaryColor, secondaryColor, FactionProperties.defaultProperties());
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getPrimaryColor() {
        return this.primaryColor;
    }

    public int getSecondaryColor() {
        return this.secondaryColor;
    }

    public FactionProperties getProperties() {
        return this.properties;
    }

    public int getPrimaryRed() {
        return FastColor.ARGB32.m_13665_((int)this.primaryColor);
    }

    public int getPrimaryGreen() {
        return FastColor.ARGB32.m_13667_((int)this.primaryColor);
    }

    public int getPrimaryBlue() {
        return FastColor.ARGB32.m_13669_((int)this.primaryColor);
    }

    public int getSecondaryRed() {
        return FastColor.ARGB32.m_13665_((int)this.secondaryColor);
    }

    public int getSecondaryGreen() {
        return FastColor.ARGB32.m_13667_((int)this.secondaryColor);
    }

    public int getSecondaryBlue() {
        return FastColor.ARGB32.m_13669_((int)this.secondaryColor);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FactionType that = (FactionType)obj;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "FactionType{id=" + this.id + ", displayName='" + this.displayName + "'}";
    }
}

