/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.fogofwar2;

import net.minecraft.core.BlockPos;

public class TemporaryVision {
    private final BlockPos position;
    private final int range;
    private int remainingTicks;

    public TemporaryVision(BlockPos position, int range, int durationTicks) {
        this.position = position;
        this.range = range;
        this.remainingTicks = durationTicks;
    }

    public void tick() {
        if (this.remainingTicks > 0) {
            --this.remainingTicks;
        }
    }

    public boolean isExpired() {
        return this.remainingTicks <= 0;
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public int getRange() {
        return this.range;
    }

    public int getRemainingTicks() {
        return this.remainingTicks;
    }

    public float getProgress(int originalDuration) {
        return Math.max(0.0f, (float)this.remainingTicks / (float)originalDuration);
    }

    public String toString() {
        return String.format("TemporaryVision{pos=%s, range=%d, remaining=%d}", this.position, this.range, this.remainingTicks);
    }
}

