/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.fogofwar2;

import com.solegendary.reignofnether.alliance.AlliancesClient;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.GarrisonableBuilding;
import com.solegendary.reignofnether.fogofwar2.TemporaryVision;
import com.solegendary.reignofnether.fogofwar2.VisionSource;
import com.solegendary.reignofnether.fogofwar2.VisionSourceType;
import com.solegendary.reignofnether.fogofwar2.VisionType;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.piglins.GhastUnit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;

public class VisionTracker {
    private static final Minecraft MC = Minecraft.m_91087_();
    private final List<VisionSource> visionSources = new ArrayList<VisionSource>();
    private final List<TemporaryVision> temporaryVisions = new ArrayList<TemporaryVision>();
    private final Set<String> revealedPlayers = ConcurrentHashMap.newKeySet();
    private static final int UNIT_VISION_RANGE = 24;
    private static final int BUILDING_VISION_RANGE = 32;
    private static final int EXTENDED_VISION_RANGE = 48;
    private static final int CAPITOL_VISION_RANGE = 40;

    public void clear() {
        this.visionSources.clear();
        this.temporaryVisions.clear();
    }

    public void scanForVisionSources(String playerName) {
        this.visionSources.clear();
        if (VisionTracker.MC.f_91074_ == null) {
            return;
        }
        this.scanUnitsForVision(playerName);
        this.scanBuildingsForVision(playerName);
    }

    private void scanUnitsForVision(String playerName) {
        for (LivingEntity entity : UnitClientEvents.getAllUnits()) {
            Unit unit;
            if (!(entity instanceof Unit) || !this.shouldProvideVision((unit = (Unit)entity).getOwnerName(), playerName)) continue;
            BlockPos position = entity.m_20097_();
            VisionType visionType = this.getUnitVisionType(entity);
            int range = this.getUnitVisionRange(entity);
            this.visionSources.add(new VisionSource(position, range, visionType, VisionSourceType.UNIT));
        }
    }

    private void scanBuildingsForVision(String playerName) {
        for (BuildingPlacement building : BuildingClientEvents.getBuildings()) {
            if (!this.shouldProvideVision(building.ownerName, playerName) || !building.isBuilt) continue;
            BlockPos position = building.centrePos;
            VisionType visionType = this.getBuildingVisionType(building);
            int range = this.getBuildingVisionRange(building);
            this.visionSources.add(new VisionSource(position, range, visionType, VisionSourceType.BUILDING));
        }
    }

    private boolean shouldProvideVision(String ownerName, String playerName) {
        if (ownerName.equals(playerName)) {
            return true;
        }
        if (this.revealedPlayers.contains(ownerName)) {
            return true;
        }
        return AlliancesClient.isAllied(playerName, ownerName);
    }

    private VisionType getUnitVisionType(LivingEntity entity) {
        if (entity instanceof GhastUnit) {
            return VisionType.EXTENDED;
        }
        return VisionType.NORMAL;
    }

    private int getUnitVisionRange(LivingEntity entity) {
        if (entity instanceof GhastUnit) {
            return 48;
        }
        return 24;
    }

    private VisionType getBuildingVisionType(BuildingPlacement building) {
        if (building instanceof GarrisonableBuilding && GarrisonableBuilding.getNumOccupants(building) > 0) {
            return VisionType.EXTENDED;
        }
        if (building.isCapitol) {
            return VisionType.EXTENDED;
        }
        return VisionType.NORMAL;
    }

    private int getBuildingVisionRange(BuildingPlacement building) {
        if (building.isCapitol) {
            return 40;
        }
        if (building instanceof GarrisonableBuilding && GarrisonableBuilding.getNumOccupants(building) > 0) {
            return 48;
        }
        return 32;
    }

    public void addTemporaryVision(BlockPos position, int range, int durationTicks) {
        this.temporaryVisions.add(new TemporaryVision(position, range, durationTicks));
    }

    public boolean tickTemporaryVisions() {
        boolean changed = false;
        Iterator<TemporaryVision> iterator = this.temporaryVisions.iterator();
        while (iterator.hasNext()) {
            TemporaryVision tempVision = iterator.next();
            tempVision.tick();
            if (!tempVision.isExpired()) continue;
            iterator.remove();
            changed = true;
        }
        return changed;
    }

    public void setPlayerRevealed(String playerName, boolean revealed) {
        if (revealed) {
            this.revealedPlayers.add(playerName);
        } else {
            this.revealedPlayers.remove(playerName);
        }
    }

    public boolean isPlayerRevealed(String playerName) {
        return this.revealedPlayers.contains(playerName);
    }

    public List<VisionSource> getVisionSources() {
        return new ArrayList<VisionSource>(this.visionSources);
    }

    public List<TemporaryVision> getTemporaryVisions() {
        return new ArrayList<TemporaryVision>(this.temporaryVisions);
    }

    public int getVisionSourceCount() {
        return this.visionSources.size();
    }

    public int getTemporaryVisionCount() {
        return this.temporaryVisions.size();
    }

    public String getDebugInfo() {
        return String.format("VisionTracker: %d sources, %d temporary, %d revealed players", this.visionSources.size(), this.temporaryVisions.size(), this.revealedPlayers.size());
    }
}

