/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.fogofwar2.anticheat;

import com.solegendary.reignofnether.fogofwar2.anticheat.AntiCheatPackets;
import com.solegendary.reignofnether.fogofwar2.anticheat.FogAntiCheatServer;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

public class AntiCheatEvents {
    private static final Random random = new Random();
    private static int serverTickCounter = 0;
    private static final int VALIDATION_INTERVAL = 600;

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!FogAntiCheatServer.isEnabled()) {
            return;
        }
        if (++serverTickCounter % 20 == 0) {
            FogAntiCheatServer.tick();
        }
        if (serverTickCounter % 600 == 0) {
            AntiCheatEvents.performRandomValidation();
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (FogAntiCheatServer.isEnabled()) {
            FogAntiCheatServer.updatePlayerVision(player2);
            player2.m_213846_((Component)Component.m_237113_((String)"\u00a7a[ANTI-CHEAT] Fog of war protection is active on this server."));
        }
    }

    @SubscribeEvent
    public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
    }

    private static void performRandomValidation() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        List players = server.m_6846_().m_11314_();
        if (players.isEmpty()) {
            return;
        }
        ServerPlayer randomPlayer = (ServerPlayer)players.get(random.nextInt(players.size()));
        FogAntiCheatServer.updatePlayerVision(randomPlayer);
        BlockPos playerPos = randomPlayer.m_20097_();
        BlockPos[] testPositions = AntiCheatEvents.generateTestPositions(playerPos, 3);
        AntiCheatPackets.sendValidationRequest(randomPlayer, testPositions);
    }

    private static BlockPos[] generateTestPositions(BlockPos center, int count) {
        BlockPos[] positions = new BlockPos[count];
        for (int i = 0; i < count; ++i) {
            int distance = 16 + i * 16;
            double angle = random.nextDouble() * 2.0 * Math.PI;
            int x = (int)((double)center.m_123341_() + (double)distance * Math.cos(angle));
            int z = (int)((double)center.m_123343_() + (double)distance * Math.sin(angle));
            positions[i] = new BlockPos(x, center.m_123342_(), z);
        }
        return positions;
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (!FogAntiCheatServer.isEnabled()) {
            return;
        }
        if (player2.f_19797_ % 100 == 0) {
            FogAntiCheatServer.updatePlayerVision(player2);
        }
    }
}

