/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.fogofwar2.anticheat;

import com.solegendary.reignofnether.fogofwar2.FogManager;
import com.solegendary.reignofnether.fogofwar2.anticheat.FogAntiCheat;
import com.solegendary.reignofnether.fogofwar2.anticheat.FogAntiCheatServer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class AntiCheatPackets {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("reignofnether", "fog_anticheat"), () -> "1", "1"::equals, "1"::equals);
    private static int packetId = 0;

    public static void registerPackets() {
        INSTANCE.messageBuilder(ValidationRequestPacket.class, packetId++).decoder(ValidationRequestPacket::decode).encoder(ValidationRequestPacket::encode).consumerMainThread(ValidationRequestPacket::handle).add();
        INSTANCE.messageBuilder(ValidationResponsePacket.class, packetId++).decoder(ValidationResponsePacket::decode).encoder(ValidationResponsePacket::encode).consumerMainThread(ValidationResponsePacket::handle).add();
        INSTANCE.messageBuilder(ViolationReportPacket.class, packetId++).decoder(ViolationReportPacket::decode).encoder(ViolationReportPacket::encode).consumerMainThread(ViolationReportPacket::handle).add();
    }

    public static void sendValidationRequest(ServerPlayer player, BlockPos[] positions) {
        String requestId = "val_" + System.currentTimeMillis() + "_" + player.m_19879_();
        ValidationRequestPacket packet = new ValidationRequestPacket(positions, requestId);
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
    }

    public static void sendViolationReport(String reason, BlockPos position, String evidence) {
        ViolationReportPacket packet = new ViolationReportPacket(reason, position, evidence);
        INSTANCE.sendToServer((Object)packet);
    }

    public static class ValidationRequestPacket {
        private final BlockPos[] positions;
        private final String requestId;

        public ValidationRequestPacket(BlockPos[] positions, String requestId) {
            this.positions = positions;
            this.requestId = requestId;
        }

        public static void encode(ValidationRequestPacket packet, FriendlyByteBuf buf) {
            buf.m_130070_(packet.requestId);
            buf.writeInt(packet.positions.length);
            for (BlockPos pos : packet.positions) {
                buf.m_130064_(pos);
            }
        }

        public static ValidationRequestPacket decode(FriendlyByteBuf buf) {
            String requestId = buf.m_130277_();
            int length = buf.readInt();
            BlockPos[] positions = new BlockPos[length];
            for (int i = 0; i < length; ++i) {
                positions[i] = buf.m_130135_();
            }
            return new ValidationRequestPacket(positions, requestId);
        }

        public static void handle(ValidationRequestPacket packet, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> ValidationRequestPacket.handleValidationRequest(packet.positions, packet.requestId));
            context.get().setPacketHandled(true);
        }

        private static void handleValidationRequest(BlockPos[] positions, String requestId) {
            if (!FogAntiCheat.isEnabled()) {
                return;
            }
            boolean[] results = new boolean[positions.length];
            float[] brightnesses = new float[positions.length];
            for (int i = 0; i < positions.length; ++i) {
                results[i] = FogAntiCheat.validatePosition(positions[i]);
                brightnesses[i] = FogManager.getPositionBrightness(positions[i]);
            }
            ValidationResponsePacket response = new ValidationResponsePacket(requestId, results, brightnesses);
            INSTANCE.sendToServer((Object)response);
        }
    }

    public static class ValidationResponsePacket {
        private final String requestId;
        private final boolean[] validationResults;
        private final float[] brightnesses;

        public ValidationResponsePacket(String requestId, boolean[] validationResults, float[] brightnesses) {
            this.requestId = requestId;
            this.validationResults = validationResults;
            this.brightnesses = brightnesses;
        }

        public static void encode(ValidationResponsePacket packet, FriendlyByteBuf buf) {
            buf.m_130070_(packet.requestId);
            buf.writeInt(packet.validationResults.length);
            for (int i = 0; i < packet.validationResults.length; ++i) {
                buf.writeBoolean(packet.validationResults[i]);
                buf.writeFloat(packet.brightnesses[i]);
            }
        }

        public static ValidationResponsePacket decode(FriendlyByteBuf buf) {
            String requestId = buf.m_130277_();
            int length = buf.readInt();
            boolean[] results = new boolean[length];
            float[] brightnesses = new float[length];
            for (int i = 0; i < length; ++i) {
                results[i] = buf.readBoolean();
                brightnesses[i] = buf.readFloat();
            }
            return new ValidationResponsePacket(requestId, results, brightnesses);
        }

        public static void handle(ValidationResponsePacket packet, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
                if (player != null) {
                    ValidationResponsePacket.handleValidationResponse(player, packet.requestId, packet.validationResults, packet.brightnesses);
                }
            });
            context.get().setPacketHandled(true);
        }

        private static void handleValidationResponse(ServerPlayer player, String requestId, boolean[] results, float[] brightnesses) {
            for (int i = 0; i < results.length; ++i) {
                if (!results[i]) {
                    FogAntiCheatServer.reportViolation(player, "Client validation failure", player.m_20097_().m_7918_(i * 16, 0, 0));
                }
                if (!(brightnesses[i] > 0.95f)) continue;
            }
        }
    }

    public static class ViolationReportPacket {
        private final String reason;
        private final BlockPos position;
        private final String evidence;

        public ViolationReportPacket(String reason, BlockPos position, String evidence) {
            this.reason = reason;
            this.position = position;
            this.evidence = evidence;
        }

        public static void encode(ViolationReportPacket packet, FriendlyByteBuf buf) {
            buf.m_130070_(packet.reason);
            buf.m_130064_(packet.position);
            buf.m_130070_(packet.evidence);
        }

        public static ViolationReportPacket decode(FriendlyByteBuf buf) {
            return new ViolationReportPacket(buf.m_130277_(), buf.m_130135_(), buf.m_130277_());
        }

        public static void handle(ViolationReportPacket packet, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
                if (player != null) {
                    FogAntiCheatServer.reportViolation(player, packet.reason, packet.position);
                }
            });
            context.get().setPacketHandled(true);
        }
    }
}

