/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.fogofwar2.anticheat;

import com.solegendary.reignofnether.fogofwar2.FogManager;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.ChunkPos;

public class FogAntiCheat {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static boolean enabled = false;
    private static long lastValidationTime = 0L;
    private static final long VALIDATION_INTERVAL_MS = 30000L;
    private static final Map<ChunkPos, String> chunkHashCache = new ConcurrentHashMap<ChunkPos, String>();
    private static final Set<BlockPos> suspiciousPositions = ConcurrentHashMap.newKeySet();
    private static int validationFailures = 0;
    private static final int MAX_FAILURES = 3;
    private static long lastMessageTime = 0L;
    private static final long MESSAGE_COOLDOWN_MS = 5000L;
    private static final ThreadLocal<Boolean> validationInProgress = ThreadLocal.withInitial(() -> false);
    private static final float SUSPICION_THRESHOLD = 0.6f;
    private static final float TOLERANCE = 0.05f;
    private static final List<BlockPos> validationCheckpoints = new ArrayList<BlockPos>();
    private static final Random random = new Random();

    public static void initialize() {
        enabled = true;
        validationFailures = 0;
        chunkHashCache.clear();
        suspiciousPositions.clear();
        FogAntiCheat.generateValidationCheckpoints();
        if (FogAntiCheat.MC.f_91074_ != null && FogAntiCheat.isDebugMode()) {
            FogAntiCheat.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)"[FOG-AC] Anti-cheat system initialized"));
        }
    }

    public static void setEnabled(boolean enable) {
        enabled = enable;
        if (enable) {
            FogAntiCheat.initialize();
        } else {
            chunkHashCache.clear();
            suspiciousPositions.clear();
        }
    }

    public static boolean isEnabled() {
        return enabled && FogManager.isEnabled();
    }

    public static void tick() {
        if (!FogAntiCheat.isEnabled()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastValidationTime > 30000L) {
            lastValidationTime = currentTime;
            FogAntiCheat.performIntegrityCheck();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validatePosition(BlockPos pos) {
        if (!FogAntiCheat.isEnabled()) {
            return true;
        }
        if (validationInProgress.get().booleanValue()) {
            return true;
        }
        validationInProgress.set(true);
        try {
            ChunkPos chunkPos = new ChunkPos(pos);
            boolean isVisible = FogManager.isChunkVisible(chunkPos);
            float expectedBrightness = isVisible ? 1.0f : 0.35f;
            boolean isValid = FogAntiCheat.validateClientRendering(pos, expectedBrightness);
            if (!isValid) {
                suspiciousPositions.add(pos);
                boolean shouldBeVisible = FogManager.isChunkVisible(chunkPos);
                String details = String.format("Expected: %s (%.2f), Got: %.2f", shouldBeVisible ? "bright" : "dark", Float.valueOf(shouldBeVisible ? 1.0f : 0.35f), Float.valueOf(expectedBrightness));
                FogAntiCheat.reportSuspiciousActivity("Fog bypass detected", pos, details);
            }
            boolean bl = isValid;
            return bl;
        }
        catch (Exception e) {
            System.err.println("[FOG-AC] Validation error: " + e.getMessage());
            boolean bl = true;
            return bl;
        }
        finally {
            validationInProgress.set(false);
        }
    }

    private static boolean validateClientRendering(BlockPos pos, float expectedBrightness) {
        try {
            ChunkPos chunkPos = new ChunkPos(pos);
            boolean shouldBeVisible = FogManager.isChunkVisible(chunkPos);
            if (!shouldBeVisible && expectedBrightness > 0.6f) {
                return false;
            }
            if (shouldBeVisible && expectedBrightness >= 0.95f) {
                return true;
            }
            if (!shouldBeVisible && expectedBrightness <= 0.4f) {
                return true;
            }
            return true;
        }
        catch (Exception e) {
            return true;
        }
    }

    private static boolean validateChunkIntegrity(ChunkPos chunkPos) {
        try {
            String currentHash = FogAntiCheat.generateChunkHash(chunkPos);
            String cachedHash = chunkHashCache.get(chunkPos);
            if (cachedHash != null && !cachedHash.equals(currentHash)) {
                return false;
            }
            chunkHashCache.put(chunkPos, currentHash);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String generateChunkHash(ChunkPos chunkPos) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(String.valueOf(chunkPos.f_45578_).getBytes());
        md.update(String.valueOf(chunkPos.f_45579_).getBytes());
        boolean isVisible = FogManager.isChunkVisible(chunkPos);
        md.update(String.valueOf(isVisible).getBytes());
        float brightness = FogManager.getPositionBrightness(chunkPos.m_45615_());
        md.update(String.valueOf(brightness).getBytes());
        long gameTime = FogAntiCheat.MC.f_91073_ != null ? FogAntiCheat.MC.f_91073_.m_46467_() : 0L;
        md.update(String.valueOf(gameTime / 100L).getBytes());
        byte[] hashBytes = md.digest();
        StringBuilder sb = new StringBuilder();
        for (byte b : hashBytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    private static void performIntegrityCheck() {
        if (FogAntiCheat.MC.f_91073_ == null || FogAntiCheat.MC.f_91074_ == null) {
            return;
        }
        BlockPos playerPos = FogAntiCheat.MC.f_91074_.m_20097_();
        List<BlockPos> testPositions = FogAntiCheat.getRandomTestPositions(playerPos, 5);
        int failures = 0;
        for (BlockPos testPos : testPositions) {
            if (FogAntiCheat.validatePosition(testPos)) continue;
            ++failures;
        }
        if (failures > testPositions.size() / 2) {
            FogAntiCheat.reportSuspiciousActivity("Multiple validation failures", playerPos, failures);
            if (++validationFailures >= 3) {
                FogAntiCheat.handleAntiCheatViolation();
            }
        } else {
            validationFailures = Math.max(0, validationFailures - 1);
        }
        FogAntiCheat.cleanupSuspiciousPositions();
    }

    private static List<BlockPos> getRandomTestPositions(BlockPos center, int count) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (int i = 0; i < count; ++i) {
            if (i < validationCheckpoints.size()) {
                BlockPos checkpoint = validationCheckpoints.get(i);
                positions.add(center.m_7918_(checkpoint.m_123341_(), 0, checkpoint.m_123343_()));
                continue;
            }
            int x = random.nextInt(61) - 30;
            int z = random.nextInt(61) - 30;
            positions.add(center.m_7918_(x, 0, z));
        }
        return positions;
    }

    private static void generateValidationCheckpoints() {
        validationCheckpoints.clear();
        validationCheckpoints.add(new BlockPos(16, 0, 0));
        validationCheckpoints.add(new BlockPos(-16, 0, 0));
        validationCheckpoints.add(new BlockPos(0, 0, 16));
        validationCheckpoints.add(new BlockPos(0, 0, -16));
        validationCheckpoints.add(new BlockPos(32, 0, 32));
        validationCheckpoints.add(new BlockPos(-32, 0, -32));
    }

    private static void reportSuspiciousActivity(String reason, BlockPos pos, Object evidence) {
        String message = String.format("[FOG-AC] Suspicious: %s at %s (Evidence: %s)", reason, pos.toString(), evidence.toString());
        System.out.println(message);
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastMessageTime < 5000L) {
            return;
        }
        if (FogAntiCheat.MC.f_91074_ == null) {
            return;
        }
        if (FogAntiCheat.isDebugMode()) {
            try {
                FogAntiCheat.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)message));
                lastMessageTime = currentTime;
            }
            catch (Exception e) {
                System.err.println("[FOG-AC] Failed to send chat message: " + e.getMessage());
            }
        }
    }

    private static void handleAntiCheatViolation() {
        if (FogAntiCheat.MC.f_91074_ == null) {
            return;
        }
        String warning = "[FOG-AC] WARNING: Possible fog of war tampering detected!";
        FogAntiCheat.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)warning));
        FogManager.forceUpdate();
        validationFailures = 0;
        chunkHashCache.clear();
        System.out.println(warning + " Player: " + FogAntiCheat.MC.f_91074_.m_7755_().getString());
    }

    private static void cleanupSuspiciousPositions() {
        if (suspiciousPositions.size() > 100) {
            Iterator<BlockPos> iterator = suspiciousPositions.iterator();
            int removeCount = suspiciousPositions.size() / 2;
            for (int i = 0; i < removeCount && iterator.hasNext(); ++i) {
                iterator.next();
                iterator.remove();
            }
        }
    }

    public static String getStatistics() {
        return String.format("FogAntiCheat: %d suspicious positions, %d failures, %d chunks tracked", suspiciousPositions.size(), validationFailures, chunkHashCache.size());
    }

    private static boolean isDebugMode() {
        return FogAntiCheat.MC.f_91074_ != null && FogAntiCheat.MC.f_91074_.m_20310_(4);
    }

    public static void reset() {
        validationFailures = 0;
        chunkHashCache.clear();
        suspiciousPositions.clear();
        lastValidationTime = 0L;
    }
}

