/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.fogofwar2.anticheat;

import com.solegendary.reignofnether.alliance.AlliancesServerEvents;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ChunkPos;

public class FogAntiCheatServer {
    private static final Map<String, Set<ChunkPos>> playerVisibleChunks = new ConcurrentHashMap<String, Set<ChunkPos>>();
    private static final Map<String, Long> lastUpdateTime = new ConcurrentHashMap<String, Long>();
    private static final Map<String, Integer> violationCount = new ConcurrentHashMap<String, Integer>();
    private static final long UPDATE_INTERVAL_MS = 15000L;
    private static final int MAX_VIOLATIONS = 5;
    private static final int UNIT_VISION_RANGE = 24;
    private static final int BUILDING_VISION_RANGE = 32;
    private static boolean enabled = false;

    public static void setEnabled(boolean enable) {
        enabled = enable;
        if (enable) {
            playerVisibleChunks.clear();
            lastUpdateTime.clear();
            violationCount.clear();
        }
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void updatePlayerVision(ServerPlayer player) {
        if (!FogAntiCheatServer.isEnabled() || player == null) {
            return;
        }
        String playerName = player.m_7755_().getString();
        long currentTime = System.currentTimeMillis();
        Long lastUpdate = lastUpdateTime.get(playerName);
        if (lastUpdate != null && currentTime - lastUpdate < 15000L) {
            return;
        }
        lastUpdateTime.put(playerName, currentTime);
        Set<ChunkPos> visibleChunks = FogAntiCheatServer.calculatePlayerVision(player);
        playerVisibleChunks.put(playerName, visibleChunks);
    }

    private static Set<ChunkPos> calculatePlayerVision(ServerPlayer player) {
        HashSet<ChunkPos> visibleChunks = new HashSet<ChunkPos>();
        String playerName = player.m_7755_().getString();
        for (LivingEntity entity : UnitServerEvents.getAllUnits()) {
            Unit unit;
            if (!(entity instanceof Unit) || !FogAntiCheatServer.shouldProvideVision((unit = (Unit)entity).getOwnerName(), playerName)) continue;
            BlockPos unitPos = entity.m_20097_();
            FogAntiCheatServer.addVisionCircle(visibleChunks, unitPos, 24);
        }
        for (BuildingPlacement building : BuildingServerEvents.getBuildings()) {
            if (!building.isBuilt || !FogAntiCheatServer.shouldProvideVision(building.ownerName, playerName)) continue;
            FogAntiCheatServer.addVisionCircle(visibleChunks, building.centrePos, 32);
        }
        return visibleChunks;
    }

    private static boolean shouldProvideVision(String ownerName, String playerName) {
        if (ownerName.equals(playerName)) {
            return true;
        }
        return AlliancesServerEvents.isAllied(playerName, ownerName);
    }

    private static void addVisionCircle(Set<ChunkPos> visibleChunks, BlockPos center, int range) {
        ChunkPos centerChunk = new ChunkPos(center);
        int chunkRange = range / 16 + 1;
        for (int x = -chunkRange; x <= chunkRange; ++x) {
            for (int z = -chunkRange; z <= chunkRange; ++z) {
                ChunkPos chunkPos = new ChunkPos(centerChunk.f_45578_ + x, centerChunk.f_45579_ + z);
                double distance = FogAntiCheatServer.getChunkCenterDistance(center, chunkPos);
                if (!(distance <= (double)range)) continue;
                visibleChunks.add(chunkPos);
            }
        }
    }

    private static double getChunkCenterDistance(BlockPos blockPos, ChunkPos chunkPos) {
        int chunkCenterX = chunkPos.m_45615_().m_123341_() + 8;
        int chunkCenterZ = chunkPos.m_45615_().m_123343_() + 8;
        double dx = blockPos.m_123341_() - chunkCenterX;
        double dz = blockPos.m_123343_() - chunkCenterZ;
        return Math.sqrt(dx * dx + dz * dz);
    }

    public static boolean validatePlayerVision(ServerPlayer player, BlockPos position) {
        if (!FogAntiCheatServer.isEnabled() || player == null) {
            return true;
        }
        String playerName = player.m_7755_().getString();
        Set<ChunkPos> visibleChunks = playerVisibleChunks.get(playerName);
        if (visibleChunks == null) {
            FogAntiCheatServer.updatePlayerVision(player);
            visibleChunks = playerVisibleChunks.get(playerName);
        }
        if (visibleChunks == null) {
            return false;
        }
        ChunkPos chunkPos = new ChunkPos(position);
        return visibleChunks.contains(chunkPos);
    }

    public static void reportViolation(ServerPlayer player, String reason, BlockPos position) {
        if (!FogAntiCheatServer.isEnabled() || player == null) {
            return;
        }
        String playerName = player.m_7755_().getString();
        int violations = violationCount.getOrDefault(playerName, 0) + 1;
        violationCount.put(playerName, violations);
        String message = String.format("[FOG-AC-SERVER] Player %s: %s at %s (Violations: %d)", playerName, reason, position.toString(), violations);
        System.out.println(message);
        if (violations >= 5) {
            FogAntiCheatServer.handlePlayerViolation(player);
        }
    }

    private static void handlePlayerViolation(ServerPlayer player) {
        String playerName = player.m_7755_().getString();
        System.out.println("[FOG-AC-SERVER] Player " + playerName + " exceeded violation threshold!");
        player.m_213846_((Component)Component.m_237113_((String)"\u00a7c[ANTI-CHEAT] Suspicious fog of war behavior detected!"));
        playerVisibleChunks.remove(playerName);
        lastUpdateTime.remove(playerName);
        violationCount.put(playerName, 0);
    }

    public static void tick() {
        if (!FogAntiCheatServer.isEnabled()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        Iterator<Map.Entry<String, Long>> iterator = lastUpdateTime.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Long> entry = iterator.next();
            if (currentTime - entry.getValue() <= 300000L) continue;
            String playerName = entry.getKey();
            iterator.remove();
            playerVisibleChunks.remove(playerName);
            violationCount.remove(playerName);
        }
    }

    public static void forceUpdateAll() {
        if (!FogAntiCheatServer.isEnabled()) {
            return;
        }
        playerVisibleChunks.clear();
        lastUpdateTime.clear();
    }

    public static String getStatistics() {
        return String.format("FogAntiCheatServer: %d players tracked, %d total violations", playerVisibleChunks.size(), violationCount.values().stream().mapToInt(Integer::intValue).sum());
    }

    public static boolean isChunkVisibleToPlayer(ServerPlayer player, ChunkPos chunkPos) {
        if (!FogAntiCheatServer.isEnabled() || player == null) {
            return true;
        }
        String playerName = player.m_7755_().getString();
        Set<ChunkPos> visibleChunks = playerVisibleChunks.get(playerName);
        return visibleChunks != null && visibleChunks.contains(chunkPos);
    }

    public static Set<ChunkPos> getPlayerVisibleChunks(ServerPlayer player) {
        if (!FogAntiCheatServer.isEnabled() || player == null) {
            return Collections.emptySet();
        }
        String playerName = player.m_7755_().getString();
        Set<ChunkPos> chunks = playerVisibleChunks.get(playerName);
        return chunks != null ? new HashSet<ChunkPos>(chunks) : Collections.emptySet();
    }
}

