/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.healthbars;

import com.solegendary.reignofnether.healthbars.BarState;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class BarStates {
    private static final Map<Integer, BarState> HEALTH_STATES = new HashMap<Integer, BarState>();
    private static final Map<Integer, BarState> ABSORB_STATES = new HashMap<Integer, BarState>();
    private static final Map<Integer, BarState> MANA_STATES = new HashMap<Integer, BarState>();
    private static int tickCount = 0;

    public static BarState getState(LivingEntity entity, BarState.BarStateType barStateType) {
        BarState state;
        int id = entity.m_19879_();
        if (barStateType == BarState.BarStateType.HEALTH) {
            state = HEALTH_STATES.get(id);
            if (state == null) {
                state = new BarState(id, barStateType);
                HEALTH_STATES.put(id, state);
            }
        } else if (barStateType == BarState.BarStateType.ABSORB) {
            state = ABSORB_STATES.get(id);
            if (state == null) {
                state = new BarState(id, barStateType);
                ABSORB_STATES.put(id, state);
            }
        } else {
            state = MANA_STATES.get(id);
            if (state == null) {
                state = new BarState(id, barStateType);
                MANA_STATES.put(id, state);
            }
        }
        return state;
    }

    public static void tick() {
        for (BarState state : HEALTH_STATES.values()) {
            state.tick();
        }
        for (BarState state : ABSORB_STATES.values()) {
            state.tick();
        }
        for (BarState state : MANA_STATES.values()) {
            state.tick();
        }
        if (tickCount % 200 == 0) {
            BarStates.cleanCache();
        }
        ++tickCount;
    }

    private static void cleanCache() {
        HEALTH_STATES.entrySet().removeIf(BarStates::stateExpired);
        ABSORB_STATES.entrySet().removeIf(BarStates::stateExpired);
        MANA_STATES.entrySet().removeIf(BarStates::stateExpired);
    }

    private static boolean stateExpired(Map.Entry<Integer, BarState> entry) {
        if (entry.getValue() == null) {
            return true;
        }
        Minecraft MC = Minecraft.m_91087_();
        if (MC.f_91073_ != null) {
            Entity entity = MC.f_91073_.m_6815_(entry.getKey().intValue());
            if (entity == null) {
                return true;
            }
            return !entity.m_6084_();
        }
        return false;
    }
}

