/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.healthbars;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.healthbars.BarState;
import com.solegendary.reignofnether.healthbars.BarStates;
import com.solegendary.reignofnether.orthoview.OrthoviewClientEvents;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.StreamSupport;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.joml.Matrix4f;

public class HealthBarClientEvents {
    private static final ResourceLocation GUI_BARS_TEXTURES = new ResourceLocation("reignofnether:textures/hud/healthbars.png");
    private static final List<LivingEntity> renderedEntities = new ArrayList<LivingEntity>();
    private static final Minecraft MC = Minecraft.m_91087_();

    @SubscribeEvent
    public static void entityRender(RenderLivingEvent.Post<? extends LivingEntity, ? extends EntityModel<?>> evt) {
        HealthBarClientEvents.prepareRenderInWorld(evt.getEntity());
    }

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent evt) {
        if (evt.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        Camera camera = HealthBarClientEvents.MC.f_91063_.m_109153_();
        HealthBarClientEvents.renderBarsInWorld(evt.getPartialTick(), evt.getPoseStack(), camera);
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent evt) {
        if (!evt.player.m_9236_().f_46443_) {
            return;
        }
        BarStates.tick();
    }

    private static boolean shouldShowHealthBar(Entity entity, Minecraft client) {
        return entity instanceof LivingEntity && !(entity instanceof ArmorStand) && (!entity.m_20177_((Player)client.f_91074_) || entity.m_142038_() || entity.m_6060_() || entity instanceof Creeper && ((Creeper)entity).m_7090_() || StreamSupport.stream(entity.m_20158_().spliterator(), false).anyMatch(is -> !is.m_41619_())) && entity != client.f_91074_ && !entity.m_5833_();
    }

    private static void prepareRenderInWorld(LivingEntity entity) {
        Minecraft MC = Minecraft.m_91087_();
        if (!HealthBarClientEvents.shouldShowHealthBar((Entity)entity, MC)) {
            return;
        }
        BarStates.getState(entity, BarState.BarStateType.HEALTH);
        if (entity.m_21223_() >= entity.m_21233_() && entity.m_6103_() <= 0.0f) {
            return;
        }
        if (entity.m_6103_() > 0.0f) {
            BarStates.getState(entity, BarState.BarStateType.ABSORB);
        }
        renderedEntities.add(entity);
    }

    private static void renderBarsInWorld(float partialTick, PoseStack matrix, Camera camera) {
        Minecraft MC = Minecraft.m_91087_();
        if (camera == null) {
            camera = MC.m_91290_().f_114358_;
        }
        if (camera == null) {
            renderedEntities.clear();
            return;
        }
        if (renderedEntities.isEmpty()) {
            return;
        }
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        for (LivingEntity entity : renderedEntities) {
            float scaleToGui = 0.025f;
            boolean sneaking = entity.m_6047_();
            float height = entity.m_20206_() + 0.6f - (sneaking ? 0.25f : 0.0f);
            double x = Mth.m_14139_((double)partialTick, (double)entity.f_19854_, (double)entity.m_20185_());
            double y = Mth.m_14139_((double)partialTick, (double)entity.f_19855_, (double)entity.m_20186_());
            double z = Mth.m_14139_((double)partialTick, (double)entity.f_19856_, (double)entity.m_20189_());
            Vec3 camPos = camera.m_90583_();
            double camX = camPos.m_7096_();
            double camY = camPos.m_7098_();
            double camZ = camPos.m_7094_();
            matrix.m_85836_();
            matrix.m_85837_(x - camX, y + (double)height - camY, z - camZ);
            matrix.m_252781_(Axis.f_252436_.m_252977_(-camera.m_90590_()));
            matrix.m_252781_(Axis.f_252529_.m_252977_(camera.m_90589_()));
            matrix.m_85841_(-scaleToGui, -scaleToGui, scaleToGui);
            int barWidth = entity instanceof Unit ? (int)entity.m_21233_() : (int)entity.m_21233_() * 2;
            barWidth = Math.min(barWidth, 120);
            barWidth = Math.max(barWidth, 20);
            HealthBarClientEvents.renderForEntity(matrix, entity, 0.0, 0.0, barWidth, OrthoviewClientEvents.isEnabled() ? RenderMode.IN_WORLD_ORTHOVIEW : RenderMode.IN_WORLD_FIRST_PERSON);
            HealthBarClientEvents.renderAbsorbForEntity(matrix, entity, 0.0, 0.0, barWidth, OrthoviewClientEvents.isEnabled() ? RenderMode.IN_WORLD_ORTHOVIEW : RenderMode.IN_WORLD_FIRST_PERSON);
            matrix.m_85849_();
        }
        RenderSystem.disableBlend();
        renderedEntities.clear();
    }

    public static void renderForEntity(PoseStack matrix, LivingEntity entity, double x, double y, float width, RenderMode renderMode) {
        BarState state = BarStates.getState(entity, BarState.BarStateType.HEALTH);
        float percent = Math.min(1.0f, Math.min(state.amount, entity.m_21233_()) / entity.m_21233_());
        float percent2 = Math.min(state.previousAmountDisplay, entity.m_21233_()) / entity.m_21233_();
        HealthBarClientEvents.render(matrix, percent, percent2, x, y, width, renderMode, BarState.BarStateType.HEALTH);
    }

    public static void renderAbsorbForEntity(PoseStack matrix, LivingEntity entity, double x, double y, float width, RenderMode renderMode) {
        if (entity.m_6103_() > 0.0f) {
            BarState state = BarStates.getState(entity, BarState.BarStateType.ABSORB);
            float percent = Math.min(1.0f, Math.min(state.amount, MiscUtil.getMaxAbsorptionAmount(entity)) / MiscUtil.getMaxAbsorptionAmount(entity));
            float percent2 = Math.min(state.previousAmountDisplay, MiscUtil.getMaxAbsorptionAmount(entity)) / MiscUtil.getMaxAbsorptionAmount(entity);
            HealthBarClientEvents.render(matrix, percent, percent2, x, y, width, renderMode, BarState.BarStateType.ABSORB, 0.0f, 1.0f, 1.0f, 0.0f, 0.5f, 0.5f);
        }
    }

    public static void renderManaForEntity(PoseStack matrix, HeroUnit heroUnit, double x, double y, float width, RenderMode renderMode) {
        BarState state = BarStates.getState((LivingEntity)heroUnit, BarState.BarStateType.MANA);
        float percent = Math.min(1.0f, Math.min(state.amount, heroUnit.getMaxMana()) / heroUnit.getMaxMana());
        float percent2 = Math.min(state.previousAmountDisplay, heroUnit.getMaxMana()) / heroUnit.getMaxMana();
        HealthBarClientEvents.render(matrix, percent, percent2, x, y, width, renderMode, BarState.BarStateType.MANA, 0.3f, 0.3f, 1.0f, 0.15f, 0.15f, 0.5f);
    }

    public static void renderForBuilding(PoseStack matrix, BuildingPlacement building, double x, double y, float width, RenderMode renderMode) {
        float health = building.getHealth();
        if (health > (float)building.getMaxHealth()) {
            health = building.getMaxHealth();
        }
        float percent = health / (float)building.getMaxHealth();
        HealthBarClientEvents.render(matrix, percent, percent, x, y, width, renderMode, BarState.BarStateType.HEALTH);
    }

    private static void render(PoseStack matrix, float percent, float percent2, double x, double y, float width, RenderMode renderMode, BarState.BarStateType barStateType) {
        float r = Math.max(0.0f, Math.min(1.0f, 2.0f - percent * 2.0f));
        float g = Math.max(0.0f, Math.min(1.0f, percent * 2.0f));
        float b = 0.0f;
        float r2 = r * 0.5f;
        float g2 = g * 0.5f;
        float b2 = b * 0.5f;
        HealthBarClientEvents.render(matrix, percent, percent2, x, y, width, renderMode, barStateType, r, g, b, r2, g2, b2);
    }

    private static void render(PoseStack matrix, float percent, float percent2, double x, double y, float width, RenderMode renderMode, BarState.BarStateType barStateType, float r, float g, float b, float r2, float g2, float b2) {
        int zOffset = 0;
        Matrix4f m4f = matrix.m_85850_().m_252922_();
        if (barStateType != BarState.BarStateType.ABSORB || renderMode != RenderMode.IN_WORLD_ORTHOVIEW && renderMode != RenderMode.IN_WORLD_FIRST_PERSON) {
            HealthBarClientEvents.drawBar(m4f, x, y, width, 1.0f, 0.35f, 0.35f, 0.35f, zOffset++, renderMode);
        }
        HealthBarClientEvents.drawBar(m4f, x, y, width, percent2, r2, g2, b2, zOffset++, renderMode);
        HealthBarClientEvents.drawBar(m4f, x, y, width, percent, r, g, b, zOffset, renderMode);
    }

    private static void drawBar(Matrix4f matrix4f, double x, double y, float width, float percent, float r, float g, float b, int zOffset, RenderMode renderMode) {
        float c = 0.00390625f;
        int u = 0;
        int v = 65;
        int uw = Mth.m_14167_((float)(92.0f * percent));
        int vh = 5;
        double size = percent * width;
        double h = 10.0;
        if (renderMode == RenderMode.GUI_ICON) {
            h = 4.0;
        } else if (renderMode == RenderMode.GUI_PORTRAIT) {
            h = 12.0;
        } else if (renderMode == RenderMode.IN_WORLD_FIRST_PERSON) {
            h = 6.0;
        } else if (renderMode == RenderMode.IN_WORLD_ORTHOVIEW) {
            h = 10.0;
        }
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_BARS_TEXTURES);
        RenderSystem.enableBlend();
        float half = width / 2.0f;
        float zOffsetAmount = renderMode == RenderMode.IN_WORLD_FIRST_PERSON || renderMode == RenderMode.IN_WORLD_ORTHOVIEW ? -0.1f : 0.1f;
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_252986_(matrix4f, (float)((double)(-half) + x), (float)y, (float)zOffset * zOffsetAmount).m_7421_((float)u * c, (float)v * c).m_5752_();
        buffer.m_252986_(matrix4f, (float)((double)(-half) + x), (float)(h + y), (float)zOffset * zOffsetAmount).m_7421_((float)u * c, (float)(v + vh) * c).m_5752_();
        buffer.m_252986_(matrix4f, (float)((double)(-half) + size + x), (float)(h + y), (float)zOffset * zOffsetAmount).m_7421_((float)(u + uw) * c, (float)(v + vh) * c).m_5752_();
        buffer.m_252986_(matrix4f, (float)((double)(-half) + size + x), (float)y, (float)zOffset * zOffsetAmount).m_7421_((float)(u + uw) * c, (float)v * c).m_5752_();
        tessellator.m_85914_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static enum RenderMode {
        GUI_ICON,
        GUI_PORTRAIT,
        IN_WORLD_ORTHOVIEW,
        IN_WORLD_FIRST_PERSON;

    }
}

