/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.hud;

import com.mojang.blaze3d.vertex.PoseStack;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.healthbars.HealthBarClientEvents;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.orthoview.OrthoviewClientEvents;
import com.solegendary.reignofnether.util.MiscUtil;
import com.solegendary.reignofnether.util.MyRenderer;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;

public class Button {
    public String name;
    public int x;
    public int y;
    int iconSize;
    int iconFrameSize;
    int iconSelectedFrameSize;
    public static int DEFAULT_ICON_SIZE = 14;
    public static int DEFAULT_ICON_FRAME_SIZE = 22;
    public static int DEFAULT_ICON_SELECTED_FRAME_SIZE = 24;
    public int tooltipOffsetY = 0;
    public static final int itemIconSize = DEFAULT_ICON_SIZE;
    public ResourceLocation iconResource;
    public ResourceLocation bgIconResource = null;
    public ResourceLocation frameResource = new ResourceLocation("reignofnether", "textures/hud/icon_frame.png");
    public Keybinding hotkey = null;
    public LivingEntity entity = null;
    public BuildingPlacement building = null;
    public Supplier<Boolean> isSelected;
    public Supplier<Boolean> isHidden;
    public Supplier<Boolean> isEnabled;
    public Runnable onLeftClick;
    public Runnable onRightClick;
    public List<FormattedCharSequence> tooltipLines;
    public Supplier<Boolean> isFlashing = () -> false;
    public float greyPercent = 0.0f;
    Minecraft MC = Minecraft.m_91087_();

    public Button(String name, int iconSize, ResourceLocation iconRl, @Nullable Keybinding hotkey, Supplier<Boolean> isSelected, Supplier<Boolean> isHidden, Supplier<Boolean> isEnabled, @Nullable Runnable onLeftClick, @Nullable Runnable onRightClick, @Nullable List<FormattedCharSequence> tooltipLines) {
        this.name = name;
        this.iconResource = iconRl;
        this.iconSize = iconSize;
        this.iconFrameSize = iconSize + 8;
        this.iconSelectedFrameSize = iconSize + 10;
        this.hotkey = hotkey;
        this.isSelected = isSelected;
        this.isHidden = isHidden;
        this.isEnabled = isEnabled;
        this.onLeftClick = onLeftClick;
        this.onRightClick = onRightClick;
        this.tooltipLines = tooltipLines;
    }

    public Button(String name, int iconSize, ResourceLocation iconRl, ResourceLocation frameRl, @Nullable Keybinding hotkey, Supplier<Boolean> isSelected, Supplier<Boolean> isHidden, Supplier<Boolean> isEnabled, @Nullable Runnable onLeftClick, @Nullable Runnable onRightClick, @Nullable List<FormattedCharSequence> tooltipLines) {
        this.name = name;
        this.iconResource = iconRl;
        this.frameResource = frameRl;
        this.iconSize = iconSize;
        this.iconFrameSize = iconSize + 8;
        this.iconSelectedFrameSize = iconSize + 10;
        this.hotkey = hotkey;
        this.isSelected = isSelected;
        this.isHidden = isHidden;
        this.isEnabled = isEnabled;
        this.onLeftClick = onLeftClick;
        this.onRightClick = onRightClick;
        this.tooltipLines = tooltipLines;
    }

    public Button(String name, int iconSize, ResourceLocation iconRl, LivingEntity entity, Supplier<Boolean> isSelected, Supplier<Boolean> isHidden, Supplier<Boolean> isEnabled, @Nullable Runnable onLeftClick, @Nullable Runnable onRightClick, @Nullable List<FormattedCharSequence> tooltipLines) {
        this.name = name;
        this.iconResource = iconRl;
        this.iconSize = iconSize;
        this.iconFrameSize = iconSize + 8;
        this.iconSelectedFrameSize = iconSize + 10;
        this.entity = entity;
        this.isSelected = isSelected;
        this.isHidden = isHidden;
        this.isEnabled = isEnabled;
        this.onLeftClick = onLeftClick;
        this.onRightClick = onRightClick;
        this.tooltipLines = tooltipLines;
    }

    public Button(String name, int iconSize, ResourceLocation iconRl, BuildingPlacement building, Supplier<Boolean> isSelected, Supplier<Boolean> isHidden, Supplier<Boolean> isEnabled, @Nullable Runnable onLeftClick, @Nullable Runnable onRightClick, @Nullable List<FormattedCharSequence> tooltipLines) {
        this.name = name;
        this.iconResource = iconRl;
        this.iconSize = iconSize;
        this.iconFrameSize = iconSize + 8;
        this.iconSelectedFrameSize = iconSize + 10;
        this.building = building;
        this.isSelected = isSelected;
        this.isHidden = isHidden;
        this.isEnabled = isEnabled;
        this.onLeftClick = onLeftClick;
        this.onRightClick = onRightClick;
        this.tooltipLines = tooltipLines;
    }

    public void renderHealthBar(PoseStack poseStack) {
        if (this.entity != null) {
            HealthBarClientEvents.renderForEntity(poseStack, this.entity, (float)this.x + (float)this.iconFrameSize / 2.0f, this.y - 5, this.iconFrameSize - 1, HealthBarClientEvents.RenderMode.GUI_ICON);
        } else if (this.building != null) {
            HealthBarClientEvents.renderForBuilding(poseStack, this.building, (float)this.x + (float)this.iconFrameSize / 2.0f, this.y - 5, this.iconFrameSize - 1, HealthBarClientEvents.RenderMode.GUI_ICON);
        }
    }

    protected void renderHotkey(GuiGraphics guiGraphics, int x, int y) {
        if (this.hotkey != null) {
            String hotkeyStr = this.hotkey.buttonLabel;
            hotkeyStr = hotkeyStr.substring(0, Math.min(3, hotkeyStr.length()));
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 1.0f);
            guiGraphics.m_280137_(this.MC.f_91062_, hotkeyStr, x + this.iconSize + 8 - hotkeyStr.length() * 4, y + this.iconSize - 1, 0xFFFFFF);
        }
    }

    public void render(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        this.x = x;
        this.y = y;
        int xyDiff = (DEFAULT_ICON_SIZE - this.iconSize) / 2;
        if (this.frameResource != null) {
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 1.0f);
            MyRenderer.renderIconFrameWithBg(guiGraphics, this.frameResource, x + xyDiff, y + xyDiff, this.iconFrameSize, 0x64000000);
        }
        if (this.bgIconResource != null) {
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 1.0f);
            MyRenderer.renderIcon(guiGraphics, this.bgIconResource, this.frameResource != null ? x + 4 + (7 - this.iconSize / 2) : x + (7 - this.iconSize / 2), this.frameResource != null ? y + 4 + (7 - this.iconSize / 2) : y + (7 - this.iconSize / 2), this.iconSize);
        }
        if (this.iconResource != null) {
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 1.0f);
            MyRenderer.renderIcon(guiGraphics, this.iconResource, x + 4 + (7 - xyDiff - this.iconSize / 2), y + 4 + (7 - xyDiff - this.iconSize / 2), DEFAULT_ICON_SIZE);
        }
        this.renderHotkey(guiGraphics, x, y);
        if (this.isEnabled.get().booleanValue() && (this.isSelected.get().booleanValue() || this.hotkey != null && this.hotkey.isDown() || this.isMouseOver(mouseX, mouseY) && (MiscUtil.isLeftClickDown(this.MC) && this.onLeftClick != null || MiscUtil.isRightClickDown(this.MC) && this.onRightClick != null)) && this.frameResource != null) {
            ResourceLocation iconFrameSelectedResource = new ResourceLocation("reignofnether", "textures/hud/icon_frame_selected.png");
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 1.0f);
            MyRenderer.renderIcon(guiGraphics, iconFrameSelectedResource, x - 1 + xyDiff, y - 1 + xyDiff, this.iconSelectedFrameSize);
        }
        if (this.isEnabled.get().booleanValue() && this.isMouseOver(mouseX, mouseY)) {
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 1.0f);
            guiGraphics.m_280509_(x + xyDiff, y + xyDiff, x + xyDiff + this.iconFrameSize, y + xyDiff + this.iconFrameSize, 0x32FFFFFF);
        }
        if (this.greyPercent > 0.0f || !this.isEnabled.get().booleanValue()) {
            int greyHeightPx = Math.round(this.greyPercent * (float)this.iconFrameSize);
            if (!this.isEnabled.get().booleanValue()) {
                greyHeightPx = 0;
            }
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 1.0f);
            guiGraphics.m_280509_(x + xyDiff, y + xyDiff + greyHeightPx, x + xyDiff + this.iconFrameSize, y + xyDiff + this.iconFrameSize, -1728053248);
        }
        if (this.isFlashing.get().booleanValue()) {
            guiGraphics.m_280509_(x, y, x + this.iconFrameSize, y + this.iconFrameSize, 0xFFFFFF | (int)(128.0f * MiscUtil.getOscillatingFloat(0.0, 1.0)) << 24);
        }
    }

    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        MyRenderer.renderTooltip(guiGraphics, this.tooltipLines, mouseX, mouseY + this.tooltipOffsetY);
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        int xyDiff = (DEFAULT_ICON_SIZE - this.iconSize) / 2;
        return mouseX >= this.x + xyDiff && mouseY >= this.y + xyDiff && mouseX < this.x + xyDiff + this.iconFrameSize && mouseY < this.y + xyDiff + this.iconFrameSize;
    }

    public void checkClicked(int mouseX, int mouseY, boolean leftClick) {
        if (!OrthoviewClientEvents.isEnabled() || !this.isEnabled.get().booleanValue()) {
            return;
        }
        if (this.isMouseOver(mouseX, mouseY) && this.MC.f_91074_ != null) {
            if (leftClick && this.onLeftClick != null) {
                this.MC.f_91074_.m_5496_((SoundEvent)SoundEvents.f_12490_.get(), 0.2f, 1.0f);
                this.onLeftClick.run();
            } else if (!leftClick && this.onRightClick != null) {
                this.MC.f_91074_.m_5496_((SoundEvent)SoundEvents.f_12490_.get(), 0.2f, 1.0f);
                this.onRightClick.run();
            }
        }
    }

    public void checkPressed(int key) {
        if (!OrthoviewClientEvents.isEnabled() || !this.isEnabled.get().booleanValue()) {
            return;
        }
        if (this.hotkey != null && this.hotkey.key == key) {
            if (this.MC.f_91074_ != null) {
                this.MC.f_91074_.m_5496_((SoundEvent)SoundEvents.f_12490_.get(), 0.2f, 1.0f);
            }
            this.onLeftClick.run();
        }
    }
}

