/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.hud;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import com.solegendary.reignofnether.ability.abilities.EnchantMaiming;
import com.solegendary.reignofnether.ability.abilities.EnchantVigor;
import com.solegendary.reignofnether.building.GarrisonableBuilding;
import com.solegendary.reignofnether.healthbars.HealthBarClientEvents;
import com.solegendary.reignofnether.hud.PortraitRendererModifiers;
import com.solegendary.reignofnether.hud.RectZone;
import com.solegendary.reignofnether.resources.ResourceSource;
import com.solegendary.reignofnether.resources.ResourceSources;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.unit.Relationship;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.interfaces.WorkerUnit;
import com.solegendary.reignofnether.unit.units.monsters.CreeperUnit;
import com.solegendary.reignofnether.unit.units.monsters.ZombieUnit;
import com.solegendary.reignofnether.unit.units.piglins.BruteUnit;
import com.solegendary.reignofnether.unit.units.piglins.HeadhunterUnit;
import com.solegendary.reignofnether.unit.units.villagers.EvokerUnit;
import com.solegendary.reignofnether.unit.units.villagers.PillagerUnit;
import com.solegendary.reignofnether.unit.units.villagers.VindicatorUnit;
import com.solegendary.reignofnether.util.MiscUtil;
import com.solegendary.reignofnether.util.MyMath;
import com.solegendary.reignofnether.util.MyRenderer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import org.apache.commons.lang3.text.WordUtils;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class PortraitRendererUnit<T extends LivingEntity, M extends EntityModel<T>, R extends LivingEntityRenderer<T, M>> {
    public R renderer;
    public Model model;
    public final int frameWidth = 60;
    public final int frameHeight = 60;
    public final int statsWidth = 45;
    public final int statsHeight = 60;
    private final int size = 46;
    private final int offsetX = 31;
    private final int offsetY = 105;
    private final float standardEyeHeight = 1.74f;
    private int lookX = 0;
    private int lookY = 0;
    private int lastLookTargetX = 0;
    private int lastLookTargetY = 0;
    private int lookTargetX = 0;
    private int lookTargetY = 0;
    private int ticksLeft = 0;
    private final int ticksLeftMin = 30;
    private final int ticksLeftMax = 60;
    private final int lookRangeX = 100;
    private final int lookRangeY = 40;
    public final int HERO_Y_OFFSET = 10;

    public void randomiseAnimation(Boolean randomisePos) {
        if (randomisePos.booleanValue()) {
            this.lookX = MyMath.randRangeInt(-100, 100);
            this.lookY = MyMath.randRangeInt(-40, 40);
        }
        this.ticksLeft = MyMath.randRangeInt(30, 60);
        this.lastLookTargetX = this.lookTargetX;
        this.lastLookTargetY = this.lookTargetY;
        while (Math.abs(this.lookTargetX - this.lookX) < 50) {
            this.lookTargetX = MyMath.randRangeInt(-100, 100);
        }
        while (Math.abs(this.lookTargetY - this.lookY) < 20) {
            this.lookTargetY = MyMath.randRangeInt(-40, 40);
        }
    }

    public void tickAnimation() {
        --this.ticksLeft;
        if (this.ticksLeft <= 0) {
            this.randomiseAnimation(false);
        }
        int lookSpeedX = Math.abs(this.lastLookTargetX - this.lookX) / 20;
        int lookSpeedY = Math.abs(this.lastLookTargetY - this.lookY) / 20;
        if (this.lookX < this.lookTargetX) {
            this.lookX += lookSpeedX;
        }
        if (this.lookX > this.lookTargetX) {
            this.lookX -= lookSpeedX;
        }
        if (this.lookY < this.lookTargetY) {
            this.lookY += lookSpeedY;
        }
        if (this.lookY > this.lookTargetY) {
            this.lookY -= lookSpeedY;
        }
        if (Math.abs(this.lookTargetX - this.lookX) < lookSpeedX) {
            this.lookX = this.lookTargetX;
        }
        if (Math.abs(this.lookTargetY - this.lookY) < lookSpeedY) {
            this.lookY = this.lookTargetY;
        }
    }

    public RectZone render(GuiGraphics guiGraphics, String name, int x, int y, LivingEntity entity) {
        HeroUnit heroUnit;
        Unit unit;
        Unit pUnit;
        HeadhunterUnit hUnit;
        BruteUnit bUnit;
        if (entity instanceof HeroUnit) {
            y -= 10;
        }
        Relationship rs = UnitClientEvents.getPlayerToEntityRelationship(entity);
        int bgCol = 0;
        switch (rs) {
            case OWNED: {
                bgCol = -1879048192;
                break;
            }
            case FRIENDLY: {
                bgCol = -1876942704;
                break;
            }
            case NEUTRAL: {
                bgCol = -1869574144;
                break;
            }
            case HOSTILE: {
                bgCol = -1869611008;
            }
        }
        int frameHeightPlus = 0;
        if (entity instanceof HeroUnit) {
            frameHeightPlus = 10;
        }
        MyRenderer.renderFrameWithBg(guiGraphics, x, y, 60, 60 + frameHeightPlus, bgCol);
        int drawX = x + 31;
        int drawY = y + (int)(entity.m_20192_() / 1.74f * 105.0f);
        int sizeFinal = 46;
        Pair<Integer, Integer> yAndScaleOffsets = PortraitRendererModifiers.getPortraitRendererModifiers(entity);
        drawY += ((Integer)yAndScaleOffsets.getFirst()).intValue();
        sizeFinal += ((Integer)yAndScaleOffsets.getSecond()).intValue();
        boolean hasBanner = false;
        ItemStack bannerStack = entity.m_6844_(EquipmentSlot.HEAD);
        if (bannerStack.m_41720_() instanceof BannerItem) {
            hasBanner = true;
            entity.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
        }
        this.drawEntityOnScreen(guiGraphics.m_280168_(), entity, drawX, drawY, sizeFinal);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 2000.0f);
        name = WordUtils.capitalize((String)name);
        if (entity instanceof BruteUnit && (bUnit = (BruteUnit)entity).hasEnchantedNetheriteSword() || entity instanceof HeadhunterUnit && (hUnit = (HeadhunterUnit)entity).hasFireAspectTrident()) {
            name = (String)name + " (FA)";
        }
        if (entity instanceof VindicatorUnit && ((VindicatorUnit)(pUnit = (VindicatorUnit)entity)).getEnchant() == Enchantments.f_44977_) {
            name = (String)name + " (S)";
        }
        if (entity instanceof VindicatorUnit && ((VindicatorUnit)(pUnit = (VindicatorUnit)entity)).getEnchant() == EnchantMaiming.actualEnchantment) {
            name = (String)name + " (M)";
        }
        if (entity instanceof PillagerUnit && ((PillagerUnit)(pUnit = (PillagerUnit)entity)).getEnchant() == Enchantments.f_44960_) {
            name = (String)name + " (QC)";
        }
        if (entity instanceof PillagerUnit && ((PillagerUnit)(pUnit = (PillagerUnit)entity)).getEnchant() == Enchantments.f_44959_) {
            name = (String)name + " (MS)";
        }
        if (entity instanceof EvokerUnit && ((EvokerUnit)(pUnit = (EvokerUnit)entity)).getEnchant() == EnchantVigor.actualEnchantment) {
            name = (String)name + " (V)";
        }
        if (entity instanceof EvokerUnit && ((EvokerUnit)(pUnit = (EvokerUnit)entity)).getEnchant() == EnchantVigor.actualEnchantment) {
            name = (String)name + " (V)";
        }
        if (entity instanceof ZombieUnit && ((ZombieUnit)(pUnit = (ZombieUnit)entity)).getThornsLevel() > 0) {
            name = (String)name + " (Thorns ";
            for (int i = 0; i < ((ZombieUnit)pUnit).getThornsLevel(); ++i) {
                name = (String)name + "I";
            }
            name = (String)name + ")";
        }
        if (rs != Relationship.OWNED && entity instanceof Unit && (unit = (Unit)entity).getOwnerName().length() > 0) {
            name = (String)name + " (" + unit.getOwnerName() + ")";
        }
        if (entity instanceof HeroUnit) {
            heroUnit = (HeroUnit)entity;
            y -= 6;
        }
        if (!(entity instanceof Player)) {
            guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, (String)name, x + 4, y - 9, -1);
        }
        if (entity instanceof HeroUnit) {
            heroUnit = (HeroUnit)entity;
            y += 14;
        }
        RectZone rectZone = RectZone.getZoneByLW(x, y, 60, 60);
        if (entity instanceof HeroUnit) {
            HeroUnit heroUnit2 = (HeroUnit)entity;
            HealthBarClientEvents.renderForEntity(guiGraphics.m_280168_(), entity, (float)x + 30.0f, y + 60 - 22, 51.0f, HealthBarClientEvents.RenderMode.GUI_PORTRAIT);
            HealthBarClientEvents.renderAbsorbForEntity(guiGraphics.m_280168_(), entity, (float)x + 30.0f, y + 60 - 22, 51.0f, HealthBarClientEvents.RenderMode.GUI_PORTRAIT);
            HealthBarClientEvents.renderManaForEntity(guiGraphics.m_280168_(), heroUnit2, (float)x + 30.0f, y + 60 - 12, 51.0f, HealthBarClientEvents.RenderMode.GUI_PORTRAIT);
        } else {
            HealthBarClientEvents.renderForEntity(guiGraphics.m_280168_(), entity, (float)x + 30.0f, y + 60 - 14, 51.0f, HealthBarClientEvents.RenderMode.GUI_PORTRAIT);
            HealthBarClientEvents.renderAbsorbForEntity(guiGraphics.m_280168_(), entity, (float)x + 30.0f, y + 60 - 14, 51.0f, HealthBarClientEvents.RenderMode.GUI_PORTRAIT);
        }
        ArrayList<String> texts = new ArrayList<String>();
        Object healthText = "";
        float health = entity.m_21223_();
        healthText = health >= 1.0f ? String.valueOf((int)health) : String.valueOf(health += entity.m_6103_()).substring(0, 3);
        float maxHealth = entity.m_21233_();
        if (entity.m_6103_() > 0.0f) {
            maxHealth += MiscUtil.getMaxAbsorptionAmount(entity);
        }
        healthText = (String)healthText + "/" + (int)maxHealth;
        texts.add((String)healthText);
        if (entity instanceof HeroUnit) {
            HeroUnit heroUnit3 = (HeroUnit)entity;
            Object manaText = "";
            float mana = heroUnit3.getMana();
            manaText = mana >= 1.0f ? String.valueOf((int)mana) : String.valueOf(mana).substring(0, 3);
            manaText = (String)manaText + "/" + (int)heroUnit3.getMaxMana();
            texts.add((String)manaText);
        }
        this.renderStatText(texts, entity, x, entity instanceof HeroUnit ? y - 10 + 2 : y, guiGraphics);
        if (hasBanner) {
            entity.m_8061_(EquipmentSlot.HEAD, bannerStack);
        }
        return rectZone;
    }

    private void renderStatText(List<String> texts, LivingEntity entity, int x, int y, GuiGraphics guiGraphics) {
        Minecraft MC = Minecraft.m_91087_();
        Window window = MC.m_91268_();
        MultiBufferSource.BufferSource multibuffersource$buffersource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        for (int i = 0; i < texts.size(); ++i) {
            FormattedCharSequence pTooltips = FormattedCharSequence.m_13714_((String)texts.get(i), (Style)Style.f_131099_);
            ClientTooltipComponent clientTooltip = ClientTooltipComponent.m_169948_((FormattedCharSequence)pTooltips);
            guiGraphics.m_280168_().m_85837_(0.0, 0.0, 400.0);
            int x0 = x + 30;
            int xC = x0 - MC.f_91062_.m_92895_(texts.get(i)) / 2;
            clientTooltip.m_142440_(MC.f_91062_, xC, y + 60 - 2 + (i - 1) * 10, guiGraphics.m_280168_().m_85850_().m_252922_(), multibuffersource$buffersource);
        }
        multibuffersource$buffersource.m_109911_();
        guiGraphics.m_280168_().m_85849_();
    }

    public RectZone renderStats(GuiGraphics guiGraphics, String name, int x, int y, Unit unit) {
        int msInt;
        ArrayList<Object> statStrings;
        ArrayList<ResourceLocation> textureStatIcons;
        int blitYIcon;
        int blitXIcon;
        block15: {
            block14: {
                block13: {
                    int statsHeightPlus = 0;
                    if (unit instanceof HeroUnit) {
                        y -= 10;
                        statsHeightPlus = 10;
                    }
                    MyRenderer.renderFrameWithBg(guiGraphics, x, y, 45, 60 + statsHeightPlus, -1610612736);
                    blitXIcon = x + 6;
                    blitYIcon = y + 7;
                    textureStatIcons = new ArrayList<ResourceLocation>();
                    statStrings = new ArrayList<Object>();
                    if (unit instanceof AttackerUnit) {
                        double atkDmgRounded;
                        CreeperUnit cUnit;
                        AttackerUnit attackerUnit = (AttackerUnit)((Object)unit);
                        textureStatIcons.add(new ResourceLocation("reignofnether", "textures/icons/items/sword.png"));
                        textureStatIcons.add(new ResourceLocation("reignofnether", "textures/icons/items/sparkler.png"));
                        textureStatIcons.add(new ResourceLocation("reignofnether", "textures/icons/items/bow.png"));
                        double atkDmg = (double)attackerUnit.getUnitAttackDamage() + AttackerUnit.getWeaponDamageModifier(attackerUnit);
                        if (unit instanceof CreeperUnit && (cUnit = (CreeperUnit)unit).m_7090_()) {
                            atkDmg *= (double)1.7f;
                        }
                        if (unit instanceof WorkerUnit) {
                            WorkerUnit wUnit = (WorkerUnit)((Object)unit);
                            atkDmg = (int)attackerUnit.getUnitAttackDamage();
                        }
                        if (Math.abs((atkDmgRounded = (double)Math.round(atkDmg)) - atkDmg) < 0.1) {
                            statStrings.add(String.valueOf((int)atkDmgRounded));
                        } else {
                            DecimalFormat df1 = new DecimalFormat("###.#");
                            statStrings.add(String.valueOf(df1.format(atkDmg)));
                        }
                        DecimalFormat df2 = new DecimalFormat("###.##");
                        statStrings.add(String.valueOf(df2.format(attackerUnit.getAttacksPerSecond())));
                        GarrisonableBuilding garr = GarrisonableBuilding.getGarrison(unit);
                        if (garr != null) {
                            statStrings.add(String.valueOf(garr.getAttackRange()));
                        } else {
                            statStrings.add(String.valueOf((int)attackerUnit.getAttackRange()));
                        }
                    }
                    textureStatIcons.add(new ResourceLocation("reignofnether", "textures/icons/items/chestplate.png"));
                    textureStatIcons.add(new ResourceLocation("reignofnether", "textures/icons/items/boots.png"));
                    statStrings.add((int)(unit.getUnitArmorPercentage() * 100.0f) + "%");
                    AttributeInstance ms = ((LivingEntity)unit).m_21051_(Attributes.f_22279_);
                    int n = msInt = ms != null ? (int)(ms.m_22135_() * 101.0) : 0;
                    if (!(unit instanceof BruteUnit)) break block13;
                    BruteUnit pbUnit = (BruteUnit)unit;
                    if (pbUnit.isHoldingUpShield) break block14;
                }
                if (!(unit instanceof Slime)) break block15;
            }
            msInt = (int)((float)msInt * 0.45f);
        }
        statStrings.add(String.valueOf(msInt));
        if (unit instanceof HeroUnit) {
            HeroUnit heroUnit = (HeroUnit)unit;
            int heroLvl = heroUnit.getHeroLevel();
            guiGraphics.m_280648_(Minecraft.m_91087_().f_91062_, MiscUtil.fcs((heroLvl >= 10 ? "Lv " : "Lvl ") + heroLvl, true), blitXIcon + 1, blitYIcon - 1, 0xFFFFFF);
            blitYIcon += 11;
        }
        for (int i = 0; i < statStrings.size(); ++i) {
            MyRenderer.renderIcon(guiGraphics, (ResourceLocation)textureStatIcons.get(i), blitXIcon, blitYIcon, 8);
            guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, (String)statStrings.get(i), blitXIcon + 13, blitYIcon, 0xFFFFFF);
            blitYIcon += 10;
        }
        return RectZone.getZoneByLW(x, y, 45, 60);
    }

    public RectZone renderHeroLevelAndExp(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, HeroUnit heroUnit) {
        int width = 101;
        int height = 5;
        ResourceLocation expBarEmptyRl = new ResourceLocation("reignofnether", "textures/hud/experience_bar_empty.png");
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)expBarEmptyRl);
        guiGraphics.m_280398_(expBarEmptyRl, x, y -= 10, 0, 0.0f, 0.0f, width, height, width, height);
        ResourceLocation expBarFullRl = new ResourceLocation("reignofnether", "textures/hud/experience_bar_full.png");
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)expBarFullRl);
        float expPercent = (float)heroUnit.getExpOnCurrentLevel() / (float)heroUnit.getExpToNextlevel();
        if (heroUnit.getHeroLevel() >= 10) {
            expPercent = 1.0f;
        }
        guiGraphics.m_280398_(expBarFullRl, x, y, 0, 0.0f, 0.0f, Math.round((float)width * expPercent), height, width, height);
        return RectZone.getZoneByLW(x, y - 2, width, height + 4);
    }

    public RectZone renderResourcesHeld(GuiGraphics guiGraphics, int x, int y, Unit unit) {
        Resources resources = Resources.getTotalResourcesFromItems(unit.getItems());
        return this.renderResourcesHeld(guiGraphics, x, y, resources, Unit.atMaxResources(unit));
    }

    public RectZone renderResourcesHeld(GuiGraphics guiGraphics, int x, int y, Animal animal) {
        Resources resources = new Resources("", 0, 0, 0);
        for (ItemStack itemStack : ResourceSources.getFoodItemsFromAnimal(animal)) {
            ResourceSource res = ResourceSources.getFromItem(itemStack.m_41720_());
            if (res == null) continue;
            resources.food += res.resourceValue * itemStack.m_41613_();
        }
        return this.renderResourcesHeld(guiGraphics, x, y, resources, false);
    }

    public RectZone renderResourcesHeld(GuiGraphics guiGraphics, int x, int y, Resources resources, boolean redText) {
        MyRenderer.renderFrameWithBg(guiGraphics, x, y, 45, 60, -1610612736);
        int blitXIcon = x + 6;
        int blitYIcon = y + 7;
        List<ResourceLocation> textureStatIcons = List.of(new ResourceLocation("reignofnether", "textures/icons/items/wheat.png"), new ResourceLocation("reignofnether", "textures/icons/items/wood.png"), new ResourceLocation("reignofnether", "textures/icons/items/iron_ore.png"));
        List<String> statStrings = List.of(String.valueOf(resources.food), String.valueOf(resources.wood), String.valueOf(resources.ore));
        for (int i = 0; i < statStrings.size(); ++i) {
            if (statStrings.get(i).equals("0")) continue;
            MyRenderer.renderIcon(guiGraphics, textureStatIcons.get(i), blitXIcon, blitYIcon, 8);
            guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, statStrings.get(i), blitXIcon + 12, blitYIcon, redText ? 0xFF2525 : 0xFFFFFF);
            blitYIcon += 10;
        }
        return RectZone.getZoneByLW(x, y, 45, 60);
    }

    private void drawEntityOnScreen(PoseStack poseStack, LivingEntity entity, int x, int y, int size) {
        float f = (float)Math.atan((float)(-this.lookX) / 40.0f);
        float g = (float)Math.atan((float)(-this.lookY) / 40.0f);
        PoseStack poseStackModel = RenderSystem.getModelViewStack();
        poseStackModel.m_85836_();
        poseStackModel.m_85837_((double)x, (double)y, 1050.0);
        poseStackModel.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, 10.0);
        poseStack.m_85841_((float)size, (float)size, (float)size);
        Quaternionf quaternion = Axis.f_252403_.m_252977_(180.0f);
        Quaternionf quaternion2 = Axis.f_252529_.m_252977_(g * 20.0f);
        quaternion.mul((Quaternionfc)quaternion2);
        poseStack.m_252781_(quaternion);
        float h = entity.f_20883_;
        float i = entity.m_146908_();
        float j = entity.m_146909_();
        float k = entity.f_20886_;
        float l = entity.f_20885_;
        entity.f_20883_ = 180.0f + f * 20.0f;
        entity.m_146922_(180.0f + f * 40.0f);
        entity.m_146926_(-g * 20.0f);
        entity.f_20885_ = entity.m_146908_();
        entity.f_20886_ = entity.m_146908_();
        Lighting.m_166384_();
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.m_91087_().m_91290_();
        quaternion2.conjugate();
        entityrenderdispatcher.m_114468_(false);
        entityrenderdispatcher.m_252923_(quaternion2);
        RenderSystem.runAsFancy(() -> {
            try {
                MultiBufferSource.BufferSource immediate = Minecraft.m_91087_().m_91269_().m_110104_();
                entityrenderdispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)immediate, 0xF000F0);
                immediate.m_109911_();
            }
            catch (ReportedException reportedException) {
                // empty catch block
            }
        });
        entityrenderdispatcher.m_114468_(true);
        entity.f_20883_ = h;
        entity.m_146922_(i);
        entity.m_146926_(j);
        entity.f_20886_ = k;
        entity.f_20885_ = l;
        poseStackModel.m_85849_();
        poseStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        Lighting.m_84931_();
    }
}

