/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.hud;

import com.solegendary.reignofnether.faction.FactionType;
import com.solegendary.reignofnether.migration.FactionMigrationHelper;
import com.solegendary.reignofnether.mixin.SplashRendererAccessor;
import com.solegendary.reignofnether.util.Faction;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.CubeMap;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TitleClientEvents {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static final Random random = new Random();
    private static Faction titleBackgroundFaction = TitleClientEvents.getRandomFaction();
    private static PanoramaRenderer panorama = new PanoramaRenderer(TitleClientEvents.getCubeMap());
    public static String splash = TitleClientEvents.getRandomSplash();

    public static PanoramaRenderer getPanorama() {
        return panorama;
    }

    private static CubeMap getCubeMap() {
        String dir = "";
        switch (titleBackgroundFaction) {
            case VILLAGERS: {
                dir = "villagers";
                break;
            }
            case MONSTERS: {
                dir = "monsters";
                break;
            }
            case PIGLINS: {
                dir = "piglins";
            }
        }
        return new CubeMap(new ResourceLocation("textures/gui/title/background/" + dir + "/panorama"));
    }

    private static Faction getRandomFaction() {
        FactionType randomFactionType = FactionMigrationHelper.getRandomFaction(random);
        return FactionMigrationHelper.toLegacyFaction(randomFactionType);
    }

    private static Faction getNewRandomFaction() {
        FactionType currentFactionType = FactionMigrationHelper.toFactionType(titleBackgroundFaction);
        FactionType enemyFactionType = FactionMigrationHelper.getRandomEnemyFaction(currentFactionType, random);
        return FactionMigrationHelper.toLegacyFaction(enemyFactionType);
    }

    @SubscribeEvent
    public static void onScreenOpen(ScreenEvent.Opening evt) {
        if (evt.getScreen() instanceof TitleScreen) {
            titleBackgroundFaction = TitleClientEvents.getNewRandomFaction();
            panorama = new PanoramaRenderer(TitleClientEvents.getCubeMap());
        }
    }

    private static String getRandomSplash() {
        return ((SplashRendererAccessor)MC.m_91310_().m_280369_()).getSplash();
    }

    @SubscribeEvent
    public static void onKeyPress(ScreenEvent.KeyPressed.Pre evt) {
        if (evt.getKeyCode() == 32) {
            splash = TitleClientEvents.getRandomSplash();
        }
    }
}

