/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.mapmaker;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;

public abstract class MapmakerCommand {
    public abstract String getCommandName();

    public abstract String getDescription();

    public abstract void registerArguments(CommandDispatcher<CommandSourceStack> var1);

    public abstract int execute(CommandContext<CommandSourceStack> var1);

    protected boolean hasPermission(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (!source.m_230897_()) {
            return true;
        }
        return source.m_230896_() != null && source.m_230896_().m_20310_(4);
    }

    protected void sendError(CommandContext<CommandSourceStack> context, String message) {
        ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("[RTS Mapmaker] " + message)));
    }

    protected void sendSuccess(CommandContext<CommandSourceStack> context, String message) {
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("[RTS Mapmaker] " + message)), false);
    }

    protected ServerLevel getServerLevel(CommandContext<CommandSourceStack> context) {
        return ((CommandSourceStack)context.getSource()).m_81372_();
    }

    protected String getPlayerName(CommandContext<CommandSourceStack> context, String argumentName) {
        return StringArgumentType.getString(context, (String)argumentName);
    }

    protected boolean isValidPlayerName(ServerLevel level, String playerName) {
        if ("all".equals(playerName)) {
            return true;
        }
        return level.m_7654_().m_6846_().m_11255_(playerName) != null;
    }

    protected boolean isValidUnitType(String unitType) {
        String[] validTypes;
        if (unitType == null || unitType.trim().isEmpty()) {
            return false;
        }
        String type = unitType.toLowerCase().trim();
        if (type.equals("all")) {
            return true;
        }
        if (type.equals("villager") || type.equals("piglin") || type.equals("monster")) {
            return true;
        }
        for (String validType : validTypes = new String[]{"militia", "archer", "crossbow", "knight", "irongolem", "piglin", "brute", "hoglin", "ghast", "blaze", "wither", "zombie", "skeleton", "spider", "creeper", "witch", "enderman"}) {
            if (!type.contains(validType) && !validType.contains(type)) continue;
            return true;
        }
        return type.length() >= 3 && type.length() <= 50;
    }

    protected boolean isValidBuildingType(String buildingType) {
        String[] validTypes;
        if (buildingType == null || buildingType.trim().isEmpty()) {
            return false;
        }
        String type = buildingType.toLowerCase().trim();
        if (type.equals("all")) {
            return true;
        }
        if (type.equals("production") || type.equals("military") || type.equals("economic")) {
            return true;
        }
        for (String validType : validTypes = new String[]{"towncentre", "barracks", "blacksmith", "library", "watchtower", "castle", "farm", "stockpile", "house", "bridge", "tower", "portal", "fortress", "bastion", "sanctuary", "stables", "stronghold", "dungeon", "graveyard", "laboratory", "mausoleum"}) {
            if (!type.contains(validType) && !validType.contains(type)) continue;
            return true;
        }
        return type.length() >= 3 && type.length() <= 50;
    }

    protected boolean areCoordinatesValid(ServerLevel level, BlockPos pos) {
        if (pos == null) {
            return false;
        }
        if (!level.m_6857_().m_61937_(pos)) {
            return false;
        }
        return pos.m_123342_() >= level.m_141937_() && pos.m_123342_() <= level.m_151558_();
    }

    protected boolean isAreaValid(BlockPos pos1, BlockPos pos2) {
        if (pos1 == null || pos2 == null) {
            return false;
        }
        int width = Math.abs(pos2.m_123341_() - pos1.m_123341_()) + 1;
        int height = Math.abs(pos2.m_123342_() - pos1.m_123342_()) + 1;
        int depth = Math.abs(pos2.m_123343_() - pos1.m_123343_()) + 1;
        int maxDimension = 1000;
        if (width > maxDimension || height > maxDimension || depth > maxDimension) {
            return false;
        }
        long volume = (long)width * (long)height * (long)depth;
        return volume <= 1000000L;
    }

    protected String sanitizeStringInput(String input) {
        if (input == null) {
            return "";
        }
        return input.replaceAll("[<>\"'&\\\\]", "").trim();
    }

    protected void sendDetailedError(CommandContext<CommandSourceStack> context, String error, String suggestion) {
        this.sendError(context, error);
        if (suggestion != null && !suggestion.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("[RTS Mapmaker] Suggestion: " + suggestion)));
        }
    }
}

