/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.mapmaker.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.buildings.placements.ProductionPlacement;
import com.solegendary.reignofnether.mapmaker.MapmakerCommand;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.AABB;

public class SetBuildingOwnerCommand
extends MapmakerCommand {
    @Override
    public String getCommandName() {
        return "setbuildingowner";
    }

    @Override
    public String getDescription() {
        return "Set building ownership by position, area, or type";
    }

    @Override
    public void registerArguments(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"rts-setbuildingowner").then(Commands.m_82127_((String)"bypos").then(Commands.m_82129_((String)"position", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"newOwner", (ArgumentType)StringArgumentType.string()).executes(this::executeByPosition))))).then(Commands.m_82127_((String)"byarea").then(Commands.m_82129_((String)"pos1", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"pos2", (ArgumentType)BlockPosArgument.m_118239_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"newOwner", (ArgumentType)StringArgumentType.string()).executes(this::executeByArea)).then(Commands.m_82129_((String)"buildingType", (ArgumentType)StringArgumentType.string()).executes(this::executeByAreaAndType))))))).then(Commands.m_82127_((String)"bytype").then(Commands.m_82129_((String)"buildingType", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"newOwner", (ArgumentType)StringArgumentType.string()).executes(this::executeByType))))).then(Commands.m_82127_((String)"byowner").then(Commands.m_82129_((String)"currentOwner", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"newOwner", (ArgumentType)StringArgumentType.string()).executes(this::executeByOwner)).then(Commands.m_82129_((String)"buildingType", (ArgumentType)StringArgumentType.string()).executes(this::executeByOwnerAndType))))));
    }

    @Override
    public int execute(CommandContext<CommandSourceStack> context) {
        return 0;
    }

    private int executeByPosition(CommandContext<CommandSourceStack> context) {
        if (!this.hasPermission(context)) {
            this.sendError(context, "You don't have permission to use mapmaker commands.");
            return 0;
        }
        BlockPos position = BlockPosArgument.m_264582_(context, (String)"position");
        String newOwner = this.getPlayerName(context, "newOwner");
        ServerLevel level = this.getServerLevel(context);
        if (!this.isValidPlayerName(level, newOwner)) {
            this.sendError(context, "Player '" + newOwner + "' not found.");
            return 0;
        }
        BuildingPlacement building = BuildingUtils.findBuilding(false, position);
        if (building == null) {
            this.sendError(context, "No building found at position " + position);
            return 0;
        }
        String oldOwner = building.ownerName;
        building.ownerName = newOwner;
        this.sendSuccess(context, "Changed " + building.getBuilding().name + " ownership from '" + oldOwner + "' to '" + newOwner + "'");
        return 1;
    }

    private int executeByArea(CommandContext<CommandSourceStack> context) {
        return this.executeByAreaInternal(context, "all");
    }

    private int executeByAreaAndType(CommandContext<CommandSourceStack> context) {
        String buildingType = StringArgumentType.getString(context, (String)"buildingType");
        return this.executeByAreaInternal(context, buildingType);
    }

    private int executeByAreaInternal(CommandContext<CommandSourceStack> context, String buildingType) {
        if (!this.hasPermission(context)) {
            this.sendError(context, "You don't have permission to use mapmaker commands.");
            return 0;
        }
        BlockPos pos1 = BlockPosArgument.m_264582_(context, (String)"pos1");
        BlockPos pos2 = BlockPosArgument.m_264582_(context, (String)"pos2");
        String newOwner = this.getPlayerName(context, "newOwner");
        ServerLevel level = this.getServerLevel(context);
        if (!this.isValidPlayerName(level, newOwner)) {
            this.sendError(context, "Player '" + newOwner + "' not found.");
            return 0;
        }
        if (!this.isValidBuildingType(buildingType)) {
            this.sendError(context, "Invalid building type: " + buildingType);
            return 0;
        }
        AABB area = new AABB((double)Math.min(pos1.m_123341_(), pos2.m_123341_()), (double)Math.min(pos1.m_123342_(), pos2.m_123342_()), (double)Math.min(pos1.m_123343_(), pos2.m_123343_()), (double)(Math.max(pos1.m_123341_(), pos2.m_123341_()) + 1), (double)(Math.max(pos1.m_123342_(), pos2.m_123342_()) + 1), (double)(Math.max(pos1.m_123343_(), pos2.m_123343_()) + 1));
        List<BuildingPlacement> buildingsInArea = BuildingServerEvents.getBuildings().stream().filter(building -> area.m_82393_((double)building.centrePos.m_123341_(), (double)building.centrePos.m_123342_(), (double)building.centrePos.m_123343_())).filter(building -> buildingType.equals("all") || this.matchesBuildingType((BuildingPlacement)building, buildingType)).toList();
        if (buildingsInArea.isEmpty()) {
            this.sendError(context, "No buildings found in the specified area" + (String)(buildingType.equals("all") ? "" : " matching type '" + buildingType + "'"));
            return 0;
        }
        int changedCount = 0;
        for (BuildingPlacement building2 : buildingsInArea) {
            building2.ownerName = newOwner;
            ++changedCount;
        }
        this.sendSuccess(context, "Changed ownership of " + changedCount + " buildings to '" + newOwner + "'");
        return 1;
    }

    private int executeByType(CommandContext<CommandSourceStack> context) {
        if (!this.hasPermission(context)) {
            this.sendError(context, "You don't have permission to use mapmaker commands.");
            return 0;
        }
        String buildingType = StringArgumentType.getString(context, (String)"buildingType");
        String newOwner = this.getPlayerName(context, "newOwner");
        ServerLevel level = this.getServerLevel(context);
        if (!this.isValidPlayerName(level, newOwner)) {
            this.sendError(context, "Player '" + newOwner + "' not found.");
            return 0;
        }
        if (!this.isValidBuildingType(buildingType)) {
            this.sendError(context, "Invalid building type: " + buildingType);
            return 0;
        }
        List<BuildingPlacement> matchingBuildings = BuildingServerEvents.getBuildings().stream().filter(building -> buildingType.equals("all") || this.matchesBuildingType((BuildingPlacement)building, buildingType)).toList();
        if (matchingBuildings.isEmpty()) {
            this.sendError(context, "No buildings found matching type '" + buildingType + "'");
            return 0;
        }
        int changedCount = 0;
        for (BuildingPlacement building2 : matchingBuildings) {
            building2.ownerName = newOwner;
            ++changedCount;
        }
        this.sendSuccess(context, "Changed ownership of " + changedCount + " buildings (type: " + buildingType + ") to '" + newOwner + "'");
        return 1;
    }

    private int executeByOwner(CommandContext<CommandSourceStack> context) {
        return this.executeByOwnerInternal(context, "all");
    }

    private int executeByOwnerAndType(CommandContext<CommandSourceStack> context) {
        String buildingType = StringArgumentType.getString(context, (String)"buildingType");
        return this.executeByOwnerInternal(context, buildingType);
    }

    private int executeByOwnerInternal(CommandContext<CommandSourceStack> context, String buildingType) {
        if (!this.hasPermission(context)) {
            this.sendError(context, "You don't have permission to use mapmaker commands.");
            return 0;
        }
        String currentOwner = this.getPlayerName(context, "currentOwner");
        String newOwner = this.getPlayerName(context, "newOwner");
        ServerLevel level = this.getServerLevel(context);
        if (!this.isValidPlayerName(level, newOwner)) {
            this.sendError(context, "Player '" + newOwner + "' not found.");
            return 0;
        }
        if (!this.isValidBuildingType(buildingType)) {
            this.sendError(context, "Invalid building type: " + buildingType);
            return 0;
        }
        List<BuildingPlacement> matchingBuildings = BuildingServerEvents.getBuildings().stream().filter(building -> currentOwner.equals("all") || building.ownerName.equals(currentOwner)).filter(building -> buildingType.equals("all") || this.matchesBuildingType((BuildingPlacement)building, buildingType)).toList();
        if (matchingBuildings.isEmpty()) {
            Object message = "No buildings found";
            if (!currentOwner.equals("all")) {
                message = (String)message + " owned by " + currentOwner;
            }
            if (!buildingType.equals("all")) {
                message = (String)message + " of type " + buildingType;
            }
            this.sendError(context, (String)message);
            return 0;
        }
        int changedCount = 0;
        for (BuildingPlacement building2 : matchingBuildings) {
            building2.ownerName = newOwner;
            ++changedCount;
        }
        String message = "Changed ownership of " + changedCount + " buildings to '" + newOwner + "'";
        if (!currentOwner.equals("all")) {
            message = message + " (previously owned by " + currentOwner + ")";
        }
        if (!buildingType.equals("all")) {
            message = message + " (type: " + buildingType + ")";
        }
        this.sendSuccess(context, message);
        return 1;
    }

    private boolean matchesBuildingType(BuildingPlacement building, String buildingType) {
        String searchType;
        if (buildingType.equals("all")) {
            return true;
        }
        String buildingName = building.getBuilding().name.toLowerCase();
        if (buildingName.contains(searchType = buildingType.toLowerCase())) {
            return true;
        }
        if (searchType.equals("production") && building instanceof ProductionPlacement) {
            return true;
        }
        if (searchType.equals("military") && (buildingName.contains("barracks") || buildingName.contains("fortress") || buildingName.contains("watchtower") || buildingName.contains("tower"))) {
            return true;
        }
        return searchType.equals("economic") && (buildingName.contains("farm") || buildingName.contains("stockpile") || buildingName.contains("mine") || buildingName.contains("centre"));
    }
}

