/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.mapmaker.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.solegendary.reignofnether.mapmaker.MapmakerCommand;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameType;

public class WinCommand
extends MapmakerCommand {
    @Override
    public String getCommandName() {
        return "win";
    }

    @Override
    public String getDescription() {
        return "Trigger win condition for specified player(s)";
    }

    @Override
    public void registerArguments(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"rts-win").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.string()).executes(this::executeWithDefaultMessage)).then(Commands.m_82129_((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(this::executeWithCustomMessage))));
    }

    @Override
    public int execute(CommandContext<CommandSourceStack> context) {
        return this.executeWithDefaultMessage(context);
    }

    private int executeWithDefaultMessage(CommandContext<CommandSourceStack> context) {
        return this.executeInternal(context, null);
    }

    private int executeWithCustomMessage(CommandContext<CommandSourceStack> context) {
        String customMessage = StringArgumentType.getString(context, (String)"message");
        return this.executeInternal(context, customMessage);
    }

    private int executeInternal(CommandContext<CommandSourceStack> context, String customMessage) {
        if (!this.hasPermission(context)) {
            this.sendError(context, "You don't have permission to use mapmaker commands.");
            return 0;
        }
        String playerName = this.getPlayerName(context, "player");
        ServerLevel level = this.getServerLevel(context);
        if (playerName.equals("all")) {
            this.triggerWinForAllPlayers(level, customMessage);
            this.sendSuccess(context, "Triggered win condition for all players");
        } else {
            if (!this.isValidPlayerName(level, playerName)) {
                this.sendError(context, "Player '" + playerName + "' not found.");
                return 0;
            }
            this.triggerWinForPlayer(level, playerName, customMessage);
            this.sendSuccess(context, "Triggered win condition for player '" + playerName + "'");
        }
        return 1;
    }

    private void triggerWinForPlayer(ServerLevel level, String playerName, String customMessage) {
        ServerPlayer player = level.m_7654_().m_6846_().m_11255_(playerName);
        if (player == null) {
            return;
        }
        player.m_143403_(GameType.CREATIVE);
        String message = customMessage != null ? customMessage : "\u00a76Victory! You have won the scenario!";
        player.m_213846_((Component)Component.m_237113_((String)""));
        player.m_213846_((Component)Component.m_237113_((String)"\u00a76============================="));
        player.m_213846_((Component)Component.m_237113_((String)message));
        player.m_213846_((Component)Component.m_237113_((String)"\u00a76============================="));
        player.m_213846_((Component)Component.m_237113_((String)""));
        String announcement = customMessage != null ? "\u00a7e" + playerName + " has won! " + customMessage : "\u00a7e" + playerName + " has achieved victory!";
        for (ServerPlayer allPlayer : level.m_7654_().m_6846_().m_11314_()) {
            if (allPlayer.equals((Object)player)) continue;
            allPlayer.m_213846_((Component)Component.m_237113_((String)announcement));
        }
    }

    private void triggerWinForAllPlayers(ServerLevel level, String customMessage) {
        String message = customMessage != null ? customMessage : "\u00a76Victory! All players have won the scenario!";
        for (ServerPlayer player : level.m_7654_().m_6846_().m_11314_()) {
            player.m_143403_(GameType.CREATIVE);
            player.m_213846_((Component)Component.m_237113_((String)""));
            player.m_213846_((Component)Component.m_237113_((String)"\u00a76============================="));
            player.m_213846_((Component)Component.m_237113_((String)message));
            player.m_213846_((Component)Component.m_237113_((String)"\u00a76============================="));
            player.m_213846_((Component)Component.m_237113_((String)""));
        }
    }
}

