/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.minimap;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import com.solegendary.reignofnether.alliance.AlliancesClient;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.RangeIndicator;
import com.solegendary.reignofnether.building.buildings.placements.BridgePlacement;
import com.solegendary.reignofnether.cursor.CursorClientEvents;
import com.solegendary.reignofnether.fogofwar.FogOfWarClientEvents;
import com.solegendary.reignofnether.fogofwar2.FogManager;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.orthoview.OrthoviewClientEvents;
import com.solegendary.reignofnether.player.PlayerClientEvents;
import com.solegendary.reignofnether.player.PlayerServerboundPacket;
import com.solegendary.reignofnether.startpos.StartPos;
import com.solegendary.reignofnether.startpos.StartPosClientEvents;
import com.solegendary.reignofnether.time.NightCircleMode;
import com.solegendary.reignofnether.time.TimeClientEvents;
import com.solegendary.reignofnether.tutorial.TutorialClientEvents;
import com.solegendary.reignofnether.tutorial.TutorialStage;
import com.solegendary.reignofnether.unit.Relationship;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.util.Faction;
import com.solegendary.reignofnether.util.MiscUtil;
import com.solegendary.reignofnether.util.MyMath;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.joml.Matrix4f;
import org.joml.Vector3d;

public class MinimapClientEvents {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static int worldRadius = 100;
    private static int mapGuiRadius = 50;
    private static int refreshTicks = 0;
    public static final int CORNER_OFFSET = 10;
    public static final int BG_OFFSET = 6;
    private static boolean largeMap = false;
    private static boolean shouldToggleSize = false;
    private static final int UNIT_RADIUS = 3;
    private static final int UNIT_THICKNESS = 1;
    private static final int PLAYER_RADIUS = 5;
    private static final int PLAYER_THICKNESS = 1;
    private static final int BUILDING_RADIUS = 7;
    private static final int BUILDING_THICKNESS = 2;
    private static final int START_POS_RADIUS = 7;
    private static final int START_POS_THICKNESS = 2;
    private static long lastDragTeleportTimestamp = System.currentTimeMillis();
    private static DynamicTexture mapTexture = new DynamicTexture(worldRadius * 2, worldRadius * 2, true);
    private static RenderType mapRenderType = RenderType.m_110500_((ResourceLocation)Minecraft.m_91087_().f_90987_.m_118490_("reignofnether_minimap", mapTexture));
    private static int[][] mapColoursTerrain = new int[worldRadius * 2][worldRadius * 2];
    private static int[][] mapColoursOverlays = new int[worldRadius * 2][worldRadius * 2];
    private static int terrainPartition = 1;
    private static final int TERRAIN_PARTITIONS_MAX = 10;
    private static int darkTerrainPartition = 1;
    private static final int DARK_TERRAIN_PARTITIONS_MAX = 5;
    private static boolean forceUpdateAllPartitions = true;
    private static int xc_world = 0;
    private static int zc_world = 0;
    private static float xl;
    private static float xc;
    private static float xr;
    private static float yt;
    private static float yc;
    private static float yb;
    public static final ArrayList<MinimapUnit> minimapUnits;
    private static final float DARK = 0.4f;
    private static final float EXTRA_DARK = 0.1f;
    private static boolean lockedMap;

    public static boolean isLargeMap() {
        return largeMap;
    }

    public static void removeMinimapUnit(int id) {
        minimapUnits.removeIf(u -> u.id == id);
    }

    public static void syncMinimapUnits(BlockPos pos, int id, String ownerName) {
        for (MinimapUnit unit : minimapUnits) {
            if (unit.id != id) continue;
            unit.pos = pos;
            return;
        }
        minimapUnits.add(new MinimapUnit(pos, id, ownerName));
    }

    public static void setMapCentre(double x, double z) {
        if (!lockedMap) {
            xc_world = (int)x;
            zc_world = (int)z;
        }
    }

    public static int getMapGuiRadius() {
        return mapGuiRadius;
    }

    private static void toggleMapSize() {
        boolean bl = largeMap = !largeMap;
        if (largeMap) {
            worldRadius = 240;
            mapGuiRadius = 120;
        } else {
            worldRadius = 120;
            mapGuiRadius = 60;
        }
        mapTexture = new DynamicTexture(worldRadius * 2, worldRadius * 2, true);
        mapRenderType = RenderType.m_110500_((ResourceLocation)Minecraft.m_91087_().f_90987_.m_118490_("reignofnether_minimap", mapTexture));
        mapColoursTerrain = new int[worldRadius * 2][worldRadius * 2];
        mapColoursOverlays = new int[worldRadius * 2][worldRadius * 2];
        forceUpdateAllPartitions = true;
    }

    public static Button getToggleSizeButton() {
        return new Button(largeMap ? "Close" : "Open large map", 14, largeMap ? new ResourceLocation("reignofnether", "textures/icons/items/barrier.png") : new ResourceLocation("reignofnether", "textures/icons/items/map.png"), new ResourceLocation("reignofnether", "textures/hud/icon_frame.png"), Keybindings.keyM, () -> false, () -> !TutorialClientEvents.isAtOrPastStage(TutorialStage.MINIMAP_CLICK), () -> true, () -> {
            shouldToggleSize = true;
        }, null, List.of(FormattedCharSequence.m_13714_((String)(largeMap ? I18n.m_118938_((String)"hud.map.reignofnether.close", (Object[])new Object[0]) : I18n.m_118938_((String)"hud.map.reignofnether.open", (Object[])new Object[0])), (Style)Style.f_131099_)));
    }

    public static Button getCamSensitivityButton() {
        return new Button("Camera Sensitivity", 14, new ResourceLocation("reignofnether", "textures/icons/blocks/command_block_front.png"), new ResourceLocation("reignofnether", "textures/hud/icon_frame.png"), null, () -> false, () -> !TutorialClientEvents.isAtOrPastStage(TutorialStage.MINIMAP_CLICK) || !largeMap, () -> true, () -> OrthoviewClientEvents.adjustPanSensitivityMult(true), () -> OrthoviewClientEvents.adjustPanSensitivityMult(false), List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"hud.map.reignofnether.pan_sensitivity.tooltip1", (Object[])new Object[]{Math.round(OrthoviewClientEvents.getPanSensitivityMult() * 10.0f), Math.round(OrthoviewClientEvents.getMaxPanSensitivity() * 10.0f)}), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"hud.map.reignofnether.pan_sensitivity.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_)));
    }

    public static Button getNightCirclesModeButton() {
        return new Button("Night Circles Mode", 14, new ResourceLocation("reignofnether", "textures/icons/blocks/repeating_command_block_front.png"), new ResourceLocation("reignofnether", "textures/hud/icon_frame.png"), null, () -> false, () -> !TutorialClientEvents.isAtOrPastStage(TutorialStage.MINIMAP_CLICK) || !largeMap, () -> true, () -> {
            if (TimeClientEvents.nightCircleMode == NightCircleMode.ALL) {
                TimeClientEvents.nightCircleMode = NightCircleMode.NO_OVERLAPS;
            } else if (TimeClientEvents.nightCircleMode == NightCircleMode.NO_OVERLAPS) {
                TimeClientEvents.nightCircleMode = NightCircleMode.OFF;
            } else if (TimeClientEvents.nightCircleMode == NightCircleMode.OFF) {
                TimeClientEvents.nightCircleMode = NightCircleMode.ALL;
            }
            for (BuildingPlacement building : BuildingClientEvents.getBuildings()) {
                if (!(building instanceof RangeIndicator)) continue;
                RangeIndicator ri = (RangeIndicator)((Object)building);
                ri.updateBorderBps();
            }
        }, null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"time.reignofnether.night_circles", (Object[])new Object[]{TimeClientEvents.getNightCircleModeName()}), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"time.reignofnether.night_circle_change", (Object[])new Object[0]), (Style)Style.f_131099_)));
    }

    public static Button getMapLockButton() {
        return new Button("Lock Map", 14, new ResourceLocation("reignofnether", "textures/icons/blocks/chain_command_block_front.png"), new ResourceLocation("reignofnether", "textures/hud/icon_frame.png"), null, () -> false, () -> !TutorialClientEvents.isAtOrPastStage(TutorialStage.MINIMAP_CLICK) || !largeMap, () -> true, () -> {
            boolean bl = lockedMap = !lockedMap;
            if (!lockedMap && MinimapClientEvents.MC.f_91074_ != null) {
                MinimapClientEvents.setMapCentre(MinimapClientEvents.MC.f_91074_.m_20185_(), MinimapClientEvents.MC.f_91074_.m_20189_());
            }
        }, null, List.of(FormattedCharSequence.m_13714_((String)(lockedMap ? I18n.m_118938_((String)"hud.map.reignofnether.lock_map.tooltip1.enabled", (Object[])new Object[0]) : I18n.m_118938_((String)"hud.map.reignofnether.lock_map.tooltip1.disabled", (Object[])new Object[0])), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"hud.map.reignofnether.lock_map.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_)));
    }

    public static Button getCameraRotateCWButton() {
        return new Button("Rotate camera clockwise", 14, new ResourceLocation("reignofnether", "textures/hud/rotate_cw.png"), new ResourceLocation("reignofnether", "textures/hud/icon_frame.png"), Keybindings.rotCW, () -> false, () -> !Keybindings.altMod.isDown() && !MinimapClientEvents.isLargeMap(), () -> Keybindings.altMod.isDown() || MinimapClientEvents.isLargeMap(), () -> OrthoviewClientEvents.fixedRotateCam(true), null, List.of(MiscUtil.fcs(I18n.m_118938_((String)"hud.map.reignofnether.rotate_cw.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"hud.map.reignofnether.rotate_cw.tooltip2", (Object[])new Object[0]))));
    }

    public static Button getCameraRotateCCWButton() {
        return new Button("Rotate camera counter-clockwise", 14, new ResourceLocation("reignofnether", "textures/hud/rotate_ccw.png"), new ResourceLocation("reignofnether", "textures/hud/icon_frame.png"), Keybindings.rotCCW, () -> false, () -> !Keybindings.altMod.isDown() && !MinimapClientEvents.isLargeMap(), () -> Keybindings.altMod.isDown() || MinimapClientEvents.isLargeMap(), () -> OrthoviewClientEvents.fixedRotateCam(false), null, List.of(MiscUtil.fcs(I18n.m_118938_((String)"hud.map.reignofnether.rotate_ccw.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"hud.map.reignofnether.rotate_ccw.tooltip2", (Object[])new Object[0]))));
    }

    public static void updateMapTexture() {
        NativeImage pixels;
        if (MinimapClientEvents.MC.f_91074_ == null) {
            return;
        }
        double xCam = MinimapClientEvents.MC.f_91074_.m_20185_();
        double zCam = MinimapClientEvents.MC.f_91074_.m_20189_();
        double xDiff1 = xCam - (double)(xc_world + worldRadius);
        if (!lockedMap) {
            double zDiff2;
            double xDiff2;
            double zDiff1;
            if (xDiff1 > 0.0) {
                xc_world = (int)((double)xc_world + xDiff1);
            }
            if ((zDiff1 = zCam - (double)(zc_world + worldRadius)) > 0.0) {
                zc_world = (int)((double)zc_world + zDiff1);
            }
            if ((xDiff2 = xCam - (double)(xc_world - worldRadius)) < 0.0) {
                xc_world = (int)((double)xc_world + xDiff2);
            }
            if ((zDiff2 = zCam - (double)(zc_world - worldRadius)) < 0.0) {
                zc_world = (int)((double)zc_world + zDiff2);
            }
        }
        if ((pixels = mapTexture.m_117991_()) != null) {
            int i = 0;
            for (int z = 0; z < worldRadius * 2; ++z) {
                for (int x = 0; x < worldRadius * 2; ++x) {
                    if (mapColoursOverlays[x][z] != 0) {
                        pixels.m_84988_(x, z, mapColoursOverlays[x][z]);
                    } else {
                        pixels.m_84988_(x, z, mapColoursTerrain[x][z]);
                    }
                    ++i;
                }
            }
            mapTexture.m_117985_();
        }
    }

    private static void updateMapTerrain(int partition, int darkPartition) {
        if (MinimapClientEvents.MC.f_91073_ == null || MinimapClientEvents.MC.f_91074_ == null) {
            return;
        }
        int zMin = zc_world - worldRadius;
        int zMax = zc_world + worldRadius;
        int xMin = xc_world - worldRadius;
        int xMax = xc_world + worldRadius;
        Set<ChunkPos> brightChunks = FogOfWarClientEvents.brightChunks;
        for (int z = zMin; z < zMax; ++z) {
            boolean skipDarkPartition = false;
            if (!forceUpdateAllPartitions) {
                int zMaxN = zMax - zMin;
                int zPartMin = zMaxN / 10 * (partition - 1);
                int zPartMax = zMaxN / 10 * partition;
                int zN = z - zMin;
                if (zN < zPartMin || zN >= zPartMax) continue;
                int zPartMind = zMaxN / 5 * (darkPartition - 1);
                int zPartMaxd = zMaxN / 5 * darkPartition;
                if (zN < zPartMind || zN >= zPartMaxd) {
                    skipDarkPartition = true;
                }
            }
            for (int x = xMin; x < xMax; ++x) {
                BlockState bs;
                boolean isBright = false;
                if (FogManager.isEnabled()) {
                    ChunkPos chunkPos = new ChunkPos(x >> 4, z >> 4);
                    isBright = FogManager.isChunkVisible(chunkPos);
                    if (!isBright && skipDarkPartition) {
                        continue;
                    }
                } else if (FogOfWarClientEvents.isEnabled()) {
                    for (ChunkPos chunkPos : brightChunks) {
                        if (x < chunkPos.m_45604_() || x > chunkPos.m_45608_() || z < chunkPos.m_45605_() || z > chunkPos.m_45609_()) continue;
                        isBright = true;
                        break;
                    }
                    if (!isBright && skipDarkPartition) continue;
                }
                int y = MinimapClientEvents.MC.f_91073_.m_46745_(new BlockPos(x, 0, z)).m_5885_(Heightmap.Types.WORLD_SURFACE, x, z);
                while (true) {
                    if ((bs = MinimapClientEvents.MC.f_91073_.m_8055_(new BlockPos(x, y, z))).m_60734_() instanceof SnowLayerBlock) {
                        int layers = (Integer)bs.m_61143_((Property)SnowLayerBlock.f_56581_);
                        y += (int)((float)layers * 0.125f);
                        break;
                    }
                    if (bs.m_280296_() || !bs.m_60819_().m_76178_() || y <= 0) break;
                    --y;
                }
                int yNorth = MinimapClientEvents.MC.f_91073_.m_46745_(new BlockPos(x, 0, z - 1)).m_5885_(Heightmap.Types.WORLD_SURFACE, x, z - 1);
                while (true) {
                    BlockState bsNorth;
                    if ((bsNorth = MinimapClientEvents.MC.f_91073_.m_8055_(new BlockPos(x, yNorth, z - 1))).m_60734_() instanceof SnowLayerBlock) {
                        int layersNorth = (Integer)bsNorth.m_61143_((Property)SnowLayerBlock.f_56581_);
                        yNorth += (int)((float)layersNorth * 0.125f);
                        break;
                    }
                    if (bsNorth.m_280296_() || !bsNorth.m_60819_().m_76178_() || yNorth <= 0) break;
                    --yNorth;
                }
                MapColor mat = MinimapClientEvents.MC.f_91073_.m_8055_(new BlockPos(x, yNorth, z - 1)).m_284242_((BlockGetter)MinimapClientEvents.MC.f_91073_, new BlockPos(x, yNorth, z - 1));
                int rgb = mat.f_283871_;
                if (bs.m_60734_() instanceof SnowLayerBlock) {
                    rgb = 0xFFFFFF;
                }
                if (MinimapClientEvents.MC.f_91073_.m_8055_(new BlockPos(x, yNorth, z - 1)).m_60819_().m_76178_()) {
                    if (yNorth > y) {
                        rgb = MiscUtil.shadeHexRGB(rgb, 0.82f);
                    } else if (yNorth < y) {
                        rgb = MiscUtil.shadeHexRGB(rgb, 1.16f);
                    }
                } else {
                    BlockState matBelow;
                    int depth = 0;
                    int depthMax = 20;
                    while (!(matBelow = MinimapClientEvents.MC.f_91073_.m_8055_(new BlockPos(x, y - ++depth, z))).m_60819_().m_76178_() && depth < depthMax) {
                    }
                    depth = (int)(5.0 * Math.ceil(Math.abs(depth / 5)));
                    rgb = MiscUtil.shadeHexRGB(rgb, 1.2f - 0.025f * (float)depth);
                }
                int x0 = x - xc_world + worldRadius;
                int z0 = z - zc_world + worldRadius;
                BlockPos pos = new BlockPos(x, 0, z);
                if (!MinimapClientEvents.MC.f_91073_.m_6857_().m_61937_(pos)) {
                    rgb = MiscUtil.shadeHexRGB(rgb, 0.1f);
                } else if (FogManager.isEnabled()) {
                    float brightness = FogManager.getPositionBrightness(pos);
                    if (brightness <= 0.1f) {
                        rgb = MiscUtil.shadeHexRGB(rgb, 0.1f);
                    } else if (brightness <= 0.35f) {
                        rgb = MiscUtil.shadeHexRGB(rgb, 0.4f);
                    }
                } else if (FogOfWarClientEvents.isEnabled() && !FogOfWarClientEvents.isInBrightChunk(pos)) {
                    rgb = MiscUtil.shadeHexRGB(rgb, 0.4f);
                }
                MinimapClientEvents.mapColoursTerrain[x0][z0] = MiscUtil.reverseHexRGB(rgb) | 0xFF000000;
            }
        }
        forceUpdateAllPartitions = false;
    }

    private static void updateMapViewQuad() {
        if (MinimapClientEvents.MC.f_91073_ == null || MinimapClientEvents.MC.f_91074_ == null) {
            return;
        }
        int yOffset = 0;
        Vector3d tl = MiscUtil.screenPosToWorldPos(MC, 0, -yOffset);
        Vector3d bl = MiscUtil.screenPosToWorldPos(MC, 0, MC.m_91268_().m_85446_() - yOffset);
        Vector3d br = MiscUtil.screenPosToWorldPos(MC, MC.m_91268_().m_85445_(), MC.m_91268_().m_85446_() - yOffset);
        Vector3d tr = MiscUtil.screenPosToWorldPos(MC, MC.m_91268_().m_85445_(), -yOffset);
        Vector3d[] corners = new Vector3d[]{tl, bl, br, tr};
        Vector3d lookVector = MiscUtil.getPlayerLookVector(MC);
        corners[0] = MyMath.addVector3d(corners[0], lookVector, 90.0f - OrthoviewClientEvents.getCamRotY());
        corners[1] = MyMath.addVector3d(corners[1], lookVector, 75.0f - OrthoviewClientEvents.getCamRotY());
        corners[2] = MyMath.addVector3d(corners[2], lookVector, 75.0f - OrthoviewClientEvents.getCamRotY());
        corners[3] = MyMath.addVector3d(corners[3], lookVector, 90.0f - OrthoviewClientEvents.getCamRotY());
        int zMin = zc_world - worldRadius;
        int zMax = zc_world + worldRadius;
        int xMin = xc_world - worldRadius;
        int xMax = xc_world + worldRadius;
        for (int z = zMin; z < zMax; ++z) {
            block1: for (int x = xMin; x < xMax; ++x) {
                for (int i = 0; i < corners.length; ++i) {
                    int j = i + 1;
                    if (j >= corners.length) {
                        j = 0;
                    }
                    if (!MyMath.isPointOnLine(new Vec2((float)corners[i].x, (float)corners[i].z), new Vec2((float)corners[j].x, (float)corners[j].z), new Vec2((float)x, (float)z), OrthoviewClientEvents.getZoom() * 2.0f)) continue;
                    int x0 = x - xc_world + worldRadius;
                    int z0 = z - zc_world + worldRadius;
                    MinimapClientEvents.mapColoursOverlays[x0][z0] = -1;
                    continue block1;
                }
            }
        }
    }

    private static void updateNightCircles() {
        ArrayList<Pair<BlockPos, Integer>> nightSources = new ArrayList<Pair<BlockPos, Integer>>();
        for (Pair<BlockPos, Integer> pair : TimeClientEvents.nightSourceOrigins) {
            int xc = ((BlockPos)pair.getFirst()).m_123341_() + 3;
            int zc = ((BlockPos)pair.getFirst()).m_123343_() + 3;
            int xN = xc - xc_world + mapGuiRadius * 2;
            int zN = zc - zc_world + mapGuiRadius * 2;
            nightSources.add((Pair<BlockPos, Integer>)new Pair((Object)new BlockPos(xN, 0, zN), (Object)((Integer)pair.getSecond())));
        }
        for (Pair pair : nightSources) {
            Set<BlockPos> nightCircleBps = TimeClientEvents.nightCircleMode == NightCircleMode.NO_OVERLAPS ? MiscUtil.CircleUtil.getCircleWithCulledOverlaps((BlockPos)pair.getFirst(), (Integer)pair.getSecond(), nightSources) : MiscUtil.CircleUtil.getCircle((BlockPos)pair.getFirst(), (Integer)pair.getSecond());
            ArrayList<BlockPos> nightCircleBpsThick = new ArrayList<BlockPos>();
            for (BlockPos bp : nightCircleBps) {
                nightCircleBpsThick.add(bp);
                nightCircleBpsThick.add(bp.m_7918_(-1, 0, 0));
                nightCircleBpsThick.add(bp.m_7918_(0, 0, -1));
            }
            for (BlockPos bp : nightCircleBpsThick) {
                if (bp.m_123341_() <= 0 || bp.m_123341_() >= mapColoursOverlays.length || bp.m_123343_() <= 0 || bp.m_123343_() >= mapColoursOverlays[0].length) continue;
                MinimapClientEvents.mapColoursOverlays[bp.m_123341_()][bp.m_123343_()] = MiscUtil.reverseHexRGB(0) | 0xFF000000;
            }
        }
    }

    private static void updateMapUnitsAndBuildings() {
        for (BuildingPlacement building : BuildingClientEvents.getBuildings()) {
            if (!building.isExploredClientside || building instanceof BridgePlacement) continue;
            int xc = building.centrePos.m_123341_() + 3;
            int zc = building.centrePos.m_123343_() + 3;
            for (int x = xc - 7; x < xc + 7; ++x) {
                for (int z = zc - 7; z < zc + 7; ++z) {
                    if (!MinimapClientEvents.isWorldXZinsideMap(x, z)) continue;
                    int x0 = x - xc + 7;
                    int z0 = z - zc + 7;
                    int rgb = 0;
                    if (x0 >= 2 && x0 < 12 && z0 >= 2 && z0 < 12) {
                        float brightness;
                        boolean buildingVisible = false;
                        buildingVisible = FogManager.isEnabled() ? (brightness = FogManager.getPositionBrightness(building.centrePos)) > 0.35f : (FogOfWarClientEvents.isEnabled() ? FogOfWarClientEvents.isBuildingInBrightChunk(building) : true);
                        if (buildingVisible) {
                            switch (BuildingClientEvents.getPlayerToBuildingRelationship(building)) {
                                case OWNED: {
                                    rgb = 65280;
                                    break;
                                }
                                case FRIENDLY: {
                                    rgb = 0x3232FF;
                                    break;
                                }
                                case HOSTILE: {
                                    rgb = 0xFF0000;
                                    break;
                                }
                                case NEUTRAL: {
                                    rgb = 0xFFFF00;
                                }
                            }
                        } else {
                            switch (BuildingClientEvents.getPlayerToBuildingRelationship(building)) {
                                case OWNED: {
                                    rgb = 34816;
                                    break;
                                }
                                case FRIENDLY: {
                                    rgb = 170;
                                    break;
                                }
                                case HOSTILE: {
                                    rgb = 0x880000;
                                    break;
                                }
                                case NEUTRAL: {
                                    rgb = 0x888800;
                                }
                            }
                        }
                    }
                    int xN = x - xc_world + mapGuiRadius * 2;
                    int zN = z - zc_world + mapGuiRadius * 2;
                    MinimapClientEvents.mapColoursOverlays[xN][zN] = MiscUtil.reverseHexRGB(rgb) | 0xFF000000;
                }
            }
        }
        if (MinimapClientEvents.MC.f_91073_ != null && StartPosClientEvents.isEnabled() && !StartPosClientEvents.isStarting && !PlayerClientEvents.rtsLocked) {
            MinimapClientEvents.drawStartingPosesOnMap();
        }
        if (MinimapClientEvents.MC.f_91073_ != null) {
            for (Player player : MinimapClientEvents.MC.f_91073_.m_6907_()) {
                boolean playerVisible = true;
                if (FogManager.isEnabled()) {
                    float brightness = FogManager.getPositionBrightness(player.m_20097_());
                    playerVisible = brightness > 0.35f;
                } else if (FogOfWarClientEvents.isEnabled()) {
                    playerVisible = FogOfWarClientEvents.isInBrightChunk((Entity)player);
                }
                if (!playerVisible) continue;
                MinimapClientEvents.drawPlayerOnMap(player.m_20097_().m_123341_(), player.m_20097_().m_123343_(), player);
            }
        }
        for (LivingEntity entity : UnitClientEvents.getAllUnits()) {
            boolean unitVisible = true;
            if (FogManager.isEnabled()) {
                float brightness = FogManager.getPositionBrightness(entity.m_20097_());
                unitVisible = brightness > 0.35f;
            } else if (FogOfWarClientEvents.isEnabled()) {
                unitVisible = FogOfWarClientEvents.isInBrightChunk((Entity)entity);
            }
            if (!unitVisible) continue;
            MinimapClientEvents.drawUnitOnMap(entity.m_20097_().m_123341_(), entity.m_20097_().m_123343_(), UnitClientEvents.getPlayerToEntityRelationship(entity));
        }
        for (MinimapUnit minimapUnit : minimapUnits) {
            if (MinimapClientEvents.MC.f_91074_ == null) continue;
            boolean minimapUnitVisible = true;
            if (FogManager.isEnabled()) {
                float brightness = FogManager.getPositionBrightness(minimapUnit.pos);
                minimapUnitVisible = brightness > 0.35f;
            } else if (FogOfWarClientEvents.isEnabled()) {
                minimapUnitVisible = FogOfWarClientEvents.isInBrightChunk(minimapUnit.pos);
            }
            if (!minimapUnitVisible) continue;
            String playerName = MinimapClientEvents.MC.f_91074_.m_7755_().getString();
            String unitOwnerName = minimapUnit.ownerName;
            Relationship relationship = Relationship.HOSTILE;
            if (playerName.equals(unitOwnerName)) {
                relationship = Relationship.OWNED;
            } else if (unitOwnerName.isBlank()) {
                relationship = Relationship.NEUTRAL;
            } else if (AlliancesClient.isAllied(playerName, unitOwnerName)) {
                relationship = Relationship.FRIENDLY;
            }
            MinimapClientEvents.drawUnitOnMap(minimapUnit.pos.m_123341_(), minimapUnit.pos.m_123343_(), relationship);
        }
    }

    private static void drawUnitOnMap(int xc, int zc, Relationship relationship) {
        for (int x = xc - 3; x < xc + 3; ++x) {
            for (int z = zc - 3; z < zc + 3; ++z) {
                if (!MinimapClientEvents.isWorldXZinsideMap(x, z)) continue;
                int x0 = x - xc + 3;
                int z0 = z - zc + 3;
                int rgb = 0;
                if (x0 >= 1 && x0 < 5 && z0 >= 1 && z0 < 5) {
                    switch (relationship) {
                        case OWNED: {
                            rgb = 65280;
                            break;
                        }
                        case FRIENDLY: {
                            rgb = 0x3232FF;
                            break;
                        }
                        case HOSTILE: {
                            rgb = 0xFF0000;
                            break;
                        }
                        case NEUTRAL: {
                            rgb = 0xFFFF00;
                        }
                    }
                }
                int xN = x - xc_world + mapGuiRadius * 2;
                int zN = z - zc_world + mapGuiRadius * 2;
                MinimapClientEvents.mapColoursOverlays[xN][zN] = MiscUtil.reverseHexRGB(rgb) | 0xFF000000;
            }
        }
    }

    private static void drawPlayerOnMap(int xc, int zc, Player player) {
        String thatPlayerName;
        if (MinimapClientEvents.MC.f_91074_ == null) {
            return;
        }
        String thisPlayerName = MinimapClientEvents.MC.f_91074_.m_7755_().getString();
        if (thisPlayerName.equals(thatPlayerName = player.m_7755_().getString())) {
            return;
        }
        if (player.m_5833_() || player.m_7500_()) {
            return;
        }
        for (int x = xc - 5; x < xc + 5; ++x) {
            for (int z = zc - 5; z < zc + 5; ++z) {
                if (!MinimapClientEvents.isWorldXZinsideMap(x, z)) continue;
                int x0 = x - xc + 5;
                int z0 = z - zc + 5;
                int rgb = 0;
                if (x0 >= 1 && x0 < 9 && z0 >= 1 && z0 < 9) {
                    rgb = AlliancesClient.isAllied(thisPlayerName, thatPlayerName) ? 0x3232FF : 0xFF0000;
                }
                int xN = x - xc_world + mapGuiRadius * 2;
                int zN = z - zc_world + mapGuiRadius * 2;
                MinimapClientEvents.mapColoursOverlays[xN][zN] = MiscUtil.reverseHexRGB(rgb) | 0xFF000000;
            }
        }
    }

    private static void drawStartingPosesOnMap() {
        if (MinimapClientEvents.MC.f_91074_ == null) {
            return;
        }
        for (StartPos startPos : StartPosClientEvents.startPoses) {
            int xc = startPos.pos.m_123341_();
            int zc = startPos.pos.m_123343_();
            for (int x = xc - 7; x < xc + 7; ++x) {
                for (int z = zc - 7; z < zc + 7; ++z) {
                    if (!MinimapClientEvents.isWorldXZinsideMap(x, z)) continue;
                    int x0 = x - xc + 7;
                    int z0 = z - zc + 7;
                    int rgb = 0;
                    if (x0 >= 2 && x0 < 12 && z0 >= 2 && z0 < 12) {
                        switch (MiscUtil.getClientsideRelationship(MinimapClientEvents.MC.f_91074_.m_7755_().getString(), startPos.playerName)) {
                            default: {
                                throw new IncompatibleClassChangeError();
                            }
                            case OWNED: {
                                int n = 65280;
                                break;
                            }
                            case FRIENDLY: {
                                int n = 0x3232FF;
                                break;
                            }
                            case HOSTILE: {
                                int n = 0xFF0000;
                                break;
                            }
                            case NEUTRAL: {
                                int n = rgb = 0xFFFF00;
                            }
                        }
                        if (startPos.faction == Faction.NONE) {
                            rgb = 0xFFFF00;
                        }
                    }
                    int xN = x - xc_world + mapGuiRadius * 2;
                    int zN = z - zc_world + mapGuiRadius * 2;
                    MinimapClientEvents.mapColoursOverlays[xN][zN] = MiscUtil.reverseHexRGB(rgb) | 0xFF000000;
                }
            }
        }
    }

    public static boolean isWorldXZinsideMap(int x, int z) {
        return x >= xc_world - worldRadius && x < xc_world + worldRadius && z >= zc_world - worldRadius && z < zc_world + worldRadius;
    }

    private static void renderMap(GuiGraphics guiGraphics) {
        PoseStack stack = guiGraphics.m_280168_();
        Matrix4f matrix4f = stack.m_85850_().m_252922_();
        xl = MC.m_91268_().m_85445_() - mapGuiRadius * 2 - 10;
        xc = MC.m_91268_().m_85445_() - mapGuiRadius - 10;
        xr = MC.m_91268_().m_85445_() - 10;
        yt = MC.m_91268_().m_85446_() - mapGuiRadius * 2 - 10;
        yc = MC.m_91268_().m_85446_() - mapGuiRadius - 10;
        yb = MC.m_91268_().m_85446_() - 10;
        float xl_bg = xl - 6.0f;
        float xc_bg = xc;
        float xr_bg = xr + 6.0f;
        float yt_bg = yt - 6.0f;
        float yc_bg = yc;
        float yb_bg = yb + 6.0f;
        ResourceLocation iconFrameResource = new ResourceLocation("reignofnether", "textures/hud/map_background.png");
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)iconFrameResource);
        RenderSystem.setShader(GameRenderer::m_172817_);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix4f, xc_bg, yb_bg, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
        bufferbuilder.m_252986_(matrix4f, xr_bg, yc_bg, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
        bufferbuilder.m_252986_(matrix4f, xc_bg, yt_bg, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
        bufferbuilder.m_252986_(matrix4f, xl_bg, yc_bg, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        VertexConsumer consumer = buffer.m_6299_(mapRenderType);
        consumer.m_252986_(matrix4f, xc, yb, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_85969_(255).m_5752_();
        consumer.m_252986_(matrix4f, xr, yc, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_85969_(255).m_5752_();
        consumer.m_252986_(matrix4f, xc, yt, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_85969_(255).m_5752_();
        consumer.m_252986_(matrix4f, xl, yc, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_85969_(255).m_5752_();
        buffer.m_109911_();
    }

    public static boolean isPointInsideMinimap(double x, double y) {
        double dy;
        double dx = Math.abs(x - (double)xc);
        double d = dx / (double)(mapGuiRadius * 2) + (dy = Math.abs(y - (double)yc)) / (double)(mapGuiRadius * 2);
        return d <= 0.5;
    }

    private static BlockPos getWorldPosOnMinimap(float x, float y, boolean offsetForCamera) {
        if (!MinimapClientEvents.isPointInsideMinimap(x, y) || CursorClientEvents.isBoxSelecting() || MinimapClientEvents.MC.f_91073_ == null) {
            return null;
        }
        float pixelsToBlocks = (float)worldRadius / (float)mapGuiRadius;
        if (offsetForCamera) {
            y += OrthoviewClientEvents.getZoom() * 0.5f / pixelsToBlocks;
        }
        Vec2 clicked = MyMath.rotateCoords(x - xc, y - yc, 45.0);
        double xWorld = (double)xc_world + (double)(clicked.f_82470_ * pixelsToBlocks) * Math.sqrt(2.0);
        double zWorld = (double)zc_world + (double)(clicked.f_82471_ * pixelsToBlocks) * Math.sqrt(2.0);
        double yWorld = MiscUtil.getHighestNonAirBlock((Level)MinimapClientEvents.MC.f_91073_, new BlockPos((int)xWorld, 0, (int)zWorld)).m_123342_();
        return new BlockPos((int)xWorld, (int)yWorld, (int)zWorld);
    }

    @SubscribeEvent
    public static void onMouseDrag(ScreenEvent.MouseDragged.Pre evt) {
        if (OrthoviewClientEvents.isEnabled() && evt.getMouseButton() == 0 && !Keybindings.shiftMod.isDown() && !OrthoviewClientEvents.isCameraLocked() && lastDragTeleportTimestamp < System.currentTimeMillis() - 100L) {
            lastDragTeleportTimestamp = System.currentTimeMillis();
            BlockPos moveTo = MinimapClientEvents.getWorldPosOnMinimap((float)evt.getMouseX(), (float)evt.getMouseY(), true);
            if (MinimapClientEvents.MC.f_91074_ != null && moveTo != null) {
                PlayerServerboundPacket.teleportPlayer(Double.valueOf(moveTo.m_123341_()), MinimapClientEvents.MC.f_91074_.m_20186_(), Double.valueOf(moveTo.m_123343_()));
            }
        }
    }

    @SubscribeEvent
    public static void onMouseClick(ScreenEvent.MouseButtonPressed.Pre evt) {
        if (!OrthoviewClientEvents.isEnabled() || OrthoviewClientEvents.isCameraLocked()) {
            return;
        }
        if (evt.getButton() == 0 && !HudClientEvents.isMouseOverAnyButton()) {
            BlockPos moveTo = MinimapClientEvents.getWorldPosOnMinimap((float)evt.getMouseX(), (float)evt.getMouseY(), true);
            if (MinimapClientEvents.MC.f_91074_ != null && moveTo != null) {
                if (Keybindings.shiftMod.isDown()) {
                    MinimapClientEvents.setMapCentre(moveTo.m_123341_(), moveTo.m_123343_());
                    forceUpdateAllPartitions = true;
                    TutorialClientEvents.clickedMinimap = true;
                    PlayerServerboundPacket.teleportPlayer(Double.valueOf(moveTo.m_123341_()), MinimapClientEvents.MC.f_91074_.m_20186_(), Double.valueOf(moveTo.m_123343_()));
                } else {
                    TutorialClientEvents.clickedMinimap = true;
                    PlayerServerboundPacket.teleportPlayer(Double.valueOf(moveTo.m_123341_()), MinimapClientEvents.MC.f_91074_.m_20186_(), Double.valueOf(moveTo.m_123343_()));
                }
            }
        } else if (evt.getButton() == 1) {
            BlockPos moveTo = MinimapClientEvents.getWorldPosOnMinimap((float)evt.getMouseX(), (float)evt.getMouseY(), false);
            if (UnitClientEvents.getSelectedUnits().size() > 0 && moveTo != null) {
                UnitClientEvents.sendUnitCommandManual(UnitAction.MOVE, -1, UnitClientEvents.getSelectedUnits().stream().mapToInt(Entity::m_19879_).toArray(), moveTo);
            }
        }
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiOverlayEvent.Post evt) {
        if (!OrthoviewClientEvents.isEnabled() || MC.m_91104_() || !TutorialClientEvents.isAtOrPastStage(TutorialStage.MINIMAP_CLICK)) {
            return;
        }
        if (shouldToggleSize) {
            shouldToggleSize = false;
            MinimapClientEvents.toggleMapSize();
        }
        MinimapClientEvents.renderMap(evt.getGuiGraphics());
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END) {
            return;
        }
        MinimapClientEvents.updateMapTerrain(terrainPartition, darkTerrainPartition);
        mapColoursOverlays = new int[worldRadius * 2][worldRadius * 2];
        if (TimeClientEvents.nightCircleMode != NightCircleMode.OFF) {
            MinimapClientEvents.updateNightCircles();
        }
        MinimapClientEvents.updateMapUnitsAndBuildings();
        MinimapClientEvents.updateMapViewQuad();
        if (++terrainPartition > 10) {
            terrainPartition = 1;
            if (++darkTerrainPartition > 5) {
                darkTerrainPartition = 1;
            }
        }
        MinimapClientEvents.updateMapTexture();
    }

    static {
        minimapUnits = new ArrayList();
        lockedMap = false;
    }

    private static class MinimapUnit {
        public BlockPos pos;
        public final int id;
        public final String ownerName;

        public MinimapUnit(BlockPos pos, int id, String ownerName) {
            this.pos = pos;
            this.id = id;
            this.ownerName = ownerName;
        }
    }
}

